/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.reports;

import jakarta.inject.Inject;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.poi.ss.util.WorkbookUtil;
import org.jxls.common.Context;
import org.traccar.config.Config;
import org.traccar.config.Keys;
import org.traccar.helper.model.DeviceUtil;
import org.traccar.model.Device;
import org.traccar.model.Event;
import org.traccar.model.Geofence;
import org.traccar.model.Group;
import org.traccar.model.Maintenance;
import org.traccar.model.Position;
import org.traccar.reports.common.ReportUtils;
import org.traccar.reports.model.DeviceReportSection;
import org.traccar.storage.Storage;
import org.traccar.storage.StorageException;
import org.traccar.storage.query.Columns;
import org.traccar.storage.query.Condition;
import org.traccar.storage.query.Order;
import org.traccar.storage.query.Request;

public class EventsReportProvider {
    private final Config config;
    private final ReportUtils reportUtils;
    private final Storage storage;

    @Inject
    public EventsReportProvider(Config config, ReportUtils reportUtils, Storage storage) {
        this.config = config;
        this.reportUtils = reportUtils;
        this.storage = storage;
    }

    private List<Event> getEvents(long deviceId, Date from, Date to) throws StorageException {
        return this.storage.getObjects(Event.class, new Request(new Columns.All(), new Condition.And(new Condition.Equals("deviceId", deviceId), new Condition.Between("eventTime", "from", from, "to", to)), new Order("eventTime")));
    }

    private boolean filterType(Collection<String> types, Collection<String> alarms, Event event) {
        if (!types.contains(event.getType())) {
            return false;
        }
        return !event.getType().equals("alarm") || alarms.isEmpty() || alarms.contains(event.getString("alarm"));
    }

    public Collection<Event> getObjects(long userId, Collection<Long> deviceIds, Collection<Long> groupIds, Collection<String> types, Collection<String> alarms, Date from, Date to) throws StorageException {
        this.reportUtils.checkPeriodLimit(from, to);
        ArrayList<Event> result = new ArrayList<Event>();
        for (Device device : DeviceUtil.getAccessibleDevices(this.storage, userId, deviceIds, groupIds)) {
            List<Event> events = this.getEvents(device.getId(), from, to);
            boolean all = types.isEmpty() || types.contains("allEvents");
            for (Event event : events) {
                if (!all && !this.filterType(types, alarms, event)) continue;
                long geofenceId = event.getGeofenceId();
                long maintenanceId = event.getMaintenanceId();
                if (geofenceId != 0L && this.reportUtils.getObject(userId, Geofence.class, geofenceId) == null || maintenanceId != 0L && this.reportUtils.getObject(userId, Maintenance.class, maintenanceId) == null) continue;
                result.add(event);
            }
        }
        return result;
    }

    public void getExcel(OutputStream outputStream, long userId, Collection<Long> deviceIds, Collection<Long> groupIds, Collection<String> types, Collection<String> alarms, Date from, Date to) throws StorageException, IOException {
        this.reportUtils.checkPeriodLimit(from, to);
        ArrayList<DeviceReportSection> devicesEvents = new ArrayList<DeviceReportSection>();
        ArrayList<String> sheetNames = new ArrayList<String>();
        HashMap<Long, String> geofenceNames = new HashMap<Long, String>();
        HashMap<Long, String> maintenanceNames = new HashMap<Long, String>();
        HashMap<Long, Position> positions = new HashMap<Long, Position>();
        for (Device device : DeviceUtil.getAccessibleDevices(this.storage, userId, deviceIds, groupIds)) {
            Group group;
            List<Event> events = this.getEvents(device.getId(), from, to);
            boolean all = types.isEmpty() || types.contains("allEvents");
            Iterator iterator = events.iterator();
            while (iterator.hasNext()) {
                Event event = (Event)iterator.next();
                if (all || this.filterType(types, alarms, event)) {
                    long geofenceId = event.getGeofenceId();
                    long maintenanceId = event.getMaintenanceId();
                    if (geofenceId != 0L) {
                        Geofence geofence = this.reportUtils.getObject(userId, Geofence.class, geofenceId);
                        if (geofence != null) {
                            geofenceNames.put(geofenceId, geofence.getName());
                            continue;
                        }
                        iterator.remove();
                        continue;
                    }
                    if (maintenanceId == 0L) continue;
                    Maintenance maintenance = this.reportUtils.getObject(userId, Maintenance.class, maintenanceId);
                    if (maintenance != null) {
                        maintenanceNames.put(maintenanceId, maintenance.getName());
                        continue;
                    }
                    iterator.remove();
                    continue;
                }
                iterator.remove();
            }
            for (Event event : events) {
                long positionId = event.getPositionId();
                if (positionId <= 0L) continue;
                Position position = this.storage.getObject(Position.class, new Request((Columns)new Columns.All(), new Condition.Equals("id", positionId)));
                positions.put(positionId, position);
            }
            DeviceReportSection deviceEvents = new DeviceReportSection();
            deviceEvents.setDeviceName(device.getName());
            sheetNames.add(WorkbookUtil.createSafeSheetName((String)deviceEvents.getDeviceName()));
            if (device.getGroupId() > 0L && (group = this.storage.getObject(Group.class, new Request((Columns)new Columns.All(), new Condition.Equals("id", device.getGroupId())))) != null) {
                deviceEvents.setGroupName(group.getName());
            }
            deviceEvents.setObjects(events);
            devicesEvents.add(deviceEvents);
        }
        File file = Paths.get(this.config.getString(Keys.TEMPLATES_ROOT), "export", "events.xlsx").toFile();
        try (FileInputStream inputStream = new FileInputStream(file);){
            Context context = this.reportUtils.initializeContext(userId);
            context.putVar("devices", devicesEvents);
            context.putVar("sheetNames", sheetNames);
            context.putVar("geofenceNames", geofenceNames);
            context.putVar("maintenanceNames", maintenanceNames);
            context.putVar("positions", positions);
            context.putVar("from", (Object)from);
            context.putVar("to", (Object)to);
            this.reportUtils.processTemplateWithSheets(inputStream, outputStream, context);
        }
    }
}

