/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import com.google.common.annotations.VisibleForTesting;
import com.google.firebase.ErrorCode;
import com.google.firebase.FirebaseException;
import com.google.firebase.IncomingHttpResponse;
import com.google.firebase.internal.NonNull;
import com.google.firebase.internal.Nullable;
import com.google.firebase.messaging.MessagingErrorCode;

public final class FirebaseMessagingException
extends FirebaseException {
    private final MessagingErrorCode errorCode;

    @VisibleForTesting
    FirebaseMessagingException(@NonNull ErrorCode code, @NonNull String message) {
        this(code, message, null, null, null);
    }

    private FirebaseMessagingException(@NonNull ErrorCode code, @NonNull String message, @Nullable Throwable cause, @Nullable IncomingHttpResponse response, @Nullable MessagingErrorCode errorCode) {
        super(code, message, cause, response);
        this.errorCode = errorCode;
    }

    static FirebaseMessagingException withMessagingErrorCode(FirebaseException base, @Nullable MessagingErrorCode errorCode) {
        return new FirebaseMessagingException(base.getErrorCode(), base.getMessage(), base.getCause(), base.getHttpResponse(), errorCode);
    }

    static FirebaseMessagingException withCustomMessage(FirebaseException base, String message) {
        return new FirebaseMessagingException(base.getErrorCode(), message, base.getCause(), base.getHttpResponse(), null);
    }

    @Nullable
    public MessagingErrorCode getMessagingErrorCode() {
        return this.errorCode;
    }
}

