/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import org.armedbear.lisp.Cons;
import org.armedbear.lisp.Debug;
import org.armedbear.lisp.DocString;
import org.armedbear.lisp.Function;
import org.armedbear.lisp.Keyword;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.Primitive;
import org.armedbear.lisp.StandardClass;
import org.armedbear.lisp.StandardObject;
import org.armedbear.lisp.Symbol;

public final class SlotDefinition
extends StandardObject {
    private static final Primitive MAKE_SLOT_DEFINITION = new pf_make_slot_definition();

    private SlotDefinition() {
        super(StandardClass.STANDARD_SLOT_DEFINITION, StandardClass.STANDARD_SLOT_DEFINITION.getClassLayout().getLength());
        this.setInstanceSlotValue(Symbol.LOCATION, Lisp.NIL);
        this.setInstanceSlotValue(Symbol._TYPE, Lisp.T);
        this.setInstanceSlotValue(Symbol._DOCUMENTATION, Lisp.NIL);
    }

    private SlotDefinition(StandardClass clazz) {
        super(clazz, clazz.getClassLayout().getLength());
        this.setInstanceSlotValue(Symbol.LOCATION, Lisp.NIL);
    }

    public SlotDefinition(StandardClass clazz, LispObject name) {
        super(clazz, clazz.getClassLayout().getLength());
        Debug.assertTrue(name instanceof Symbol);
        this.setInstanceSlotValue(Symbol.NAME, name);
        this.setInstanceSlotValue(Symbol.INITFUNCTION, Lisp.NIL);
        this.setInstanceSlotValue(Symbol.INITARGS, new Cons(Lisp.PACKAGE_KEYWORD.intern(((Symbol)name).getName())));
        this.setInstanceSlotValue(Symbol.READERS, Lisp.NIL);
        this.setInstanceSlotValue(Symbol.ALLOCATION, Keyword.INSTANCE);
        this.setInstanceSlotValue(Symbol.LOCATION, Lisp.NIL);
        this.setInstanceSlotValue(Symbol._TYPE, Lisp.T);
        this.setInstanceSlotValue(Symbol._DOCUMENTATION, Lisp.NIL);
    }

    public SlotDefinition(LispObject name, LispObject readers) {
        this();
        Debug.assertTrue(name instanceof Symbol);
        this.setInstanceSlotValue(Symbol.NAME, name);
        this.setInstanceSlotValue(Symbol.INITFUNCTION, Lisp.NIL);
        this.setInstanceSlotValue(Symbol.INITARGS, new Cons(Lisp.PACKAGE_KEYWORD.intern(((Symbol)name).getName())));
        this.setInstanceSlotValue(Symbol.READERS, readers);
        this.setInstanceSlotValue(Symbol.ALLOCATION, Keyword.INSTANCE);
    }

    public SlotDefinition(LispObject name, LispObject readers, LispObject initForm) {
        this();
        Debug.assertTrue(name instanceof Symbol);
        this.setInstanceSlotValue(Symbol.NAME, name);
        this.setInstanceSlotValue(Symbol.INITFUNCTION, Lisp.NIL);
        this.setInstanceSlotValue(Symbol.INITFORM, initForm);
        this.setInstanceSlotValue(Symbol.INITARGS, new Cons(Lisp.PACKAGE_KEYWORD.intern(((Symbol)name).getName())));
        this.setInstanceSlotValue(Symbol.READERS, readers);
        this.setInstanceSlotValue(Symbol.ALLOCATION, Keyword.INSTANCE);
    }

    public SlotDefinition(LispObject name, LispObject readers, Function initFunction) {
        this();
        Debug.assertTrue(name instanceof Symbol);
        this.setInstanceSlotValue(Symbol.NAME, name);
        this.setInstanceSlotValue(Symbol.INITFUNCTION, initFunction);
        this.setInstanceSlotValue(Symbol.INITFORM, Lisp.NIL);
        this.setInstanceSlotValue(Symbol.INITARGS, new Cons(Lisp.PACKAGE_KEYWORD.intern(((Symbol)name).getName())));
        this.setInstanceSlotValue(Symbol.READERS, readers);
        this.setInstanceSlotValue(Symbol.ALLOCATION, Keyword.INSTANCE);
    }

    public SlotDefinition(LispObject name, LispObject readers, Function initFunction, LispObject initargs) {
        this();
        Debug.assertTrue(name instanceof Symbol);
        this.setInstanceSlotValue(Symbol.NAME, name);
        this.setInstanceSlotValue(Symbol.INITFUNCTION, initFunction);
        this.setInstanceSlotValue(Symbol.INITFORM, Lisp.NIL);
        this.setInstanceSlotValue(Symbol.INITARGS, initargs);
        this.setInstanceSlotValue(Symbol.READERS, readers);
        this.setInstanceSlotValue(Symbol.ALLOCATION, Keyword.INSTANCE);
    }

    @Override
    public String printObject() {
        StringBuilder sb = new StringBuilder(Symbol.SLOT_DEFINITION.printObject());
        LispObject name = this.getInstanceSlotValue(Symbol.NAME);
        if (name != null && name != Lisp.NIL) {
            sb.append(' ');
            sb.append(name.printObject());
        }
        return this.unreadableString(sb.toString());
    }

    @DocString(name="%make-slot-definition", args="slot-class", doc="Argument must be a subclass of standard-slot-definition")
    private static final class pf_make_slot_definition
    extends Primitive {
        pf_make_slot_definition() {
            super("%make-slot-definition", Lisp.PACKAGE_SYS, true, "slot-class");
        }

        @Override
        public LispObject execute(LispObject slotDefinitionClass) {
            if (!(slotDefinitionClass instanceof StandardClass)) {
                return Lisp.type_error(slotDefinitionClass, StandardClass.STANDARD_SLOT_DEFINITION);
            }
            return new SlotDefinition((StandardClass)slotDefinitionClass);
        }
    }
}

