/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.etl;

import ca.sqlpower.sqlobject.SQLColumn;
import ca.sqlpower.sqlobject.SQLObjectException;
import ca.sqlpower.sqlobject.SQLTable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class ETLUtils {
    private ETLUtils() {
    }

    public static Map<SQLTable, Collection<SQLTable>> findTableLevelMappings(Collection<SQLTable> targetTables) throws SQLObjectException {
        HashMap<SQLTable, Collection<SQLTable>> mappings = new HashMap<SQLTable, Collection<SQLTable>>();
        for (SQLTable t : targetTables) {
            HashSet<SQLTable> sources = new HashSet<SQLTable>();
            for (SQLColumn c : t.getColumns()) {
                SQLColumn sc = c.getSourceColumn();
                if (sc != null) {
                    sources.add(sc.getParent());
                    continue;
                }
                sources.add(null);
            }
            for (SQLTable st : sources) {
                ArrayList<SQLTable> targets = (ArrayList<SQLTable>)mappings.get(st);
                if (targets == null) {
                    targets = new ArrayList<SQLTable>();
                    mappings.put(st, targets);
                }
                targets.add(t);
            }
        }
        return mappings;
    }
}

