/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui.olap;

import ca.sqlpower.architect.olap.MondrianModel;
import ca.sqlpower.architect.olap.OLAPObject;
import ca.sqlpower.architect.olap.OLAPUtil;
import ca.sqlpower.architect.swingui.SQLObjectComboBoxModel;
import ca.sqlpower.architect.swingui.olap.OLAPObjectNameValidator;
import ca.sqlpower.sqlobject.SQLColumn;
import ca.sqlpower.sqlobject.SQLObject;
import ca.sqlpower.sqlobject.SQLObjectException;
import ca.sqlpower.sqlobject.SQLTable;
import ca.sqlpower.validation.Validator;
import ca.sqlpower.validation.swingui.FormValidationHandler;
import ca.sqlpower.validation.swingui.NotNullValidator;
import ca.sqlpower.validation.swingui.StatusComponent;
import ca.sqlpower.validation.swingui.ValidatableDataEntryPanel;
import ca.sqlpower.validation.swingui.ValidationHandler;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class DimensionEditPanel
implements ValidatableDataEntryPanel {
    private final MondrianModel.Dimension dimension;
    private final JPanel panel;
    private JTextField nameField;
    private JTextField captionField;
    private JComboBox typeBox;
    private JComboBox foreignKeyChooser;
    private FormValidationHandler handler;
    private StatusComponent status = new StatusComponent();

    public DimensionEditPanel(MondrianModel.Dimension dimension) throws SQLObjectException {
        this.dimension = dimension;
        FormLayout layout = new FormLayout("left:max(40dlu;pref), 3dlu, 80dlu:grow", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.setDefaultDialogBorder();
        builder.append((Component)this.status, 3);
        this.nameField = new JTextField(dimension.getName());
        builder.append("Name", (Component)this.nameField);
        this.captionField = new JTextField(dimension.getCaption());
        builder.append("Caption", (Component)this.captionField);
        this.typeBox = new JComboBox<DimensionType>(DimensionType.values());
        builder.append("Type", this.typeBox);
        if (dimension.getType() != null) {
            this.typeBox.setSelectedItem((Object)DimensionType.valueOf(dimension.getType()));
        } else {
            this.typeBox.setSelectedItem((Object)DimensionType.StandardDimension);
        }
        this.handler = new FormValidationHandler(this.status, true);
        OLAPObjectNameValidator validator = new OLAPObjectNameValidator((OLAPObject)dimension.getParent(), dimension, false);
        this.handler.addValidateObject((JComponent)this.nameField, (Validator)validator);
        if (dimension.getParent() instanceof MondrianModel.Cube) {
            this.foreignKeyChooser = new JComboBox();
            builder.append("Foreign Key", this.foreignKeyChooser);
            this.handler.addValidateObject((JComponent)this.foreignKeyChooser, (Validator)new NotNullValidator("Foreign key"));
            MondrianModel.Cube cube = (MondrianModel.Cube)dimension.getParent();
            SQLTable factTable = OLAPUtil.tableForCube(cube);
            if (factTable == null) {
                this.foreignKeyChooser.addItem("Parent Cube has no fact table");
                this.foreignKeyChooser.setEnabled(false);
            } else if (factTable.getColumns().isEmpty()) {
                this.foreignKeyChooser.addItem("Parent Cube Fact table has no columns");
                this.foreignKeyChooser.setEnabled(false);
            } else {
                this.foreignKeyChooser.setModel(new SQLObjectComboBoxModel((SQLObject)factTable, SQLColumn.class));
                for (SQLColumn col : factTable.getColumns()) {
                    if (!col.getName().equals(dimension.getForeignKey())) continue;
                    this.foreignKeyChooser.setSelectedItem(col);
                }
            }
        }
        this.panel = builder.getPanel();
    }

    public boolean applyChanges() {
        this.dimension.begin("Started modifying dimension properties");
        this.dimension.setName(this.nameField.getText());
        if (!this.captionField.getText().equals("")) {
            this.dimension.setCaption(this.captionField.getText());
        } else {
            this.dimension.setCaption(null);
        }
        DimensionType type = (DimensionType)((Object)this.typeBox.getSelectedItem());
        if (type != null) {
            this.dimension.setType(type.toString());
        } else {
            this.dimension.setType(DimensionType.StandardDimension.toString());
        }
        if (this.foreignKeyChooser != null && this.foreignKeyChooser.isEnabled()) {
            SQLColumn selectedCol = (SQLColumn)this.foreignKeyChooser.getSelectedItem();
            String pk = selectedCol.getName();
            this.dimension.setForeignKey(pk);
        }
        this.dimension.commit();
        return true;
    }

    public void discardChanges() {
    }

    public JComponent getPanel() {
        return this.panel;
    }

    public boolean hasUnsavedChanges() {
        return true;
    }

    public ValidationHandler getValidationHandler() {
        return this.handler;
    }

    private static enum DimensionType {
        StandardDimension,
        TimeDimension;

    }
}

