/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui.olap.action;

import ca.sqlpower.architect.olap.MondrianModel;
import ca.sqlpower.architect.olap.OLAPSession;
import ca.sqlpower.architect.swingui.ASUtils;
import ca.sqlpower.architect.swingui.ArchitectFrame;
import ca.sqlpower.architect.swingui.ArchitectSwingSession;
import ca.sqlpower.architect.swingui.action.AbstractArchitectAction;
import ca.sqlpower.architect.swingui.olap.OLAPEditSession;
import ca.sqlpower.architect.swingui.olap.SchemaEditPanel;
import ca.sqlpower.object.SPObject;
import ca.sqlpower.sqlobject.SQLObjectException;
import ca.sqlpower.swingui.DataEntryPanel;
import ca.sqlpower.swingui.DataEntryPanelBuilder;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.concurrent.Callable;
import javax.swing.JDialog;
import javax.swing.JFrame;

public class OLAPEditAction
extends AbstractArchitectAction {
    private OLAPSession olapSession;
    private final boolean newSchema;

    public OLAPEditAction(ArchitectSwingSession session, OLAPSession olapSession) {
        super(session, olapSession == null ? "New Schema..." : olapSession.getSchema().getName(), "Edit OLAP schema");
        this.olapSession = olapSession;
        this.newSchema = olapSession == null;
    }

    public OLAPEditAction(ArchitectFrame frame, OLAPSession olapSession) {
        super(frame, olapSession == null ? "New Schema..." : olapSession.getSchema().getName(), "Edit OLAP schema");
        this.olapSession = olapSession;
        this.newSchema = olapSession == null;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            MondrianModel.Schema schema;
            if (this.newSchema) {
                this.getSession().getWorkspace().begin("Opening OLAP schema");
                schema = new MondrianModel.Schema();
                schema.setName("New OLAP Schema");
                this.olapSession = new OLAPSession(schema);
                this.getSession().getOLAPRootObject().addChild((SPObject)this.olapSession);
            } else {
                schema = this.olapSession.getSchema();
            }
            OLAPEditSession editSession = this.getSession().getOLAPEditSession(this.olapSession);
            final JFrame frame = editSession.getFrame();
            frame.setLocationRelativeTo(this.getSession().getArchitectFrame());
            frame.setVisible(true);
            if (this.newSchema) {
                final SchemaEditPanel schemaEditPanel = new SchemaEditPanel(this.getSession(), schema);
                Callable<Boolean> okCall = new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        try {
                            boolean ok = schemaEditPanel.applyChanges();
                            OLAPEditAction.this.getSession().getWorkspace().commit();
                            return ok;
                        }
                        catch (Throwable e) {
                            OLAPEditAction.this.getSession().getWorkspace().rollback("Error applying changes: " + e.toString());
                            throw new RuntimeException(e);
                        }
                    }
                };
                Callable<Boolean> cancelCall = new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        frame.dispose();
                        OLAPEditAction.this.getSession().getOLAPRootObject().removeOLAPSession(OLAPEditAction.this.olapSession);
                        OLAPEditAction.this.getSession().getWorkspace().rollback("New OLAP session cancelled");
                        return true;
                    }
                };
                JDialog schemaEditDialog = DataEntryPanelBuilder.createDataEntryPanelDialog((DataEntryPanel)schemaEditPanel, (Component)frame, (String)"New Schema Properties", (String)DataEntryPanelBuilder.OK_BUTTON_LABEL, (Callable)okCall, (Callable)cancelCall);
                schemaEditDialog.setLocationRelativeTo(frame);
                schemaEditDialog.setVisible(true);
            }
        }
        catch (SQLObjectException ex) {
            this.getSession().getWorkspace().rollback("Error opening OLAP schema: " + ex.toString());
            ASUtils.showExceptionDialogNoReport(this.getSession().getArchitectFrame(), "Failed to get list of databases.", ex);
        }
        catch (Throwable ex) {
            this.getSession().getWorkspace().rollback("Error opening OLAP schema: " + ex.toString());
            throw new RuntimeException(ex);
        }
    }
}

