/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.swingui.db;

import ca.sqlpower.sql.DataSourceCollection;
import ca.sqlpower.sql.DatabaseListChangeEvent;
import ca.sqlpower.sql.DatabaseListChangeListener;
import ca.sqlpower.sql.JDBCDataSource;
import ca.sqlpower.sql.Olap4jDataSource;
import ca.sqlpower.sql.SPDataSource;
import ca.sqlpower.swingui.Messages;
import ca.sqlpower.swingui.SPSUtils;
import ca.sqlpower.swingui.db.DataSourceDialogFactory;
import ca.sqlpower.swingui.db.DataSourceTypeDialogFactory;
import ca.sqlpower.swingui.db.DefaultDataSourceDialogFactory;
import ca.sqlpower.swingui.db.DefaultDataSourceTypeDialogFactory;
import ca.sqlpower.swingui.table.CleanupTableModel;
import ca.sqlpower.swingui.table.EditableJTable;
import com.jgoodies.forms.builder.ButtonStackBuilder;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.debug.FormDebugPanel;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import org.apache.log4j.Logger;

public class DatabaseConnectionManager {
    private static Logger logger = Logger.getLogger(DatabaseConnectionManager.class);
    public static final Icon DB_ICON = new ImageIcon(DatabaseConnectionManager.class.getClassLoader().getResource("ca/sqlpower/swingui/db/connection-db-16.png"));
    public static final Icon OLAP_DB_ICON = new ImageIcon(DatabaseConnectionManager.class.getClassLoader().getResource("ca/sqlpower/swingui/db/connection-olap-16.png"));
    public static final String DISABLE_IF_NO_CONNECTION_SELECTED = "disableIfNoConnectionSelected";
    public static final String VERTICAL_TEXT_POSITION = "verticalTextPosition";
    public static final String ADDITIONAL_BUTTON_HEIGHT = "additionalButtonHeight";
    public static final String HORIZONTAL_TEXT_POSITION = "horizontalTextPosition";
    private final JPanel panel;
    private JDialog d;
    private Window currentOwner;
    private final DataSourceDialogFactory dsDialogFactory;
    private final DataSourceTypeDialogFactory dsTypeDialogFactory;
    private Icon dbIcon = DB_ICON;
    private final Action jdbcDriversAction = new AbstractAction(Messages.getString("DatabaseConnectionManager.jdbcDriversActionName")){

        @Override
        public void actionPerformed(ActionEvent e) {
            DatabaseConnectionManager.this.dsTypeDialogFactory.showDialog(DatabaseConnectionManager.this.currentOwner);
        }
    };
    private final Action editDatabaseConnectionAction = new AbstractAction(Messages.getString("DatabaseConnectionManager.editDbConnectionActionName")){

        @Override
        public void actionPerformed(ActionEvent e) {
            int selectedRow = DatabaseConnectionManager.this.dsTable.getSelectedRow();
            if (selectedRow == -1) {
                return;
            }
            SPDataSource ds = (SPDataSource)DatabaseConnectionManager.this.dsTable.getValueAt(selectedRow, 0);
            if (ds instanceof JDBCDataSource) {
                JDBCDataSource jdbcDS = (JDBCDataSource)ds;
                Runnable onOk = this.createOnOk(ds);
                DatabaseConnectionManager.this.dsDialogFactory.showDialog(DatabaseConnectionManager.this.d != null ? DatabaseConnectionManager.this.d : DatabaseConnectionManager.this.currentOwner, jdbcDS, onOk);
            } else if (ds instanceof Olap4jDataSource) {
                Olap4jDataSource jdbcDS = (Olap4jDataSource)ds;
                Runnable onOk = this.createOnOk(ds);
                DatabaseConnectionManager.this.dsDialogFactory.showDialog(DatabaseConnectionManager.this.d != null ? DatabaseConnectionManager.this.d : DatabaseConnectionManager.this.currentOwner, jdbcDS, DatabaseConnectionManager.this.getPlDotIni(), onOk);
            } else {
                throw new IllegalStateException("Unknown SPDataSource type in the connection manager. Type is " + ds.getClass());
            }
        }

        private Runnable createOnOk(final SPDataSource ds) {
            Runnable onOk = new Runnable(){

                @Override
                public void run() {
                    try {
                        for (int i = 0; i < DatabaseConnectionManager.this.dsTable.getRowCount(); ++i) {
                            if (DatabaseConnectionManager.this.dsTable.getValueAt(i, 0) != ds) continue;
                            DatabaseConnectionManager.this.dsTable.setRowSelectionInterval(i, i);
                            DatabaseConnectionManager.this.dsTable.scrollRectToVisible(DatabaseConnectionManager.this.dsTable.getCellRect(i, 0, true));
                            DatabaseConnectionManager.this.dsTable.repaint();
                            break;
                        }
                    }
                    catch (Exception ex) {
                        SPSUtils.showExceptionDialogNoReport(DatabaseConnectionManager.this.d != null ? DatabaseConnectionManager.this.d : DatabaseConnectionManager.this.currentOwner, "Unexpected exception while editing a database connection.", ex);
                    }
                }
            };
            return onOk;
        }
    };
    private final Action removeDatabaseConnectionAction = new AbstractAction(Messages.getString("DatabaseConnectionManager.removeDbConnectionActionName")){

        @Override
        public void actionPerformed(ActionEvent e) {
            int selectedRow = DatabaseConnectionManager.this.dsTable.getSelectedRow();
            if (selectedRow == -1) {
                return;
            }
            SPDataSource dbcs = (SPDataSource)DatabaseConnectionManager.this.dsTable.getValueAt(selectedRow, 0);
            int option = JOptionPane.showConfirmDialog(DatabaseConnectionManager.this.d != null ? DatabaseConnectionManager.this.d : DatabaseConnectionManager.this.currentOwner, Messages.getString("DatabaseConnectionManager.deleteDbConnectionConfirmation", dbcs.getName()), Messages.getString("DatabaseConnectionManager.removeButton"), 0);
            if (option != 0) {
                return;
            }
            DatabaseConnectionManager.this.dsCollection.removeDataSource(dbcs);
            DatabaseConnectionManager.this.dsTable.clearSelection();
            for (JButton b : DatabaseConnectionManager.this.additionalActionButtons) {
                Object disableValue = b.getAction().getValue(DatabaseConnectionManager.DISABLE_IF_NO_CONNECTION_SELECTED);
                if (!(disableValue instanceof Boolean) || !disableValue.equals(Boolean.TRUE)) continue;
                b.setEnabled(false);
            }
            DatabaseConnectionManager.this.removeDatabaseConnectionAction.setEnabled(false);
            DatabaseConnectionManager.this.editDatabaseConnectionAction.setEnabled(false);
            DatabaseConnectionManager.this.dsTable.repaint();
        }
    };
    private final Action closeAction = new AbstractAction(Messages.getString("DatabaseConnectionManager.closeActionName")){

        @Override
        public void actionPerformed(ActionEvent e) {
            DatabaseConnectionManager.this.d.dispose();
        }
    };
    private JTable dsTable;
    private final DataSourceCollection<SPDataSource> dsCollection;
    private List<JButton> additionalActionButtons = new ArrayList<JButton>();
    private List<Class<? extends SPDataSource>> creatableDSTypes;

    public DatabaseConnectionManager(DataSourceCollection<SPDataSource> dsCollection) {
        this(dsCollection, new DefaultDataSourceDialogFactory(), new DefaultDataSourceTypeDialogFactory(dsCollection), Collections.EMPTY_LIST);
    }

    public DatabaseConnectionManager(DataSourceCollection<SPDataSource> dsCollection, DataSourceDialogFactory dsDialogFactory, DataSourceTypeDialogFactory dsTypeDialogFactory, List<Action> additionalActions, List<JComponent> additionalComponents, Window owner, boolean showCloseButton) {
        this(dsCollection, dsDialogFactory, dsTypeDialogFactory, additionalActions, additionalComponents, owner, showCloseButton, new ArrayList<Class<? extends SPDataSource>>(Collections.singleton(JDBCDataSource.class)));
    }

    public DatabaseConnectionManager(DataSourceCollection<SPDataSource> dsCollection, DataSourceDialogFactory dsDialogFactory, DataSourceTypeDialogFactory dsTypeDialogFactory, List<Action> additionalActions, List<JComponent> additionalComponents, Window owner, boolean showCloseButton, List<Class<? extends SPDataSource>> dsTypes) {
        this.dsCollection = dsCollection;
        this.dsDialogFactory = dsDialogFactory;
        this.dsTypeDialogFactory = dsTypeDialogFactory;
        logger.debug((Object)("Window owner is " + owner));
        this.currentOwner = owner;
        this.panel = this.createPanel(additionalActions, additionalComponents, showCloseButton, Messages.getString("DatabaseConnectionManager.availableDbConnections"));
        this.creatableDSTypes = new ArrayList<Class<? extends SPDataSource>>(dsTypes);
    }

    public DatabaseConnectionManager(DataSourceCollection<SPDataSource> dsCollection, DataSourceDialogFactory dsDialogFactory, DataSourceTypeDialogFactory dsTypeDialogFactory, List<Action> additionalActions) {
        this(dsCollection, dsDialogFactory, dsTypeDialogFactory, additionalActions, new ArrayList<JComponent>(), null, true);
    }

    public DatabaseConnectionManager(DataSourceCollection dsCollection, DataSourceDialogFactory dsDialogFactory, DataSourceTypeDialogFactory dsTypeDialogFactory) {
        this(dsCollection, dsDialogFactory, dsTypeDialogFactory, Collections.EMPTY_LIST);
    }

    public void showDialog(Window owner) {
        if (this.d != null && this.d.isVisible() && this.currentOwner == owner) {
            this.d.setVisible(true);
            this.d.requestFocus();
            return;
        }
        if (this.d != null) {
            this.d.dispose();
        }
        if (this.panel.getParent() != null) {
            this.panel.getParent().remove(this.panel);
        }
        if (owner instanceof Dialog) {
            this.d = new JDialog((Dialog)owner);
        } else if (owner instanceof Frame) {
            this.d = new JDialog((Frame)owner);
        } else {
            throw new IllegalArgumentException("Owner has to be a Frame or Dialog.  You provided a " + (owner == null ? null : owner.getClass().getName()));
        }
        this.currentOwner = owner;
        this.d.setTitle(Messages.getString("DatabaseConnectionManager.dialogTitle"));
        this.d.getContentPane().add(this.panel);
        this.d.pack();
        this.d.setLocationRelativeTo(owner);
        SPSUtils.makeJDialogCancellable(this.d, this.closeAction);
        this.d.setVisible(true);
        this.d.requestFocus();
    }

    public void closeDialog() {
        if (this.d != null) {
            this.d.dispose();
        }
    }

    public void setDbIcon(Icon dbIcon) {
        this.dbIcon = dbIcon;
    }

    public JPanel createPanelStandalone(List<Action> additionalActions, List<JComponent> additionalComponents, boolean showCloseButton, String message, JDialog owner) {
        this.d = owner;
        return this.createPanel(additionalActions, additionalComponents, showCloseButton, message);
    }

    private JPanel createPanel(List<Action> additionalActions, List<JComponent> additionalComponents, boolean showCloseButton, String message) {
        FormLayout layout = new FormLayout("6dlu, fill:min(160dlu;default):grow, 6dlu, pref, 6dlu", " 6dlu,10dlu,6dlu,fill:min(180dlu;default):grow,10dlu");
        layout.setColumnGroups((int[][])new int[][]{{1, 3, 5}});
        CellConstraints cc = new CellConstraints();
        Object p = logger.isDebugEnabled() ? new FormDebugPanel(layout) : new JPanel((LayoutManager)layout);
        PanelBuilder pb = new PanelBuilder(layout, (JPanel)p);
        pb.setDefaultDialogBorder();
        pb.add((Component)new JLabel(message), cc.xyw(2, 2, 3));
        ConnectionTableModel tm = new ConnectionTableModel(this.dsCollection);
        this.dsTable = new EditableJTable(tm);
        this.dsTable.setTableHeader(null);
        this.dsTable.setShowGrid(false);
        this.dsTable.setSelectionMode(0);
        this.dsTable.addMouseListener(new DSTableMouseListener());
        this.dsTable.setDefaultRenderer(SPDataSource.class, new ConnectionTableCellRenderer());
        JScrollPane sp = new JScrollPane(this.dsTable);
        sp.getViewport().setBackground(this.dsTable.getBackground());
        pb.add((Component)sp, cc.xy(2, 4));
        ButtonStackBuilder bsb = new ButtonStackBuilder();
        JButton newButton = new JButton();
        NewConnectionAction newDatabaseConnectionAction = new NewConnectionAction(Messages.getString("DatabaseConnectionManager.newDbConnectionActionName"), newButton);
        newButton.setAction(newDatabaseConnectionAction);
        bsb.addGridded((JComponent)newButton);
        bsb.addRelatedGap();
        bsb.addGridded((JComponent)new JButton(this.editDatabaseConnectionAction));
        bsb.addRelatedGap();
        bsb.addGridded((JComponent)new JButton(this.removeDatabaseConnectionAction));
        this.removeDatabaseConnectionAction.setEnabled(false);
        this.editDatabaseConnectionAction.setEnabled(false);
        bsb.addUnrelatedGap();
        JButton jdbcDriversButton = new JButton(this.jdbcDriversAction);
        bsb.addGridded((JComponent)jdbcDriversButton);
        for (Action a : additionalActions) {
            Integer horizontalTextInt;
            Object horizontalTextPos;
            Integer verticalTextInt;
            Object verticalTextPos;
            Object heightValue;
            bsb.addUnrelatedGap();
            JButton b = new JButton(a);
            Object disableValue = a.getValue(DISABLE_IF_NO_CONNECTION_SELECTED);
            if (disableValue instanceof Boolean && disableValue.equals(Boolean.TRUE)) {
                b.setEnabled(false);
            }
            if ((heightValue = a.getValue(ADDITIONAL_BUTTON_HEIGHT)) instanceof Integer) {
                b.setPreferredSize(new Dimension((int)b.getPreferredSize().getWidth(), (Integer)heightValue));
            }
            if ((verticalTextPos = a.getValue(VERTICAL_TEXT_POSITION)) instanceof Integer && ((verticalTextInt = (Integer)verticalTextPos) == 1 || verticalTextInt == 3 || verticalTextInt == 0)) {
                b.setVerticalTextPosition(verticalTextInt);
            }
            if ((horizontalTextPos = a.getValue(HORIZONTAL_TEXT_POSITION)) instanceof Integer && ((horizontalTextInt = (Integer)horizontalTextPos) == 2 || horizontalTextInt == 4 || horizontalTextInt == 0 || horizontalTextInt == 10 || horizontalTextInt == 11)) {
                b.setHorizontalTextPosition(horizontalTextInt);
            }
            this.additionalActionButtons.add(b);
            bsb.addFixed((JComponent)b);
        }
        for (JComponent comp : additionalComponents) {
            bsb.addUnrelatedGap();
            bsb.addFixed(comp);
        }
        if (showCloseButton) {
            bsb.addUnrelatedGap();
            bsb.addGridded((JComponent)new JButton(this.closeAction));
        }
        pb.add((Component)bsb.getPanel(), cc.xy(4, 4));
        return pb.getPanel();
    }

    public DataSourceCollection<SPDataSource> getPlDotIni() {
        return this.dsCollection;
    }

    public SPDataSource getSelectedConnection() {
        int selectedRow = this.dsTable.getSelectedRow();
        if (selectedRow == -1) {
            return null;
        }
        return (SPDataSource)this.dsTable.getValueAt(selectedRow, 0);
    }

    public JPanel getPanel() {
        return this.panel;
    }

    private class DSTableMouseListener
    implements MouseListener {
        private DSTableMouseListener() {
        }

        private void updateAllButtonStates(MouseEvent evt) {
            for (JButton b : DatabaseConnectionManager.this.additionalActionButtons) {
                Object disableValue = b.getAction().getValue(DatabaseConnectionManager.DISABLE_IF_NO_CONNECTION_SELECTED);
                if (!(disableValue instanceof Boolean) || !disableValue.equals(Boolean.TRUE)) continue;
                if (DatabaseConnectionManager.this.getSelectedConnection() == null) {
                    b.setEnabled(false);
                    continue;
                }
                b.setEnabled(true);
            }
            if (DatabaseConnectionManager.this.getSelectedConnection() == null) {
                DatabaseConnectionManager.this.removeDatabaseConnectionAction.setEnabled(false);
                DatabaseConnectionManager.this.editDatabaseConnectionAction.setEnabled(false);
            } else {
                DatabaseConnectionManager.this.removeDatabaseConnectionAction.setEnabled(true);
                DatabaseConnectionManager.this.editDatabaseConnectionAction.setEnabled(true);
            }
        }

        @Override
        public void mouseClicked(MouseEvent evt) {
            if (evt.getClickCount() == 2) {
                DatabaseConnectionManager.this.editDatabaseConnectionAction.actionPerformed(null);
            }
        }

        @Override
        public void mousePressed(MouseEvent evt) {
            this.updateAllButtonStates(evt);
        }

        @Override
        public void mouseReleased(MouseEvent evt) {
            this.updateAllButtonStates(evt);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }
    }

    private class ConnectionTableCellRenderer
    implements TableCellRenderer {
        private ConnectionTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component comp = new DefaultTableCellRenderer().getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (comp instanceof JLabel) {
                if (value instanceof JDBCDataSource) {
                    ((JLabel)comp).setIcon(DatabaseConnectionManager.this.dbIcon);
                } else if (value instanceof Olap4jDataSource) {
                    ((JLabel)comp).setIcon(OLAP_DB_ICON);
                }
            }
            return comp;
        }
    }

    private static class ConnectionTableModel
    extends AbstractTableModel
    implements CleanupTableModel {
        private final DatabaseListChangeListener databaseListChangeListener = new DatabaseListChangeListener(){

            @Override
            public void databaseAdded(DatabaseListChangeEvent e) {
                ConnectionTableModel.this.fireTableDataChanged();
            }

            @Override
            public void databaseRemoved(DatabaseListChangeEvent e) {
                ConnectionTableModel.this.fireTableDataChanged();
            }
        };
        private final DataSourceCollection<SPDataSource> dsCollection;

        public ConnectionTableModel(DataSourceCollection<SPDataSource> dsCollection) {
            this.dsCollection = dsCollection;
            dsCollection.addDatabaseListChangeListener(this.databaseListChangeListener);
        }

        @Override
        public int getRowCount() {
            return this.dsCollection.getConnections().size();
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public String getColumnName(int columnIndex) {
            return Messages.getString("DatabaseConnectionManager.connectionName");
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return SPDataSource.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return this.dsCollection.getConnections().get(rowIndex);
        }

        @Override
        public void cleanup() {
            this.dsCollection.removeDatabaseListChangeListener(this.databaseListChangeListener);
        }
    }

    private class NewConnectionAction
    extends AbstractAction {
        private final JComponent parentComponent;

        public NewConnectionAction(String name, JComponent parentComponent) {
            super(name);
            this.parentComponent = parentComponent;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (DatabaseConnectionManager.this.creatableDSTypes.size() > 1) {
                JPopupMenu dsTypeMenu = new JPopupMenu();
                dsTypeMenu.setLocation(this.parentComponent.getLocationOnScreen());
                for (final Class dsType : DatabaseConnectionManager.this.creatableDSTypes) {
                    AbstractAction newDSAction = new AbstractAction(SPDataSource.getUserFriendlyName(dsType) + "..."){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            NewConnectionAction.this.showNewDSDialog(dsType);
                        }
                    };
                    JMenuItem dsItem = new JMenuItem(newDSAction);
                    if (dsType.equals(JDBCDataSource.class)) {
                        dsItem.setIcon(DB_ICON);
                    } else if (dsType.equals(Olap4jDataSource.class)) {
                        dsItem.setIcon(OLAP_DB_ICON);
                    }
                    dsTypeMenu.add(dsItem);
                }
                dsTypeMenu.show(this.parentComponent, 0, 0);
            } else {
                Iterator iterator = DatabaseConnectionManager.this.creatableDSTypes.iterator();
                Class dsTypeToCreate = (Class)iterator.next();
                this.showNewDSDialog(dsTypeToCreate);
            }
        }

        public void showNewDSDialog(Class<? extends SPDataSource> dsTypeToCreate) {
            if (dsTypeToCreate.equals(JDBCDataSource.class)) {
                final JDBCDataSource ds = new JDBCDataSource((DataSourceCollection)DatabaseConnectionManager.this.getPlDotIni());
                Runnable onOk = new Runnable(){

                    @Override
                    public void run() {
                        DatabaseConnectionManager.this.dsCollection.addDataSource(ds);
                        DatabaseConnectionManager.this.dsTable.updateUI();
                    }
                };
                DatabaseConnectionManager.this.dsDialogFactory.showDialog(DatabaseConnectionManager.this.d != null ? DatabaseConnectionManager.this.d : DatabaseConnectionManager.this.currentOwner, ds, onOk);
            } else if (dsTypeToCreate.equals(Olap4jDataSource.class)) {
                final Olap4jDataSource ds = new Olap4jDataSource(DatabaseConnectionManager.this.getPlDotIni());
                Runnable onOk = new Runnable(){

                    @Override
                    public void run() {
                        DatabaseConnectionManager.this.dsCollection.addDataSource(ds);
                        DatabaseConnectionManager.this.dsTable.updateUI();
                    }
                };
                DatabaseConnectionManager.this.dsDialogFactory.showDialog(DatabaseConnectionManager.this.d != null ? DatabaseConnectionManager.this.d : DatabaseConnectionManager.this.currentOwner, ds, DatabaseConnectionManager.this.getPlDotIni(), onOk);
            } else {
                throw new IllegalStateException("Cannot make a new data source of type " + dsTypeToCreate);
            }
        }
    }
}

