/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.config.JitsiConfig;
import org.jitsi.metaconfig.ConfigDelegate;
import org.jitsi.metaconfig.SupplierBuilder;
import org.jitsi.metaconfig.supplier.FallbackSupplier;
import org.jitsi.nlj.EventTimeline;
import org.jitsi.rtp.Packet;
import org.jitsi.utils.logging2.LoggerExtensionsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0017\u0018\u0000 >2\u00020\u0001:\u0001>B'\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010.\u001a\u00020/J\u0015\u00100\u001a\u0002H1\"\b\b\u0000\u00101*\u00020\u0003\u00a2\u0006\u0002\u0010\u000bJ\u0006\u00102\u001a\u00020\u0000J\u0015\u00103\u001a\u0004\u0018\u00010/2\u0006\u00104\u001a\u00020#\u00a2\u0006\u0002\u00105J\u0014\u0010;\u001a\u00020/2\f\u0010<\u001a\b\u0012\u0004\u0012\u00020/08J\u0006\u0010=\u001a\u00020/R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R(\u0010\u0014\u001a\u0004\u0018\u00010\u00132\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\u00020\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001a\u0010\u001f\u001a\u00020\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u001c\"\u0004\b!\u0010\u001eR\u001c\u0010\"\u001a\u0004\u0018\u00010#X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\u001a\u0010(\u001a\u00020\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010\u001c\"\u0004\b*\u0010\u001eR\u001c\u0010+\u001a\u0004\u0018\u00010#X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010%\"\u0004\b-\u0010'R0\u00106\u001a\"\u0012\n\u0012\b\u0012\u0004\u0012\u00020/08\u0018\u000109j\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020/08\u0018\u0001`7X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010:\u00a8\u0006?"}, d2={"Lorg/jitsi/nlj/PacketInfo;", "", "packet", "Lorg/jitsi/rtp/Packet;", "originalLength", "", "timeline", "Lorg/jitsi/nlj/EventTimeline;", "<init>", "(Lorg/jitsi/rtp/Packet;ILorg/jitsi/nlj/EventTimeline;)V", "getPacket", "()Lorg/jitsi/rtp/Packet;", "setPacket", "(Lorg/jitsi/rtp/Packet;)V", "getOriginalLength", "()I", "getTimeline", "()Lorg/jitsi/nlj/EventTimeline;", "value", "Ljava/time/Instant;", "receivedTime", "getReceivedTime", "()Ljava/time/Instant;", "setReceivedTime", "(Ljava/time/Instant;)V", "originalHadCryptex", "", "getOriginalHadCryptex", "()Z", "setOriginalHadCryptex", "(Z)V", "shouldDiscard", "getShouldDiscard", "setShouldDiscard", "endpointId", "", "getEndpointId", "()Ljava/lang/String;", "setEndpointId", "(Ljava/lang/String;)V", "layeringChanged", "getLayeringChanged", "setLayeringChanged", "payloadVerification", "getPayloadVerification", "setPayloadVerification", "resetPayloadVerification", "", "packetAs", "ExpectedPacketType", "clone", "addEvent", "desc", "(Ljava/lang/String;)Lkotlin/Unit;", "onSentActions", "Lkotlin/collections/ArrayList;", "Lkotlin/Function0;", "Ljava/util/ArrayList;", "Ljava/util/ArrayList;", "onSent", "action", "sent", "Companion", "jitsi-media-transform"})
@SuppressFBWarnings(value={"CN_IMPLEMENTS_CLONE_BUT_NOT_CLONEABLE"})
@SourceDebugExtension(value={"SMAP\nPacketInfo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PacketInfo.kt\norg/jitsi/nlj/PacketInfo\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Delegates.kt\norg/jitsi/metaconfig/DelegatesKt\n*L\n1#1,255:1\n1#2:256\n68#3,6:257\n68#3,6:263\n*S KotlinDebug\n*F\n+ 1 PacketInfo.kt\norg/jitsi/nlj/PacketInfo\n*L\n219#1:257,6\n223#1:263,6\n*E\n"})
public class PacketInfo {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private Packet packet;
    private final int originalLength;
    @Nullable
    private final EventTimeline timeline;
    @Nullable
    private Instant receivedTime;
    private boolean originalHadCryptex;
    private boolean shouldDiscard;
    @Nullable
    private String endpointId;
    private boolean layeringChanged;
    @Nullable
    private String payloadVerification;
    @Nullable
    private ArrayList<Function0<Unit>> onSentActions;
    @NotNull
    private static final ConfigDelegate<Boolean> enableTimeline$delegate;
    @NotNull
    private static final ConfigDelegate<Boolean> enablePayloadVerificationDefault$delegate;
    private static boolean enablePayloadVerification;

    @JvmOverloads
    public PacketInfo(@NotNull Packet packet, int originalLength, @Nullable EventTimeline timeline) {
        Intrinsics.checkNotNullParameter(packet, "packet");
        this.packet = packet;
        this.originalLength = originalLength;
        this.timeline = timeline;
        this.payloadVerification = enablePayloadVerification ? this.packet.getPayloadVerification() : null;
    }

    public /* synthetic */ PacketInfo(Packet packet, int n, EventTimeline eventTimeline, int n2, DefaultConstructorMarker defaultConstructorMarker2) {
        if ((n2 & 2) != 0) {
            n = packet.length;
        }
        if ((n2 & 4) != 0) {
            eventTimeline = PacketInfo.Companion.getEnableTimeline() ? new EventTimeline(null, null, 3, null) : null;
        }
        this(packet, n, eventTimeline);
    }

    @NotNull
    public final Packet getPacket() {
        return this.packet;
    }

    public final void setPacket(@NotNull Packet packet) {
        Intrinsics.checkNotNullParameter(packet, "<set-?>");
        this.packet = packet;
    }

    public final int getOriginalLength() {
        return this.originalLength;
    }

    @Nullable
    public final EventTimeline getTimeline() {
        return this.timeline;
    }

    @Nullable
    public final Instant getReceivedTime() {
        return this.receivedTime;
    }

    public final void setReceivedTime(@Nullable Instant value2) {
        this.receivedTime = value2;
        if (this.timeline != null && this.timeline.getReferenceTime() == null) {
            this.timeline.setReferenceTime(value2);
        }
    }

    public final boolean getOriginalHadCryptex() {
        return this.originalHadCryptex;
    }

    public final void setOriginalHadCryptex(boolean bl) {
        this.originalHadCryptex = bl;
    }

    public final boolean getShouldDiscard() {
        return this.shouldDiscard;
    }

    public final void setShouldDiscard(boolean bl) {
        this.shouldDiscard = bl;
    }

    @Nullable
    public final String getEndpointId() {
        return this.endpointId;
    }

    public final void setEndpointId(@Nullable String string) {
        this.endpointId = string;
    }

    public final boolean getLayeringChanged() {
        return this.layeringChanged;
    }

    public final void setLayeringChanged(boolean bl) {
        this.layeringChanged = bl;
    }

    @Nullable
    public final String getPayloadVerification() {
        return this.payloadVerification;
    }

    public final void setPayloadVerification(@Nullable String string) {
        this.payloadVerification = string;
    }

    public final void resetPayloadVerification() {
        this.payloadVerification = enablePayloadVerification ? this.packet.getPayloadVerification() : null;
    }

    @NotNull
    public final <ExpectedPacketType extends Packet> ExpectedPacketType packetAs() {
        Packet packet = this.packet;
        Intrinsics.checkNotNull(packet, "null cannot be cast to non-null type ExpectedPacketType of org.jitsi.nlj.PacketInfo.packetAs");
        return (ExpectedPacketType)packet;
    }

    @NotNull
    public final PacketInfo clone() {
        EventTimeline eventTimeline = this.timeline;
        PacketInfo clone = new PacketInfo(this.packet.clone(), this.originalLength, eventTimeline != null ? eventTimeline.clone() : null);
        clone.setReceivedTime(this.receivedTime);
        clone.originalHadCryptex = this.originalHadCryptex;
        clone.shouldDiscard = this.shouldDiscard;
        clone.endpointId = this.endpointId;
        clone.layeringChanged = this.layeringChanged;
        clone.payloadVerification = this.payloadVerification;
        ArrayList<Function0<Unit>> arrayList = this.onSentActions;
        clone.onSentActions = (ArrayList)(arrayList != null ? arrayList.clone() : null);
        return clone;
    }

    @Nullable
    public final Unit addEvent(@NotNull String desc) {
        Unit unit;
        Intrinsics.checkNotNullParameter(desc, "desc");
        EventTimeline eventTimeline = this.timeline;
        if (eventTimeline != null) {
            eventTimeline.addEvent(desc);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return unit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onSent(@NotNull Function0<Unit> action) {
        Intrinsics.checkNotNullParameter(action, "action");
        PacketInfo packetInfo = this;
        synchronized (packetInfo) {
            boolean bl = false;
            if (this.onSentActions == null) {
                this.onSentActions = new ArrayList(1);
            }
            ArrayList<Function0<Unit>> arrayList = this.onSentActions;
            Intrinsics.checkNotNull(arrayList);
            boolean bl2 = arrayList.add(action);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void sent() {
        List<Function0> actions = null;
        List<Function0> list = Collections.emptyList();
        Intrinsics.checkNotNullExpressionValue(list, "emptyList(...)");
        actions = list;
        PacketInfo packetInfo = this;
        synchronized (packetInfo) {
            boolean bl = false;
            ArrayList<Function0<Unit>> arrayList = this.onSentActions;
            if (arrayList == null) {
                PacketInfo $this$sent_u24lambda_u243_u24lambda_u242 = this;
                boolean bl2 = false;
                return;
            }
            ArrayList<Function0<Unit>> it = arrayList;
            boolean bl3 = false;
            actions = it;
            this.onSentActions = null;
            Unit $i$a$-synchronized-PacketInfo$sent$2 = Unit.INSTANCE;
        }
        for (Function0 action : actions) {
            action.invoke();
        }
    }

    @JvmOverloads
    public PacketInfo(@NotNull Packet packet, int originalLength) {
        Intrinsics.checkNotNullParameter(packet, "packet");
        this(packet, originalLength, null, 4, null);
    }

    @JvmOverloads
    public PacketInfo(@NotNull Packet packet) {
        Intrinsics.checkNotNullParameter(packet, "packet");
        this(packet, 0, null, 6, null);
    }

    static {
        SupplierBuilder supplierBuilder;
        Companion = new Companion(null);
        boolean $i$f$config = false;
        SupplierBuilder $this$enableTimeline_delegate_u24lambda_u244 = supplierBuilder = new SupplierBuilder(Reflection.typeOf(Boolean.TYPE));
        boolean bl = false;
        $this$enableTimeline_delegate_u24lambda_u244.from("jmt.debug.packet-timeline.enabled", JitsiConfig.Companion.getNewConfig());
        SupplierBuilder supplierBuilder$iv = supplierBuilder;
        enableTimeline$delegate = supplierBuilder$iv.getSuppliers().size() == 1 ? new ConfigDelegate(CollectionsKt.first(supplierBuilder$iv.getSuppliers())) : new ConfigDelegate(new FallbackSupplier(supplierBuilder$iv.getSuppliers()));
        $i$f$config = false;
        SupplierBuilder $this$enablePayloadVerificationDefault_delegate_u24lambda_u245 = supplierBuilder = new SupplierBuilder(Reflection.typeOf(Boolean.TYPE));
        boolean bl2 = false;
        $this$enablePayloadVerificationDefault_delegate_u24lambda_u245.from("jmt.debug.payload-verification.enabled", JitsiConfig.Companion.getNewConfig());
        supplierBuilder$iv = supplierBuilder;
        enablePayloadVerificationDefault$delegate = supplierBuilder$iv.getSuppliers().size() == 1 ? new ConfigDelegate(CollectionsKt.first(supplierBuilder$iv.getSuppliers())) : new ConfigDelegate(new FallbackSupplier(supplierBuilder$iv.getSuppliers()));
        enablePayloadVerification = PacketInfo.Companion.getEnablePayloadVerificationDefault();
        if (PacketInfo.Companion.getEnableTimeline()) {
            LoggerExtensionsKt.createLogger$default(Companion, null, null, 3, null).info("Packet timeline is enabled.");
        }
        if (enablePayloadVerification) {
            LoggerExtensionsKt.createLogger$default(Companion, null, null, 3, null).info("Payload verification is enabled.");
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\f\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001b\u0010\u0004\u001a\u00020\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R\u001b\u0010\n\u001a\u00020\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\t\u001a\u0004\b\u000b\u0010\u0007R\u001a\u0010\r\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u0007\"\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lorg/jitsi/nlj/PacketInfo$Companion;", "", "<init>", "()V", "enableTimeline", "", "getEnableTimeline", "()Z", "enableTimeline$delegate", "Lorg/jitsi/metaconfig/ConfigDelegate;", "enablePayloadVerificationDefault", "getEnablePayloadVerificationDefault", "enablePayloadVerificationDefault$delegate", "enablePayloadVerification", "getEnablePayloadVerification", "setEnablePayloadVerification", "(Z)V", "jitsi-media-transform"})
    public static final class Companion {
        static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;

        private Companion() {
        }

        private final boolean getEnableTimeline() {
            return (Boolean)enableTimeline$delegate.getValue(this, $$delegatedProperties[0]);
        }

        private final boolean getEnablePayloadVerificationDefault() {
            return (Boolean)enablePayloadVerificationDefault$delegate.getValue(this, $$delegatedProperties[1]);
        }

        public final boolean getEnablePayloadVerification() {
            return enablePayloadVerification;
        }

        public final void setEnablePayloadVerification(boolean bl) {
            enablePayloadVerification = bl;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        static {
            KProperty[] kPropertyArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(Companion.class, "enableTimeline", "getEnableTimeline()Z", 0)), Reflection.property1(new PropertyReference1Impl(Companion.class, "enablePayloadVerificationDefault", "getEnablePayloadVerificationDefault()Z", 0))};
            $$delegatedProperties = kPropertyArray;
        }
    }
}

