/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.colibri2;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jitsi.nlj.MediaSourceDesc;
import org.jitsi.nlj.format.PayloadType;
import org.jitsi.nlj.rtp.RtpExtension;
import org.jitsi.nlj.rtp.RtpExtensionType;
import org.jitsi.nlj.rtp.SsrcAssociationType;
import org.jitsi.nlj.util.LocalSsrcAssociation;
import org.jitsi.nlj.util.SsrcAssociation;
import org.jitsi.utils.MediaType;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;
import org.jitsi.videobridge.AbstractEndpoint;
import org.jitsi.videobridge.Conference;
import org.jitsi.videobridge.Endpoint;
import org.jitsi.videobridge.colibri2.Colibri2ConferenceHandlerKt;
import org.jitsi.videobridge.colibri2.Colibri2UtilKt;
import org.jitsi.videobridge.colibri2.FeatureNotImplementedException;
import org.jitsi.videobridge.colibri2.IqProcessingException;
import org.jitsi.videobridge.colibri2.UnknownEndpointException;
import org.jitsi.videobridge.relay.AudioSourceDesc;
import org.jitsi.videobridge.relay.Relay;
import org.jitsi.videobridge.relay.RelayConfig;
import org.jitsi.videobridge.relay.RelayedEndpoint;
import org.jitsi.videobridge.sctp.SctpConfig;
import org.jitsi.videobridge.util.PayloadTypeUtil;
import org.jitsi.videobridge.websocket.config.WebsocketServiceConfig;
import org.jitsi.videobridge.xmpp.MediaSourceFactory;
import org.jitsi.xmpp.extensions.AbstractPacketExtension;
import org.jitsi.xmpp.extensions.colibri.SourcePacketExtension;
import org.jitsi.xmpp.extensions.colibri2.Colibri2Endpoint;
import org.jitsi.xmpp.extensions.colibri2.Colibri2Relay;
import org.jitsi.xmpp.extensions.colibri2.ConferenceModifiedIQ;
import org.jitsi.xmpp.extensions.colibri2.ConferenceModifyIQ;
import org.jitsi.xmpp.extensions.colibri2.Endpoints;
import org.jitsi.xmpp.extensions.colibri2.ForceMute;
import org.jitsi.xmpp.extensions.colibri2.InitialLastN;
import org.jitsi.xmpp.extensions.colibri2.Media;
import org.jitsi.xmpp.extensions.colibri2.MediaSource;
import org.jitsi.xmpp.extensions.colibri2.Sctp;
import org.jitsi.xmpp.extensions.colibri2.Sources;
import org.jitsi.xmpp.extensions.colibri2.Transport;
import org.jitsi.xmpp.extensions.jingle.IceUdpTransportPacketExtension;
import org.jitsi.xmpp.extensions.jingle.PayloadTypePacketExtension;
import org.jitsi.xmpp.extensions.jingle.RTPHdrExtPacketExtension;
import org.jitsi.xmpp.extensions.jingle.SourceGroupPacketExtension;
import org.jitsi.xmpp.util.ErrorUtilKt;
import org.jitsi.xmpp.util.XmlStringBuilderUtil;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.StanzaError;
import org.jivesoftware.smackx.muc.MUCRole;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n2\u0006\u0010\r\u001a\u00020\u000eJ\b\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\fH\u0002J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u000e\u0010\u001b\u001a\u0004\u0018\u00010\u001a*\u00020\u001cH\u0002J\u000e\u0010\u001d\u001a\u0004\u0018\u00010\u001e*\u00020\u0018H\u0002J\u000e\u0010\u001f\u001a\u0004\u0018\u00010 *\u00020!H\u0002J\u0018\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020#2\u0006\u0010%\u001a\u00020\fH\u0002J$\u0010&\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020(0'\u0012\n\u0012\b\u0012\u0004\u0012\u00020)0'0\n*\u00020\u0012H\u0002J\u0010\u0010*\u001a\u00020\u00162\u0006\u0010+\u001a\u00020\u000eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lorg/jitsi/videobridge/colibri2/Colibri2ConferenceHandler;", "", "conference", "Lorg/jitsi/videobridge/Conference;", "parentLogger", "Lorg/jitsi/utils/logging2/Logger;", "<init>", "(Lorg/jitsi/videobridge/Conference;Lorg/jitsi/utils/logging2/Logger;)V", "logger", "handleConferenceModifyIQ", "Lkotlin/Pair;", "Lorg/jivesoftware/smack/packet/IQ;", "", "conferenceModifyIQ", "Lorg/jitsi/xmpp/extensions/colibri2/ConferenceModifyIQ;", "buildFeedbackSources", "Lorg/jitsi/xmpp/extensions/colibri2/Sources;", "handleColibri2Endpoint", "Lorg/jitsi/xmpp/extensions/colibri2/Colibri2Endpoint;", "c2endpoint", "ignoreUnknownEndpoints", "addSsrcAssociation", "", "endpointId", "", "ssrcAssociation", "Lorg/jitsi/nlj/util/SsrcAssociation;", "toSsrcAssociation", "Lorg/jitsi/xmpp/extensions/jingle/SourceGroupPacketExtension;", "parseAssociationType", "Lorg/jitsi/nlj/rtp/SsrcAssociationType;", "toRtpExtension", "Lorg/jitsi/nlj/rtp/RtpExtension;", "Lorg/jitsi/xmpp/extensions/jingle/RTPHdrExtPacketExtension;", "handleColibri2Relay", "Lorg/jitsi/xmpp/extensions/colibri2/Colibri2Relay;", "c2relay", "ignoreUnknownRelays", "parseSourceDescs", "", "Lorg/jitsi/videobridge/relay/AudioSourceDesc;", "Lorg/jitsi/nlj/MediaSourceDesc;", "validateRequest", "iq", "jitsi-videobridge"})
@SourceDebugExtension(value={"SMAP\nColibri2ConferenceHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Colibri2ConferenceHandler.kt\norg/jitsi/videobridge/colibri2/Colibri2ConferenceHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,540:1\n1747#2,3:541\n1855#2,2:545\n1855#2,2:547\n1747#2,3:549\n1747#2,3:552\n1855#2:555\n1855#2,2:556\n1603#2,9:558\n1855#2:567\n1856#2:569\n1612#2:570\n1855#2,2:571\n1856#2:573\n766#2:574\n857#2,2:575\n1603#2,9:577\n1855#2:586\n1856#2:588\n1612#2:589\n766#2:592\n857#2,2:593\n1855#2:595\n1855#2,2:596\n1856#2:598\n1855#2,2:599\n1855#2,2:601\n1855#2:603\n1855#2:604\n1603#2,9:605\n1855#2:614\n1856#2:616\n1612#2:617\n1855#2,2:618\n1856#2:620\n1856#2:621\n1855#2:622\n1855#2,2:623\n1856#2:625\n1747#2,3:626\n1#3:544\n1#3:568\n1#3:587\n1#3:615\n37#4,2:590\n*S KotlinDebug\n*F\n+ 1 Colibri2ConferenceHandler.kt\norg/jitsi/videobridge/colibri2/Colibri2ConferenceHandler\n*L\n98#1:541,3\n230#1:545,2\n235#1:547,2\n245#1:549,3\n248#1:552,3\n279#1:555\n280#1:556,2\n284#1:558,9\n284#1:567\n284#1:569\n284#1:570\n284#1:571,2\n279#1:573\n291#1:574\n291#1:575,2\n291#1:577,9\n291#1:586\n291#1:588\n291#1:589\n297#1:592\n297#1:593,2\n297#1:595\n298#1:596,2\n297#1:598\n427#1:599,2\n432#1:601,2\n445#1:603\n459#1:604\n460#1:605,9\n460#1:614\n460#1:616\n460#1:617\n460#1:618,2\n459#1:620\n445#1:621\n476#1:622\n483#1:623,2\n476#1:625\n513#1:626,3\n284#1:568\n291#1:587\n460#1:615\n294#1:590,2\n*E\n"})
public final class Colibri2ConferenceHandler {
    @NotNull
    private final Conference conference;
    @NotNull
    private final Logger logger;

    public Colibri2ConferenceHandler(@NotNull Conference conference, @NotNull Logger parentLogger) {
        Intrinsics.checkNotNullParameter(conference, "conference");
        Intrinsics.checkNotNullParameter(parentLogger, "parentLogger");
        this.conference = conference;
        this.logger = LoggerExtensionsKt.createChildLogger$default(this, parentLogger, null, 2, null);
    }

    @NotNull
    public final Pair<IQ, Boolean> handleConferenceModifyIQ(@NotNull ConferenceModifyIQ conferenceModifyIQ) {
        Pair<IQ, Boolean> pair;
        Intrinsics.checkNotNullParameter(conferenceModifyIQ, "conferenceModifyIQ");
        try {
            boolean expire;
            ConferenceModifiedIQ.Builder responseBuilder;
            block21: {
                block20: {
                    boolean bl;
                    block19: {
                        boolean bl2;
                        this.validateRequest(conferenceModifyIQ);
                        boolean ignoreUnknownEndpoints = Colibri2ConferenceHandlerKt.access$shouldIgnoreUnknownEndpoints(conferenceModifyIQ);
                        ConferenceModifiedIQ.Builder builder2 = ConferenceModifiedIQ.builder(ConferenceModifiedIQ.Builder.createResponse(conferenceModifyIQ));
                        Intrinsics.checkNotNullExpressionValue(builder2, "builder(...)");
                        responseBuilder = builder2;
                        boolean it = bl2 = conferenceModifyIQ.getExpire();
                        boolean bl3 = false;
                        if (it) {
                            this.logger.info("Received request to expire conference.");
                        }
                        expire = bl2;
                        for (Colibri2Endpoint e : conferenceModifyIQ.getEndpoints()) {
                            Intrinsics.checkNotNull(e);
                            responseBuilder.addEndpoint(this.handleColibri2Endpoint(e, ignoreUnknownEndpoints));
                        }
                        for (Colibri2Relay r : conferenceModifyIQ.getRelays()) {
                            if (!RelayConfig.config.getEnabled()) {
                                throw new IqProcessingException(StanzaError.Condition.feature_not_implemented, "Octo is disabled in configuration.");
                            }
                            if (!WebsocketServiceConfig.config.getEnabled() && !SctpConfig.config.getEnabled()) {
                                this.logger.warn("Can not use a colibri2 relay, because neither SCTP nor colibri web sockets are enabled. See https://github.com/jitsi/jitsi-videobridge/blob/master/doc/relay.md");
                                throw new UnsupportedOperationException("Colibri websockets or SCTP need to be enabled to use a colibri2 relay.");
                            }
                            Intrinsics.checkNotNull(r);
                            responseBuilder.addRelay(this.handleColibri2Relay(r, ignoreUnknownEndpoints));
                        }
                        if (conferenceModifyIQ.getCreate()) break block20;
                        List<Colibri2Endpoint> list = conferenceModifyIQ.getEndpoints();
                        Intrinsics.checkNotNullExpressionValue(list, "getEndpoints(...)");
                        Iterable $this$any$iv = list;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                Colibri2Endpoint it2 = (Colibri2Endpoint)element$iv;
                                boolean bl4 = false;
                                if (!it2.getCreate()) continue;
                                bl = true;
                                break block19;
                            }
                            bl = false;
                        }
                    }
                    if (!bl) break block21;
                }
                responseBuilder.setSources(this.buildFeedbackSources());
            }
            if (!conferenceModifyIQ.getCreate() && this.conference.getEndpointCount() == 0 && this.conference.getRelayCount() == 0) {
                this.logger.info("All endpoints and relays removed, expiring.");
                expire = true;
            }
            pair = new Pair<ConferenceModifiedIQ, Boolean>(responseBuilder.build(), expire);
        }
        catch (UnknownEndpointException e) {
            this.logger.warn("Unknown Endpoint during processing conference-modify IQ: " + e);
            IQ error = Colibri2UtilKt.createEndpointNotFoundError(conferenceModifyIQ, e.getEndpointId());
            pair = new Pair<IQ, Boolean>(error, false);
        }
        catch (FeatureNotImplementedException e) {
            this.logger.warn("Unsupported request (" + e.getMessage() + "): " + XmlStringBuilderUtil.Companion.toStringOpt(conferenceModifyIQ));
            pair = new Pair<IQ, Boolean>(Colibri2UtilKt.createFeatureNotImplementedError(conferenceModifyIQ, e.getMessage()), false);
        }
        catch (IqProcessingException e) {
            if (StanzaError.Condition.item_not_found == e.getCondition()) {
                this.logger.warn("Error processing conference-modify IQ: " + e);
            } else {
                this.logger.error("Error processing conference-modify IQ: " + e);
            }
            pair = new Pair<IQ, Boolean>(ErrorUtilKt.createError$default((IQ)conferenceModifyIQ, e.getCondition(), e.getMessage(), null, 8, null), false);
        }
        return pair;
    }

    /*
     * WARNING - void declaration
     */
    private final Sources buildFeedbackSources() {
        void $this$buildFeedbackSources_u24lambda_u244_u24lambda_u243;
        SourcePacketExtension $this$buildFeedbackSources_u24lambda_u244_u24lambda_u242;
        SourcePacketExtension sourcePacketExtension;
        Sources.Builder builder2;
        Sources.Builder $this$buildFeedbackSources_u24lambda_u244 = builder2 = Sources.getBuilder();
        boolean bl = false;
        SourcePacketExtension sourcePacketExtension2 = sourcePacketExtension = new SourcePacketExtension();
        MediaSource.Builder builder3 = MediaSource.getBuilder().setType(MediaType.AUDIO).setId("jvb-a0");
        Sources.Builder builder4 = $this$buildFeedbackSources_u24lambda_u244;
        boolean bl2 = false;
        $this$buildFeedbackSources_u24lambda_u244_u24lambda_u242.setSSRC(this.conference.getLocalAudioSsrc());
        $this$buildFeedbackSources_u24lambda_u244_u24lambda_u242.setName("jvb-a0");
        Unit unit = Unit.INSTANCE;
        builder4.addMediaSource(builder3.addSource(sourcePacketExtension).build());
        $this$buildFeedbackSources_u24lambda_u244_u24lambda_u242 = sourcePacketExtension = new SourcePacketExtension();
        builder3 = MediaSource.getBuilder().setType(MediaType.VIDEO).setId("jvb-v0");
        builder4 = $this$buildFeedbackSources_u24lambda_u244;
        boolean bl3 = false;
        $this$buildFeedbackSources_u24lambda_u244_u24lambda_u243.setSSRC(this.conference.getLocalVideoSsrc());
        $this$buildFeedbackSources_u24lambda_u244_u24lambda_u243.setName("jvb-v0");
        unit = Unit.INSTANCE;
        builder4.addMediaSource(builder3.addSource(sourcePacketExtension).build());
        Sources sources = builder2.build();
        Intrinsics.checkNotNullExpressionValue(sources, "build(...)");
        return sources;
    }

    /*
     * WARNING - void declaration
     */
    private final Colibri2Endpoint handleColibri2Endpoint(Colibri2Endpoint c2endpoint, boolean ignoreUnknownEndpoints) throws IqProcessingException {
        AbstractPacketExtension abstractPacketExtension;
        boolean bl;
        boolean bl2;
        Endpoint endpoint;
        Endpoint endpoint2;
        Colibri2Endpoint.Builder respBuilder;
        block44: {
            PayloadType it;
            boolean bl3;
            Iterable $this$any$iv;
            boolean $i$f$any;
            block43: {
                Endpoint endpoint3;
                Object transport;
                Colibri2Endpoint.Builder builder2;
                Colibri2Endpoint.Builder $this$handleColibri2Endpoint_u24lambda_u245 = builder2 = Colibri2Endpoint.getBuilder();
                boolean bl4 = false;
                $this$handleColibri2Endpoint_u24lambda_u245.setId(c2endpoint.getId());
                Colibri2Endpoint.Builder builder3 = builder2;
                Intrinsics.checkNotNullExpressionValue(builder3, "apply(...)");
                respBuilder = builder3;
                if (c2endpoint.getExpire()) {
                    Endpoint endpoint4 = this.conference.getLocalEndpoint(c2endpoint.getId());
                    if (endpoint4 != null) {
                        endpoint4.expire();
                    }
                    respBuilder.setExpire(true);
                    Colibri2Endpoint colibri2Endpoint = respBuilder.build();
                    Intrinsics.checkNotNullExpressionValue(colibri2Endpoint, "build(...)");
                    return colibri2Endpoint;
                }
                if (c2endpoint.getCreate()) {
                    if (this.conference.getLocalEndpoint(c2endpoint.getId()) != null) {
                        throw new IqProcessingException(StanzaError.Condition.conflict, "Endpoint with ID " + c2endpoint.getId() + " already exists");
                    }
                    Transport transport2 = c2endpoint.getTransport();
                    if (transport2 == null) {
                        throw new IqProcessingException(StanzaError.Condition.bad_request, "Attempt to create endpoint " + c2endpoint.getId() + " with no <transport>");
                    }
                    transport = transport2;
                    if (!c2endpoint.hasCapability("source-names")) {
                        throw new IqProcessingException(StanzaError.Condition.bad_request, "Source name support is mandatory.");
                    }
                    boolean ssrcRewriting = c2endpoint.hasCapability("ssrc-rewriting");
                    boolean privateAddresses = c2endpoint.hasCapability("private-address-connectivity");
                    Endpoint endpoint5 = this.conference.createLocalEndpoint(c2endpoint.getId(), ((Transport)transport).getIceControlling(), ssrcRewriting, c2endpoint.getMucRole() == MUCRole.visitor, privateAddresses);
                    Iterator $this$handleColibri2Endpoint_u24lambda_u248 = endpoint5;
                    boolean bl5 = false;
                    String string = c2endpoint.getStatsId();
                    if (string != null) {
                        String it2 = string;
                        boolean bl6 = false;
                        ((AbstractEndpoint)((Object)$this$handleColibri2Endpoint_u24lambda_u248)).setStatsId(it2);
                    }
                    Sctp sctp = ((Transport)transport).getSctp();
                    if (sctp != null) {
                        Sctp sctp2 = sctp;
                        boolean bl7 = false;
                        if (!SctpConfig.config.getEnabled()) {
                            throw new IqProcessingException(StanzaError.Condition.feature_not_implemented, "SCTP support is not configured");
                        }
                        if (sctp2.getRole() != null && sctp2.getRole() != Sctp.Role.SERVER) {
                            throw new IqProcessingException(StanzaError.Condition.feature_not_implemented, "Unsupported SCTP role: " + sctp2.getRole());
                        }
                        if (sctp2.getPort() != null) {
                            Integer n = sctp2.getPort();
                            int n2 = 5000;
                            if (n == null || n != n2) {
                                throw new IqProcessingException(StanzaError.Condition.bad_request, "Specific SCTP port requested, not supported.");
                            }
                        }
                        ((Endpoint)((Object)$this$handleColibri2Endpoint_u24lambda_u248)).createSctpConnection();
                    }
                    endpoint3 = endpoint5;
                } else {
                    endpoint3 = endpoint2 = this.conference.getLocalEndpoint(c2endpoint.getId());
                }
                if (endpoint2 == null) {
                    if (ignoreUnknownEndpoints) {
                        Colibri2Endpoint colibri2Endpoint = respBuilder.build();
                        Intrinsics.checkNotNullExpressionValue(colibri2Endpoint, "build(...)");
                        return colibri2Endpoint;
                    }
                    String string = c2endpoint.getId();
                    Intrinsics.checkNotNullExpressionValue(string, "getId(...)");
                    throw new UnknownEndpointException(string);
                }
                for (Media media : c2endpoint.getMedia()) {
                    Object it3;
                    List<PayloadTypePacketExtension> list = media.getPayloadTypes();
                    Intrinsics.checkNotNullExpressionValue(list, "getPayloadTypes(...)");
                    Iterable $this$forEach$iv = list;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        PayloadTypePacketExtension ptExt = (PayloadTypePacketExtension)element$iv;
                        boolean bl8 = false;
                        Intrinsics.checkNotNull(ptExt);
                        MediaType mediaType = media.getType();
                        Intrinsics.checkNotNullExpressionValue((Object)mediaType, "getType(...)");
                        if (PayloadTypeUtil.Companion.create(ptExt, mediaType) != null) {
                            boolean bl9 = false;
                            endpoint2.addPayloadType((PayloadType)it3);
                            continue;
                        }
                        this.logger.warn("Ignoring unrecognized payload type extension: " + XmlStringBuilderUtil.Companion.toStringOpt(ptExt));
                    }
                    List<RTPHdrExtPacketExtension> list2 = media.getRtpHdrExts();
                    Intrinsics.checkNotNullExpressionValue(list2, "getRtpHdrExts(...)");
                    $this$forEach$iv = list2;
                    $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        RTPHdrExtPacketExtension rtpHdrExt = (RTPHdrExtPacketExtension)element$iv;
                        boolean bl10 = false;
                        Intrinsics.checkNotNull(rtpHdrExt);
                        if (this.toRtpExtension(rtpHdrExt) != null) {
                            boolean bl11 = false;
                            endpoint2.addRtpExtension((RtpExtension)it3);
                            continue;
                        }
                        this.logger.warn("Ignoring unrecognized RTP header extension: " + XmlStringBuilderUtil.Companion.toStringOpt(rtpHdrExt));
                    }
                    endpoint2.setExtmapAllowMixed(media.getExtmapAllowMixed() != null);
                }
                transport = endpoint2.getTransceiver().getReadOnlyStreamInformationStore().getRtpPayloadTypes().values();
                endpoint = endpoint2;
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl3 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        it = (PayloadType)element$iv;
                        boolean bl12 = false;
                        if (!(it.getMediaType() == MediaType.AUDIO)) continue;
                        bl3 = true;
                        break block43;
                    }
                    bl3 = false;
                }
            }
            bl2 = bl3;
            endpoint.setAcceptAudio(bl2);
            $this$any$iv = endpoint2.getTransceiver().getReadOnlyStreamInformationStore().getRtpPayloadTypes().values();
            endpoint = endpoint2;
            $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    it = (PayloadType)element$iv;
                    boolean bl13 = false;
                    if (!(it.getMediaType() == MediaType.VIDEO)) continue;
                    bl = true;
                    break block44;
                }
                bl = false;
            }
        }
        bl2 = bl;
        endpoint.setAcceptVideo(bl2);
        InitialLastN initialLastN = c2endpoint.getInitialLastN();
        if (initialLastN != null) {
            int it = initialLastN.getValue();
            boolean bl14 = false;
            endpoint2.setInitialLastN(it);
        }
        if ((abstractPacketExtension = c2endpoint.getTransport()) != null && (abstractPacketExtension = abstractPacketExtension.getIceUdpTransport()) != null) {
            AbstractPacketExtension it = abstractPacketExtension;
            boolean bl15 = false;
            endpoint2.setTransportInfo((IceUdpTransportPacketExtension)it);
        }
        if (c2endpoint.getCreate()) {
            Transport.Builder builder4 = Transport.getBuilder();
            Intrinsics.checkNotNullExpressionValue(builder4, "getBuilder(...)");
            Transport.Builder transBuilder = builder4;
            transBuilder.setIceUdpExtension(endpoint2.describeTransport());
            Transport transport = c2endpoint.getTransport();
            if ((transport != null ? transport.getSctp() : null) != null) {
                transBuilder.setSctp(new Sctp.Builder().setPort(5000).setRole(Sctp.Role.SERVER).build());
            }
            respBuilder.setTransport(transBuilder.build());
        }
        Sources sources = c2endpoint.getSources();
        if (sources != null) {
            void $this$forEach$iv;
            void $this$filterTo$iv$iv;
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            Object it;
            void $this$filterTo$iv$iv2;
            Sources sources2 = sources;
            boolean bl16 = false;
            if (endpoint2.getVisitor()) {
                List<MediaSource> list = sources2.getMediaSources();
                Intrinsics.checkNotNullExpressionValue(list, "getMediaSources(...)");
                if (!((Collection)list).isEmpty()) {
                    throw new IqProcessingException(StanzaError.Condition.bad_request, "Attempt to set sources for visitor endpoint " + c2endpoint.getId());
                }
            }
            List<MediaSource> list = sources2.getMediaSources();
            Intrinsics.checkNotNullExpressionValue(list, "getMediaSources(...)");
            Iterable $this$forEach$iv2 = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv2) {
                Iterator $this$mapNotNullTo$iv$iv2;
                MediaSource mediaSource = (MediaSource)element$iv;
                boolean bl17 = false;
                List<SourcePacketExtension> list3 = mediaSource.getSources();
                Intrinsics.checkNotNullExpressionValue(list3, "getSources(...)");
                Iterable $this$forEach$iv3 = list3;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv3) {
                    SourcePacketExtension it4 = (SourcePacketExtension)element$iv2;
                    boolean bl18 = false;
                    long l = it4.getSSRC();
                    MediaType mediaType = mediaSource.getType();
                    Intrinsics.checkNotNullExpressionValue((Object)mediaType, "getType(...)");
                    endpoint2.addReceiveSsrc(l, mediaType);
                }
                List<SourceGroupPacketExtension> list4 = mediaSource.getSsrcGroups();
                Intrinsics.checkNotNullExpressionValue(list4, "getSsrcGroups(...)");
                Iterable $this$mapNotNull$iv2 = list4;
                boolean $i$f$mapNotNull = false;
                Iterable iterable = $this$mapNotNull$iv2;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv2;
                boolean $i$f$forEach3 = false;
                Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    SsrcAssociation it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                    boolean bl19 = false;
                    SourceGroupPacketExtension it5 = (SourceGroupPacketExtension)element$iv$iv;
                    boolean bl20 = false;
                    Intrinsics.checkNotNull(it5);
                    if (this.toSsrcAssociation(it5) == null) continue;
                    boolean bl21 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                $this$mapNotNull$iv2 = (List)destination$iv$iv;
                $i$f$forEach2 = false;
                $this$mapNotNullTo$iv$iv2 = $this$forEach$iv3.iterator();
                while ($this$mapNotNullTo$iv$iv2.hasNext()) {
                    Object element$iv2;
                    element$iv2 = $this$mapNotNullTo$iv$iv2.next();
                    SsrcAssociation it6 = (SsrcAssociation)element$iv2;
                    boolean bl22 = false;
                    this.addSsrcAssociation(endpoint2.getId(), it6);
                }
            }
            List<MediaSource> list5 = sources2.getMediaSources();
            Intrinsics.checkNotNullExpressionValue(list5, "getMediaSources(...)");
            Iterable $this$filter$iv = list5;
            boolean $i$f$filter = false;
            Iterable element$iv = $this$filter$iv;
            Iterable destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                it = (MediaSource)element$iv$iv;
                boolean bl23 = false;
                if (!(((MediaSource)it).getType() == MediaType.VIDEO)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$mapNotNull = false;
            $this$filterTo$iv$iv2 = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach4 = false;
            it = $this$forEach$iv$iv$iv.iterator();
            while (it.hasNext()) {
                MediaSourceDesc it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = it.next();
                boolean bl24 = false;
                MediaSource it7 = (MediaSource)element$iv$iv;
                boolean bl25 = false;
                if (MediaSourceFactory.createMediaSource((Collection<SourcePacketExtension>)it7.getSources(), (Collection<SourceGroupPacketExtension>)it7.getSsrcGroups(), c2endpoint.getId(), it7.getId()) == null) continue;
                boolean bl26 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List newMediaSources = (List)destination$iv$iv;
            Collection $this$toTypedArray$iv = newMediaSources;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            endpoint2.setMediaSources(thisCollection$iv.toArray(new MediaSourceDesc[0]));
            ArrayList<AudioSourceDesc> audioSources = new ArrayList<AudioSourceDesc>();
            List<MediaSource> list6 = sources2.getMediaSources();
            Intrinsics.checkNotNullExpressionValue(list6, "getMediaSources(...)");
            Iterable $this$filter$iv2 = list6;
            boolean $i$f$filter2 = false;
            destination$iv$iv = $this$filter$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                MediaSource it8 = (MediaSource)element$iv$iv;
                boolean bl27 = false;
                if (!(it8.getType() == MediaType.AUDIO)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            $this$filter$iv2 = (List)destination$iv$iv2;
            boolean $i$f$forEach5 = false;
            for (Object element$iv3 : $this$forEach$iv) {
                MediaSource it9 = (MediaSource)element$iv3;
                boolean bl28 = false;
                List<SourcePacketExtension> list7 = it9.getSources();
                Intrinsics.checkNotNullExpressionValue(list7, "getSources(...)");
                Iterable $this$forEach$iv4 = list7;
                boolean $i$f$forEach6 = false;
                for (Object element$iv4 : $this$forEach$iv4) {
                    SourcePacketExtension s2 = (SourcePacketExtension)element$iv4;
                    boolean bl29 = false;
                    audioSources.add(new AudioSourceDesc(s2.getSSRC(), c2endpoint.getId(), it9.getId()));
                }
            }
            endpoint2.setAudioSources(audioSources);
        }
        ForceMute forceMute = c2endpoint.getForceMute();
        if (forceMute != null) {
            ForceMute it = forceMute;
            boolean bl30 = false;
            endpoint2.updateForceMute(it.getAudio(), it.getVideo());
        }
        Colibri2Endpoint colibri2Endpoint = respBuilder.build();
        Intrinsics.checkNotNullExpressionValue(colibri2Endpoint, "build(...)");
        return colibri2Endpoint;
    }

    private final void addSsrcAssociation(String endpointId, SsrcAssociation ssrcAssociation) {
        this.conference.getEncodingsManager().addSsrcAssociation(endpointId, ssrcAssociation.getPrimarySsrc(), ssrcAssociation.getSecondarySsrc(), ssrcAssociation.getType());
    }

    private final SsrcAssociation toSsrcAssociation(SourceGroupPacketExtension $this$toSsrcAssociation) {
        if ($this$toSsrcAssociation.getSources().size() < 2) {
            this.logger.warn("Ignoring source group with <2 sources: " + XmlStringBuilderUtil.Companion.toStringOpt($this$toSsrcAssociation));
            return null;
        }
        String string = $this$toSsrcAssociation.getSemantics();
        Intrinsics.checkNotNullExpressionValue(string, "getSemantics(...)");
        SsrcAssociationType ssrcAssociationType = this.parseAssociationType(string);
        if (ssrcAssociationType == null) {
            return null;
        }
        SsrcAssociationType type = ssrcAssociationType;
        if (type == SsrcAssociationType.SIM) {
            return null;
        }
        return new LocalSsrcAssociation($this$toSsrcAssociation.getSources().get(0).getSSRC(), $this$toSsrcAssociation.getSources().get(1).getSSRC(), type);
    }

    private final SsrcAssociationType parseAssociationType(String $this$parseAssociationType) {
        return StringsKt.equals($this$parseAssociationType, "FID", true) ? SsrcAssociationType.RTX : (StringsKt.equals($this$parseAssociationType, "SIM", true) ? SsrcAssociationType.SIM : (StringsKt.equals($this$parseAssociationType, "FEC-FR", true) ? SsrcAssociationType.FEC : null));
    }

    private final RtpExtension toRtpExtension(RTPHdrExtPacketExtension $this$toRtpExtension) {
        String string = $this$toRtpExtension.getURI().toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        RtpExtensionType rtpExtensionType = RtpExtensionType.Companion.createFromUri(string);
        if (rtpExtensionType == null) {
            return null;
        }
        RtpExtensionType type = rtpExtensionType;
        Byte by = Byte.valueOf($this$toRtpExtension.getID());
        Intrinsics.checkNotNullExpressionValue(by, "valueOf(...)");
        return new RtpExtension(((Number)by).byteValue(), type);
    }

    /*
     * WARNING - void declaration
     */
    private final Colibri2Relay handleColibri2Relay(Colibri2Relay c2relay, boolean ignoreUnknownRelays) throws IqProcessingException {
        AbstractPacketExtension abstractPacketExtension;
        boolean bl;
        Colibri2Relay.Builder builder2 = Colibri2Relay.getBuilder();
        Intrinsics.checkNotNullExpressionValue(builder2, "getBuilder(...)");
        Colibri2Relay.Builder respBuilder = builder2;
        respBuilder.setId(c2relay.getId());
        if (c2relay.getExpire()) {
            Relay relay = this.conference.getRelay(c2relay.getId());
            if (relay != null) {
                relay.expire();
            }
            respBuilder.setExpire(true);
            Colibri2Relay colibri2Relay = respBuilder.build();
            Intrinsics.checkNotNullExpressionValue(colibri2Relay, "build(...)");
            return colibri2Relay;
        }
        Relay relay = null;
        if (c2relay.getCreate()) {
            if (this.conference.getRelay(c2relay.getId()) != null) {
                throw new IqProcessingException(StanzaError.Condition.conflict, "Relay with ID " + c2relay.getId() + " already exists");
            }
            Transport transport = c2relay.getTransport();
            if (transport == null) {
                throw new IqProcessingException(StanzaError.Condition.bad_request, "Attempt to create relay " + c2relay.getId() + " with no <transport>");
            }
            Transport transport2 = transport;
            relay = this.conference.createRelay(c2relay.getId(), c2relay.getMeshId(), transport2.getIceControlling(), transport2.getUseUniquePort());
        } else {
            relay = this.conference.getRelay(c2relay.getId());
        }
        if (relay == null) {
            if (ignoreUnknownRelays) {
                Colibri2Relay colibri2Relay = respBuilder.build();
                Intrinsics.checkNotNullExpressionValue(colibri2Relay, "build(...)");
                return colibri2Relay;
            }
            throw new IqProcessingException(StanzaError.Condition.bad_request, "Unknown relay " + c2relay.getId());
        }
        AbstractPacketExtension abstractPacketExtension2 = c2relay.getTransport();
        if (abstractPacketExtension2 != null && (abstractPacketExtension2 = ((Transport)abstractPacketExtension2).getSctp()) != null) {
            AbstractPacketExtension sctp = abstractPacketExtension2;
            bl = false;
            if (!SctpConfig.config.getEnabled()) {
                throw new IqProcessingException(StanzaError.Condition.feature_not_implemented, "SCTP support is not configured");
            }
            if (((Sctp)sctp).getPort() != null) {
                Integer n = ((Sctp)sctp).getPort();
                int n2 = 5000;
                if (n == null || n != n2) {
                    throw new IqProcessingException(StanzaError.Condition.bad_request, "Specific SCTP port requested, not supported.");
                }
            }
            relay.createSctpConnection((Sctp)sctp);
        }
        if ((abstractPacketExtension = c2relay.getTransport()) != null && (abstractPacketExtension = abstractPacketExtension.getIceUdpTransport()) != null) {
            AbstractPacketExtension it = abstractPacketExtension;
            bl = false;
            relay.setTransportInfo((IceUdpTransportPacketExtension)it);
        }
        if (c2relay.getCreate()) {
            Transport.Builder builder3 = Transport.getBuilder();
            Intrinsics.checkNotNullExpressionValue(builder3, "getBuilder(...)");
            Transport.Builder transBuilder = builder3;
            transBuilder.setIceUdpExtension(relay.describeTransport());
            AbstractPacketExtension abstractPacketExtension3 = c2relay.getTransport();
            if (abstractPacketExtension3 != null && (abstractPacketExtension3 = ((Transport)abstractPacketExtension3).getSctp()) != null) {
                AbstractPacketExtension it = abstractPacketExtension3;
                boolean bl2 = false;
                Sctp.Role role = ((Sctp)it).getRole() == Sctp.Role.CLIENT ? Sctp.Role.SERVER : Sctp.Role.CLIENT;
                transBuilder.setSctp(new Sctp.Builder().setPort(5000).setRole(role).build());
            }
            respBuilder.setTransport(transBuilder.build());
        }
        for (Object e : c2relay.getMedia()) {
            Object it;
            boolean bl3;
            Intrinsics.checkNotNullExpressionValue(e, "next(...)");
            Media media = (Media)e;
            List<PayloadTypePacketExtension> list = media.getPayloadTypes();
            Intrinsics.checkNotNullExpressionValue(list, "getPayloadTypes(...)");
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PayloadTypePacketExtension ptExt = (PayloadTypePacketExtension)element$iv;
                bl3 = false;
                Intrinsics.checkNotNull(ptExt);
                MediaType mediaType = media.getType();
                Intrinsics.checkNotNullExpressionValue((Object)mediaType, "getType(...)");
                if (PayloadTypeUtil.Companion.create(ptExt, mediaType) != null) {
                    boolean bl2 = false;
                    relay.addPayloadType((PayloadType)it);
                    continue;
                }
                this.logger.warn("Ignoring unrecognized payload type extension: " + XmlStringBuilderUtil.Companion.toStringOpt(ptExt));
            }
            List<RTPHdrExtPacketExtension> list2 = media.getRtpHdrExts();
            Intrinsics.checkNotNullExpressionValue(list2, "getRtpHdrExts(...)");
            $this$forEach$iv = list2;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                RTPHdrExtPacketExtension rtpHdrExt = (RTPHdrExtPacketExtension)element$iv;
                bl3 = false;
                Intrinsics.checkNotNull(rtpHdrExt);
                if (this.toRtpExtension(rtpHdrExt) != null) {
                    boolean bl32 = false;
                    relay.addRtpExtension((RtpExtension)it);
                    continue;
                }
                this.logger.warn("Ignoring unrecognized RTP header extension: " + XmlStringBuilderUtil.Companion.toStringOpt(rtpHdrExt));
            }
            relay.setExtmapAllowMixed(media.getExtmapAllowMixed() != null);
        }
        Set newEndpoints = new LinkedHashSet();
        Object object = c2relay.getEndpoints();
        if (object != null && (object = ((Endpoints)object).getEndpoints()) != null) {
            Iterable $this$forEach$iv = (Iterable)object;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Object object2;
                Colibri2Endpoint endpoint = (Colibri2Endpoint)element$iv;
                boolean bl4 = false;
                if (endpoint.getExpire()) {
                    String string = endpoint.getId();
                    Intrinsics.checkNotNullExpressionValue(string, "getId(...)");
                    relay.removeRemoteEndpoint(string);
                    continue;
                }
                Intrinsics.checkNotNull(endpoint);
                Pair<List<AudioSourceDesc>, List<MediaSourceDesc>> sources = this.parseSourceDescs(endpoint);
                if (endpoint.getCreate()) {
                    String string = endpoint.getId();
                    Intrinsics.checkNotNullExpressionValue(string, "getId(...)");
                    if (relay.addRemoteEndpoint(string, endpoint.getStatsId(), (Collection<AudioSourceDesc>)sources.getFirst(), (Collection<MediaSourceDesc>)sources.getSecond()) != null) {
                        RelayedEndpoint it;
                        boolean bl42 = false;
                        newEndpoints.add(it);
                    }
                } else {
                    String string = endpoint.getId();
                    Intrinsics.checkNotNullExpressionValue(string, "getId(...)");
                    relay.updateRemoteEndpoint(string, (Collection<AudioSourceDesc>)sources.getFirst(), (Collection<MediaSourceDesc>)sources.getSecond());
                }
                if ((object2 = endpoint.getSources()) == null || (object2 = ((Sources)object2).getMediaSources()) == null) continue;
                Iterable $this$forEach$iv2 = (Iterable)object2;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    void $this$forEach$iv3;
                    void $this$mapNotNullTo$iv$iv;
                    MediaSource mediaSource = (MediaSource)element$iv2;
                    boolean bl5 = false;
                    List<SourceGroupPacketExtension> list = mediaSource.getSsrcGroups();
                    Intrinsics.checkNotNullExpressionValue(list, "getSsrcGroups(...)");
                    Iterable $this$mapNotNull$iv = list;
                    boolean $i$f$mapNotNull = false;
                    Iterable iterable = $this$mapNotNull$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach3 = false;
                    Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
                    while (iterator2.hasNext()) {
                        SsrcAssociation it$iv$iv;
                        Object element$iv$iv$iv;
                        Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                        boolean bl6 = false;
                        SourceGroupPacketExtension it = (SourceGroupPacketExtension)element$iv$iv;
                        boolean bl7 = false;
                        Intrinsics.checkNotNull(it);
                        if (this.toSsrcAssociation(it) == null) continue;
                        boolean bl8 = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    $this$mapNotNull$iv = (List)destination$iv$iv;
                    boolean $i$f$forEach4 = false;
                    for (Object element$iv3 : $this$forEach$iv3) {
                        SsrcAssociation it = (SsrcAssociation)element$iv3;
                        boolean bl9 = false;
                        String string = endpoint.getId();
                        Intrinsics.checkNotNullExpressionValue(string, "getId(...)");
                        this.addSsrcAssociation(string, it);
                    }
                }
            }
        }
        this.conference.addEndpoints(newEndpoints);
        Colibri2Relay colibri2Relay = respBuilder.build();
        Intrinsics.checkNotNullExpressionValue(colibri2Relay, "build(...)");
        return colibri2Relay;
    }

    private final Pair<List<AudioSourceDesc>, List<MediaSourceDesc>> parseSourceDescs(Colibri2Endpoint $this$parseSourceDescs) {
        List videoSources;
        List audioSources;
        block5: {
            audioSources = new ArrayList();
            videoSources = new ArrayList();
            Sources sources = $this$parseSourceDescs.getSources();
            if (sources == null) break block5;
            Sources it = sources;
            boolean bl = false;
            List<MediaSource> list = it.getMediaSources();
            Intrinsics.checkNotNullExpressionValue(list, "getMediaSources(...)");
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                MediaSource m4 = (MediaSource)element$iv;
                boolean bl2 = false;
                if (m4.getType() == MediaType.AUDIO) {
                    if (m4.getSources().isEmpty()) {
                        this.logger.warn("Ignoring audio source " + m4.getId() + " in endpoint " + $this$parseSourceDescs.getId() + " of a relay (no SSRCs): " + XmlStringBuilderUtil.Companion.toStringOpt($this$parseSourceDescs));
                        continue;
                    }
                    List<SourcePacketExtension> list2 = m4.getSources();
                    Intrinsics.checkNotNullExpressionValue(list2, "getSources(...)");
                    Iterable $this$forEach$iv2 = list2;
                    boolean $i$f$forEach2 = false;
                    for (Object element$iv2 : $this$forEach$iv2) {
                        SourcePacketExtension it2 = (SourcePacketExtension)element$iv2;
                        boolean bl3 = false;
                        audioSources.add(new AudioSourceDesc(it2.getSSRC(), $this$parseSourceDescs.getId(), m4.getId()));
                    }
                    continue;
                }
                if (m4.getType() == MediaType.VIDEO) {
                    MediaSourceDesc desc = MediaSourceFactory.createMediaSource((Collection<SourcePacketExtension>)m4.getSources(), (Collection<SourceGroupPacketExtension>)m4.getSsrcGroups(), $this$parseSourceDescs.getId(), m4.getId());
                    if (desc == null) continue;
                    videoSources.add(desc);
                    continue;
                }
                this.logger.warn("Ignoring source " + m4.getId() + " in endpoint " + $this$parseSourceDescs.getId() + " of a relay: unsupported type " + m4.getType());
            }
        }
        return new Pair<List<AudioSourceDesc>, List<MediaSourceDesc>>(audioSources, videoSources);
    }

    private final void validateRequest(ConferenceModifyIQ iq) throws FeatureNotImplementedException {
        if (iq.getEndpoints().size() > 0 && iq.getRelays().size() > 0) {
            throw new FeatureNotImplementedException("Using both 'relay' and 'endpoint' in a request");
        }
        if (iq.getEndpoints().size() > 1) {
            boolean bl;
            block7: {
                List<Colibri2Endpoint> list = iq.getEndpoints();
                Intrinsics.checkNotNullExpressionValue(list, "getEndpoints(...)");
                Iterable $this$any$iv = list;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Colibri2Endpoint it = (Colibri2Endpoint)element$iv;
                        boolean bl2 = false;
                        if (!(it.getCreate() || it.getMedia().size() > 0 || it.getTransport() != null || it.getSources() != null)) continue;
                        bl = true;
                        break block7;
                    }
                    bl = false;
                }
            }
            if (bl) {
                throw new FeatureNotImplementedException("Creating or updating media, sources or transport for more than one endpoint in a request.");
            }
        }
        if (iq.getRelays().size() > 1) {
            throw new FeatureNotImplementedException("Updating more than one 'relay' in a request.");
        }
    }
}

