/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.group;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.log.UnifiedLog;
import kafka.server.ReplicaManager;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.NotLeaderOrFollowerException;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MutableRecordBatch;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.requests.TransactionResult;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.coordinator.group.runtime.CoordinatorLoader;
import org.apache.kafka.coordinator.group.runtime.CoordinatorPlayback;
import org.apache.kafka.server.util.KafkaScheduler;
import org.apache.kafka.storage.internals.log.FetchDataInfo;
import org.apache.kafka.storage.internals.log.FetchIsolation;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005]c\u0001B\u0007\u000f\u0001UA\u0001\u0002\u0011\u0001\u0003\u0002\u0003\u0006I!\u0011\u0005\t\u0011\u0002\u0011\t\u0011)A\u0005\u0013\"Aq\n\u0001B\u0001B\u0003%\u0001\u000b\u0003\u0005g\u0001\t\u0005\t\u0015!\u0003h\u0011\u0015Q\u0007\u0001\"\u0001l\u0011\u001d\u0011\bA1A\u0005\nMDaA \u0001!\u0002\u0013!\b\u0002C@\u0001\u0005\u0004%I!!\u0001\t\u0011\u0005=\u0001\u0001)A\u0005\u0003\u0007Aq!!\u0005\u0001\t\u0003\n\u0019\u0002C\u0004\u00028\u0001!I!!\u000f\t\u000f\u0005M\u0003\u0001\"\u0011\u0002V\t)2i\\8sI&t\u0017\r^8s\u0019>\fG-\u001a:J[Bd'BA\b\u0011\u0003\u00159'o\\;q\u0015\t\t\"#A\u0006d_>\u0014H-\u001b8bi>\u0014(\"A\n\u0002\u000b-\fgm[1\u0004\u0001U\u0011aCL\n\u0005\u0001]y\"\b\u0005\u0002\u0019;5\t\u0011D\u0003\u0002\u001b7\u0005!A.\u00198h\u0015\u0005a\u0012\u0001\u00026bm\u0006L!AH\r\u0003\r=\u0013'.Z2u!\r\u0001#\u0006L\u0007\u0002C)\u0011!eI\u0001\beVtG/[7f\u0015\tyAE\u0003\u0002\u0012K)\u00111C\n\u0006\u0003O!\na!\u00199bG\",'\"A\u0015\u0002\u0007=\u0014x-\u0003\u0002,C\t\t2i\\8sI&t\u0017\r^8s\u0019>\fG-\u001a:\u0011\u00055rC\u0002\u0001\u0003\u0006_\u0001\u0011\r\u0001\r\u0002\u0002)F\u0011\u0011g\u000e\t\u0003eUj\u0011a\r\u0006\u0002i\u0005)1oY1mC&\u0011ag\r\u0002\b\u001d>$\b.\u001b8h!\t\u0011\u0004(\u0003\u0002:g\t\u0019\u0011I\\=\u0011\u0005mrT\"\u0001\u001f\u000b\u0005u\u0012\u0012!B;uS2\u001c\u0018BA =\u0005\u001daunZ4j]\u001e\fA\u0001^5nKB\u0011!IR\u0007\u0002\u0007*\u0011Q\b\u0012\u0006\u0003\u000b\u0016\naaY8n[>t\u0017BA$D\u0005\u0011!\u0016.\\3\u0002\u001dI,\u0007\u000f\\5dC6\u000bg.Y4feB\u0011!*T\u0007\u0002\u0017*\u0011AJE\u0001\u0007g\u0016\u0014h/\u001a:\n\u00059[%A\u0004*fa2L7-Y'b]\u0006<WM]\u0001\rI\u0016\u001cXM]5bY&TXM\u001d\t\u0004#\u000edcB\u0001*b\u001d\t\u0019\u0006M\u0004\u0002U?:\u0011QK\u0018\b\u0003-vs!a\u0016/\u000f\u0005a[V\"A-\u000b\u0005i#\u0012A\u0002\u001fs_>$h(C\u0001*\u0013\t9\u0003&\u0003\u0002\u0014M%\u0011\u0011#J\u0005\u0003\u001f\u0011J!AI\u0012\n\u0005\t\f\u0013!E\"p_J$\u0017N\\1u_Jdu.\u00193fe&\u0011A-\u001a\u0002\r\t\u0016\u001cXM]5bY&TXM\u001d\u0006\u0003E\u0006\na\u0002\\8bI\n+hMZ3s'&TX\r\u0005\u00023Q&\u0011\u0011n\r\u0002\u0004\u0013:$\u0018A\u0002\u001fj]&$h\bF\u0003m]>\u0004\u0018\u000fE\u0002n\u00011j\u0011A\u0004\u0005\u0006\u0001\u0016\u0001\r!\u0011\u0005\u0006\u0011\u0016\u0001\r!\u0013\u0005\u0006\u001f\u0016\u0001\r\u0001\u0015\u0005\u0006M\u0016\u0001\raZ\u0001\nSN\u0014VO\u001c8j]\u001e,\u0012\u0001\u001e\t\u0003krl\u0011A\u001e\u0006\u0003ob\fa!\u0019;p[&\u001c'BA={\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003wn\tA!\u001e;jY&\u0011QP\u001e\u0002\u000e\u0003R|W.[2C_>dW-\u00198\u0002\u0015%\u001c(+\u001e8oS:<\u0007%A\u0005tG\",G-\u001e7feV\u0011\u00111\u0001\t\u0005\u0003\u000b\tY!\u0004\u0002\u0002\b)\u001910!\u0003\u000b\u00051+\u0013\u0002BA\u0007\u0003\u000f\u0011abS1gW\u0006\u001c6\r[3ek2,'/\u0001\u0006tG\",G-\u001e7fe\u0002\nA\u0001\\8bIR1\u0011QCA\u0012\u0003_\u0001b!a\u0006\u0002\u001a\u0005uQ\"\u0001=\n\u0007\u0005m\u0001PA\tD_6\u0004H.\u001a;bE2,g)\u001e;ve\u0016\u00042!UA\u0010\u0013\r\t\t#\u001a\u0002\f\u0019>\fGmU;n[\u0006\u0014\u0018\u0010C\u0004\u0002&)\u0001\r!a\n\u0002\u0005Q\u0004\b\u0003BA\u0015\u0003Wi\u0011\u0001R\u0005\u0004\u0003[!%A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0005\u0007#)\u0001\r!!\r\u0011\t\u0001\n\u0019\u0004L\u0005\u0004\u0003k\t#aE\"p_J$\u0017N\\1u_J\u0004F.Y=cC\u000e\\\u0017A\u00023p\u0019>\fG\r\u0006\u0006\u0002<\u0005\u0005\u00131IA#\u0003\u0013\u00022AMA\u001f\u0013\r\tyd\r\u0002\u0005+:LG\u000fC\u0004\u0002&-\u0001\r!a\n\t\rEY\u0001\u0019AA\u0019\u0011\u001d\t9e\u0003a\u0001\u0003+\taAZ;ukJ,\u0007bBA&\u0017\u0001\u0007\u0011QJ\u0001\fgR\f'\u000f\u001e+j[\u0016l5\u000fE\u00023\u0003\u001fJ1!!\u00154\u0005\u0011auN\\4\u0002\u000b\rdwn]3\u0015\u0005\u0005m\u0002")
public class CoordinatorLoaderImpl<T>
implements CoordinatorLoader<T>,
Logging {
    private final Time time;
    private final ReplicaManager replicaManager;
    private final CoordinatorLoader.Deserializer<T> deserializer;
    private final int loadBufferSize;
    private final AtomicBoolean isRunning;
    private final KafkaScheduler scheduler;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private AtomicBoolean isRunning() {
        return this.isRunning;
    }

    private KafkaScheduler scheduler() {
        return this.scheduler;
    }

    public CompletableFuture<CoordinatorLoader.LoadSummary> load(TopicPartition tp, CoordinatorPlayback<T> coordinator) {
        CompletableFuture<CoordinatorLoader.LoadSummary> future = new CompletableFuture<CoordinatorLoader.LoadSummary>();
        long startTimeMs = this.time.milliseconds();
        if (this.scheduler().scheduleOnce(new StringBuilder(22).append("Load coordinator from ").append(tp).toString(), () -> this.doLoad(tp, coordinator, future, startTimeMs)).isCancelled()) {
            future.completeExceptionally(new RuntimeException("Coordinator loader is closed."));
        }
        return future;
    }

    private void doLoad(TopicPartition tp, CoordinatorPlayback<T> coordinator, CompletableFuture<CoordinatorLoader.LoadSummary> future, long startTimeMs) {
        block16: {
            try {
                Option<UnifiedLog> option = this.replicaManager.getLog(tp);
                if (None$.MODULE$.equals(option)) {
                    future.completeExceptionally((Throwable)new NotLeaderOrFollowerException(new StringBuilder(60).append("Could not load records from ").append(tp).append(" because the log does not exist.").toString()));
                    break block16;
                }
                if (option instanceof Some) {
                    UnifiedLog log = (UnifiedLog)((Some)option).value();
                    ByteBuffer buffer = ByteBuffer.allocate(0);
                    LongRef currentOffset = LongRef.create((long)log.logStartOffset());
                    boolean readAtLeastOneRecord = true;
                    LongRef previousHighWatermark = LongRef.create((long)-1L);
                    IntRef numRecords = IntRef.create((int)0);
                    int numBytes = 0;
                    while (currentOffset.elem < this.logEndOffset$1(tp) && readAtLeastOneRecord && this.isRunning().get()) {
                        MemoryRecords memoryRecords;
                        FetchDataInfo fetchDataInfo = log.read(currentOffset.elem, this.loadBufferSize, FetchIsolation.LOG_END, true);
                        readAtLeastOneRecord = fetchDataInfo.records.sizeInBytes() > 0;
                        Records records = fetchDataInfo.records;
                        if (records instanceof MemoryRecords) {
                            memoryRecords = (MemoryRecords)records;
                        } else if (records instanceof FileRecords) {
                            FileRecords fileRecords = (FileRecords)records;
                            int sizeInBytes = fileRecords.sizeInBytes();
                            int bytesNeeded = Math.max(this.loadBufferSize, sizeInBytes);
                            if (buffer.capacity() < bytesNeeded) {
                                if (this.loadBufferSize < bytesNeeded) {
                                    this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(87).append("Loaded metadata from ").append(tp).append(" with buffer larger (").append(bytesNeeded).append(" bytes) than ").append("configured buffer size (").append($this.loadBufferSize).append(" bytes).").toString());
                                }
                                buffer = ByteBuffer.allocate(bytesNeeded);
                            } else {
                                buffer.clear();
                            }
                            fileRecords.readInto(buffer, 0);
                            memoryRecords = MemoryRecords.readableRecords((ByteBuffer)buffer);
                        } else {
                            throw new MatchError((Object)records);
                        }
                        MemoryRecords memoryRecords2 = memoryRecords;
                        memoryRecords2.batches().forEach(batch -> {
                            if (batch.isControlBatch()) {
                                CollectionConverters$.MODULE$.IterableHasAsScala((Iterable)batch).asScala().foreach((Function1 & Serializable)record -> {
                                    CoordinatorLoaderImpl.$anonfun$doLoad$4(coordinator, batch, record);
                                    return BoxedUnit.UNIT;
                                });
                            } else {
                                CollectionConverters$.MODULE$.IterableHasAsScala((Iterable)batch).asScala().foreach((Function1 & Serializable)record -> {
                                    CoordinatorLoaderImpl.$anonfun$doLoad$5(this, numRecords, coordinator, batch, tp, record);
                                    return BoxedUnit.UNIT;
                                });
                            }
                            currentOffset$1.elem = batch.nextOffset();
                            long currentHighWatermark = log.highWatermark();
                            if (currentOffset$1.elem >= currentHighWatermark) {
                                coordinator.updateLastWrittenOffset(Predef$.MODULE$.long2Long(currentOffset$1.elem));
                                if (currentHighWatermark > previousHighWatermark$1.elem) {
                                    coordinator.updateLastCommittedOffset(Predef$.MODULE$.long2Long(currentHighWatermark));
                                    previousHighWatermark$1.elem = currentHighWatermark;
                                    return;
                                }
                                return;
                            }
                        });
                        numBytes += memoryRecords2.sizeInBytes();
                    }
                    long endTimeMs = this.time.milliseconds();
                    if (this.logEndOffset$1(tp) == -1L) {
                        future.completeExceptionally((Throwable)new NotLeaderOrFollowerException(new StringBuilder(93).append("Stopped loading records from ").append(tp).append(" because the partition is not online or is no longer the leader.").toString()));
                    } else if (this.isRunning().get()) {
                        future.complete(new CoordinatorLoader.LoadSummary(startTimeMs, endTimeMs, (long)numRecords.elem, (long)numBytes));
                    } else {
                        future.completeExceptionally(new RuntimeException("Coordinator loader is closed."));
                    }
                    break block16;
                }
                throw new MatchError(option);
            }
            catch (Throwable ex) {
                future.completeExceptionally(ex);
            }
        }
    }

    public void close() {
        if (!this.isRunning().compareAndSet(true, false)) {
            this.warn((Function0<String>)(Function0 & Serializable)() -> "Coordinator loader is already shutting down.");
            return;
        }
        this.scheduler().shutdown();
    }

    private final long logEndOffset$1(TopicPartition tp$2) {
        return BoxesRunTime.unboxToLong((Object)this.replicaManager.getLogEndOffset(tp$2).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> -1L));
    }

    public static final /* synthetic */ void $anonfun$doLoad$4(CoordinatorPlayback coordinator$2, MutableRecordBatch batch$1, Record record) {
        block8: {
            block7: {
                ControlRecordType controlRecordType;
                ControlRecordType controlRecordType2;
                block6: {
                    ControlRecordType controlRecord;
                    ControlRecordType controlRecordType3 = controlRecord = ControlRecordType.parse((ByteBuffer)record.key());
                    ControlRecordType controlRecordType4 = ControlRecordType.COMMIT;
                    if (!(controlRecordType3 != null ? !controlRecordType3.equals(controlRecordType4) : controlRecordType4 != null)) {
                        coordinator$2.replayEndTransactionMarker(batch$1.producerId(), batch$1.producerEpoch(), TransactionResult.COMMIT);
                        return;
                    }
                    controlRecordType2 = controlRecord;
                    controlRecordType = ControlRecordType.ABORT;
                    if (controlRecordType2 != null) break block6;
                    if (controlRecordType != null) {
                        return;
                    }
                    break block7;
                }
                if (!controlRecordType2.equals(controlRecordType)) break block8;
            }
            coordinator$2.replayEndTransactionMarker(batch$1.producerId(), batch$1.producerEpoch(), TransactionResult.ABORT);
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$doLoad$5(CoordinatorLoaderImpl $this, IntRef numRecords$1, CoordinatorPlayback coordinator$2, MutableRecordBatch batch$1, TopicPartition tp$2, Record record) {
        ++numRecords$1.elem;
        try {
            coordinator$2.replay(batch$1.producerId(), batch$1.producerEpoch(), $this.deserializer.deserialize(record.key(), record.value()));
            return;
        }
        catch (CoordinatorLoader.UnknownRecordTypeException ex) {
            $this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(130).append("Unknown record type ").append(ex.unknownType()).append(" while loading offsets and group metadata ").append("from ").append(tp$2).append(". Ignoring it. It could be a left over from an aborted upgrade.").toString());
            return;
        }
    }

    public CoordinatorLoaderImpl(Time time, ReplicaManager replicaManager, CoordinatorLoader.Deserializer<T> deserializer, int loadBufferSize) {
        this.time = time;
        this.replicaManager = replicaManager;
        this.deserializer = deserializer;
        this.loadBufferSize = loadBufferSize;
        this.isRunning = new AtomicBoolean(true);
        this.scheduler = new KafkaScheduler(1);
        this.scheduler().startup();
    }
}

