/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.postag;

import java.io.IOException;
import opennlp.tools.postag.POSSample;
import opennlp.tools.util.FilterObjectStream;
import opennlp.tools.util.InvalidFormatException;
import opennlp.tools.util.ObjectStream;

public class WordTagSampleStream
extends FilterObjectStream<String, POSSample> {
    public WordTagSampleStream(ObjectStream<String> sentences) {
        super(sentences);
    }

    @Override
    public POSSample read() throws IOException {
        String sentence = (String)this.samples.read();
        if (sentence != null) {
            POSSample sample;
            try {
                sample = POSSample.parse(sentence);
            }
            catch (InvalidFormatException e) {
                System.out.println("Error during parsing, ignoring sentence: " + sentence);
                sample = new POSSample(new String[0], new String[0]);
            }
            return sample;
        }
        return null;
    }
}

