/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.PLPInputStream;
import java.io.IOException;

final class PLPXMLInputStream
extends PLPInputStream {
    int bomBytesSent = 0;
    int markBOMBytesSent = 0;
    private static final byte[] xmlBOM = new byte[]{-1, -2};

    PLPXMLInputStream(byte[] byArray, int n) throws IOException {
        super(byArray, n);
    }

    int getDataLength() {
        return this.totalLength + 2;
    }

    int getDataLengthWithoutBOM() {
        return this.totalLength;
    }

    public long skip(long l) throws IOException {
        this.checkClosed();
        if (l <= 0L) {
            return 0L;
        }
        if (this.bomBytesSent < 2) {
            ++this.bomBytesSent;
            if (0L == --l) {
                return 1L;
            }
            if (this.bomBytesSent < 2) {
                ++this.bomBytesSent;
                --l;
            }
            if (0L == l) {
                return 2L;
            }
            return 2L + super.skip(l);
        }
        return super.skip(l);
    }

    public int available() throws IOException {
        this.checkClosed();
        if (this.isNull() || 0 == this.totalLength) {
            return -1;
        }
        if (this.bomBytesSent < 2) {
            return super.available() + (2 - this.bomBytesSent);
        }
        return super.available();
    }

    public int read() throws IOException {
        this.checkClosed();
        if (this.isNull() || 0 == this.totalLength) {
            return -1;
        }
        if (this.bomBytesSent < 2) {
            return xmlBOM[this.bomBytesSent++] & 0xFF;
        }
        return super.read();
    }

    public int read(byte[] byArray) throws IOException, NullPointerException {
        this.checkClosed();
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException, NullPointerException {
        this.checkClosed();
        if (this.isNull() || 0 == this.totalLength) {
            return -1;
        }
        if (null == byArray) {
            throw new NullPointerException();
        }
        if (0 == byArray.length) {
            return 0;
        }
        if (n2 <= 0 || n < 0) {
            return 0;
        }
        if (n >= byArray.length) {
            return 0;
        }
        if (n + n2 > byArray.length) {
            n2 = byArray.length - n;
        }
        if (this.bomBytesSent < 2) {
            boolean bl = true;
            byArray[n++] = xmlBOM[this.bomBytesSent++];
            if (0 == --n2) {
                return 1;
            }
            if (this.bomBytesSent < 2) {
                byArray[n++] = xmlBOM[this.bomBytesSent++];
                --n2;
            }
            if (0 == n2) {
                return 2;
            }
            return 2 + this.readBytesInternal(byArray, n, n2);
        }
        return this.readBytesInternal(byArray, n, n2);
    }

    public void mark(int n) {
        this.markBOMBytesSent = this.bomBytesSent;
        super.mark(n);
    }

    public boolean markSupported() {
        return true;
    }

    public void close() throws IOException {
        super.close();
    }

    public void reset() throws IOException {
        this.checkClosed();
        this.bomBytesSent = this.markBOMBytesSent;
        super.reset();
    }
}

