/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.provider;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.namespace.QName;
import org.jivesoftware.smack.Smack;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Nonza;
import org.jivesoftware.smack.provider.ExtensionElementProvider;
import org.jivesoftware.smack.provider.ExtensionProviderInfo;
import org.jivesoftware.smack.provider.IQProviderInfo;
import org.jivesoftware.smack.provider.IqProvider;
import org.jivesoftware.smack.provider.NonzaProvider;
import org.jivesoftware.smack.provider.ProviderLoader;
import org.jivesoftware.smack.provider.StreamFeatureProviderInfo;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.util.XmppElementUtil;

public final class ProviderManager {
    private static final Map<QName, ExtensionElementProvider<ExtensionElement>> extensionProviders = new ConcurrentHashMap<QName, ExtensionElementProvider<ExtensionElement>>();
    private static final Map<QName, IqProvider<IQ>> iqProviders = new ConcurrentHashMap<QName, IqProvider<IQ>>();
    private static final Map<QName, ExtensionElementProvider<ExtensionElement>> streamFeatureProviders = new ConcurrentHashMap<QName, ExtensionElementProvider<ExtensionElement>>();
    private static final Map<QName, NonzaProvider<? extends Nonza>> nonzaProviders = new ConcurrentHashMap<QName, NonzaProvider<? extends Nonza>>();

    public static void addLoader(ProviderLoader loader) {
        if (loader.getIQProviderInfo() != null) {
            for (IQProviderInfo iQProviderInfo : loader.getIQProviderInfo()) {
                ProviderManager.addIQProvider(iQProviderInfo.getElementName(), iQProviderInfo.getNamespace(), iQProviderInfo.getProvider());
            }
        }
        if (loader.getExtensionProviderInfo() != null) {
            for (ExtensionProviderInfo extensionProviderInfo : loader.getExtensionProviderInfo()) {
                ProviderManager.addExtensionProvider(extensionProviderInfo.getElementName(), extensionProviderInfo.getNamespace(), extensionProviderInfo.getProvider());
            }
        }
        if (loader.getStreamFeatureProviderInfo() != null) {
            for (StreamFeatureProviderInfo streamFeatureProviderInfo : loader.getStreamFeatureProviderInfo()) {
                ProviderManager.addStreamFeatureProvider(streamFeatureProviderInfo.getElementName(), streamFeatureProviderInfo.getNamespace(), (ExtensionElementProvider)streamFeatureProviderInfo.getProvider());
            }
        }
    }

    public static IqProvider<IQ> getIQProvider(String elementName, String namespace) {
        QName key = ProviderManager.getQName(elementName, namespace);
        return iqProviders.get(key);
    }

    public static List<IqProvider<IQ>> getIQProviders() {
        ArrayList<IqProvider<IQ>> providers = new ArrayList<IqProvider<IQ>>(iqProviders.size());
        providers.addAll(iqProviders.values());
        return providers;
    }

    public static void addIQProvider(String elementName, String namespace, Object provider) {
        ProviderManager.validate(elementName, namespace);
        QName key = ProviderManager.removeIQProvider(elementName, namespace);
        if (!(provider instanceof IqProvider)) {
            throw new IllegalArgumentException("Provider must be an instance of IqProvider");
        }
        iqProviders.put(key, (IqProvider)provider);
    }

    public static QName removeIQProvider(String elementName, String namespace) {
        QName key = ProviderManager.getQName(elementName, namespace);
        iqProviders.remove(key);
        return key;
    }

    public static ExtensionElementProvider<ExtensionElement> getExtensionProvider(String elementName, String namespace) {
        QName key = ProviderManager.getQName(elementName, namespace);
        return ProviderManager.getExtensionProvider(key);
    }

    public static ExtensionElementProvider<ExtensionElement> getExtensionProvider(QName qname) {
        return extensionProviders.get(qname);
    }

    public static void addExtensionProvider(String elementName, String namespace, Object provider) {
        ProviderManager.validate(elementName, namespace);
        QName key = ProviderManager.removeExtensionProvider(elementName, namespace);
        if (!(provider instanceof ExtensionElementProvider)) {
            throw new IllegalArgumentException("Provider must be a PacketExtensionProvider");
        }
        extensionProviders.put(key, (ExtensionElementProvider)provider);
    }

    public static QName removeExtensionProvider(String elementName, String namespace) {
        QName key = ProviderManager.getQName(elementName, namespace);
        extensionProviders.remove(key);
        return key;
    }

    public static List<ExtensionElementProvider<ExtensionElement>> getExtensionProviders() {
        ArrayList<ExtensionElementProvider<ExtensionElement>> providers = new ArrayList<ExtensionElementProvider<ExtensionElement>>(extensionProviders.size());
        providers.addAll(extensionProviders.values());
        return providers;
    }

    public static ExtensionElementProvider<ExtensionElement> getStreamFeatureProvider(String elementName, String namespace) {
        QName key = ProviderManager.getQName(elementName, namespace);
        return streamFeatureProviders.get(key);
    }

    public static void addStreamFeatureProvider(String elementName, String namespace, ExtensionElementProvider<ExtensionElement> provider) {
        ProviderManager.validate(elementName, namespace);
        QName key = ProviderManager.getQName(elementName, namespace);
        streamFeatureProviders.put(key, provider);
    }

    public static void removeStreamFeatureProvider(String elementName, String namespace) {
        QName key = ProviderManager.getQName(elementName, namespace);
        streamFeatureProviders.remove(key);
    }

    public static NonzaProvider<? extends Nonza> getNonzaProvider(String elementName, String namespace) {
        QName key = ProviderManager.getQName(elementName, namespace);
        return ProviderManager.getNonzaProvider(key);
    }

    public static NonzaProvider<? extends Nonza> getNonzaProvider(QName key) {
        return nonzaProviders.get(key);
    }

    public static void addNonzaProvider(NonzaProvider<? extends Nonza> nonzaProvider) {
        Class nonzaClass = nonzaProvider.getElementClass();
        QName key = XmppElementUtil.getQNameFor(nonzaClass);
        nonzaProviders.put(key, nonzaProvider);
    }

    public static void removeNonzaProvider(Class<? extends Nonza> nonzaClass) {
        QName key = XmppElementUtil.getQNameFor(nonzaClass);
        nonzaProviders.remove(key);
    }

    public static void removeNonzaProvider(String elementName, String namespace) {
        QName key = ProviderManager.getQName(elementName, namespace);
        nonzaProviders.remove(key);
    }

    private static QName getQName(String elementName, String namespace) {
        return new QName(namespace, elementName);
    }

    private static void validate(String elementName, String namespace) {
        if (StringUtils.isNullOrEmpty((CharSequence)elementName)) {
            throw new IllegalArgumentException("elementName must not be null or empty");
        }
        if (StringUtils.isNullOrEmpty((CharSequence)namespace)) {
            throw new IllegalArgumentException("namespace must not be null or empty");
        }
    }

    static {
        Smack.ensureInitialized();
    }
}

