/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.common.patterns;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalLong;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import lombok.Generated;

public class BrainLogParser {
    private static final String VARIABLE_DENOTER = "<*>";
    public static final Map<Pattern, String> DEFAULT_FILTER_PATTERN_VARIABLE_MAP = new LinkedHashMap<Pattern, String>();
    public static final List<String> DEFAULT_DELIMITERS;
    private static final String POSITIONED_TOKEN_KEY_FORMAT = "%d-%s";
    private static final String GROUP_TOKEN_SET_KEY_FORMAT = "%d-%s-%d";
    public static final int DEFAULT_VARIABLE_COUNT_THRESHOLD = 5;
    public static final float DEFAULT_FREQUENCY_THRESHOLD_PERCENTAGE = 0.3f;
    private final Map<String, Long> tokenFreqMap;
    private final Map<String, Set<String>> groupTokenSetMap;
    private final Map<String, String> logIdGroupCandidateMap;
    private int variableCountThreshold;
    private float thresholdPercentage;
    private final Map<Pattern, String> filterPatternVariableMap;
    private final List<String> delimiters;

    public BrainLogParser() {
        this(5, 0.3f, DEFAULT_FILTER_PATTERN_VARIABLE_MAP, DEFAULT_DELIMITERS);
    }

    public BrainLogParser(int variableCountThreshold, float thresholdPercentage) {
        this(variableCountThreshold, thresholdPercentage, DEFAULT_FILTER_PATTERN_VARIABLE_MAP, DEFAULT_DELIMITERS);
    }

    public BrainLogParser(Map<Pattern, String> filterPatternVariableMap, List<String> delimiters) {
        this(5, 0.3f, filterPatternVariableMap, delimiters);
    }

    public BrainLogParser(int variableCountThreshold, float thresholdPercentage, Map<Pattern, String> filterPatternVariableMap, List<String> delimiters) {
        if (thresholdPercentage < 0.0f || thresholdPercentage > 1.0f) {
            throw new IllegalArgumentException("Threshold percentage must be between 0.0 and 1.0");
        }
        this.tokenFreqMap = new HashMap<String, Long>();
        this.groupTokenSetMap = new HashMap<String, Set<String>>();
        this.logIdGroupCandidateMap = new HashMap<String, String>();
        this.variableCountThreshold = variableCountThreshold;
        this.thresholdPercentage = thresholdPercentage;
        this.filterPatternVariableMap = filterPatternVariableMap;
        this.delimiters = delimiters;
    }

    public List<String> preprocess(String logMessage, String logId) {
        if (logMessage == null || logId == null) {
            throw new IllegalArgumentException("log message or logId must not be null");
        }
        List<String> tokens = BrainLogParser.preprocess(logMessage, this.filterPatternVariableMap, this.delimiters);
        tokens.add(logId);
        return tokens;
    }

    public static List<String> preprocess(String logMessage, Map<Pattern, String> filterPatternVariableMap, List<String> delimiters) {
        for (Map.Entry<Pattern, String> patternVariablePair : filterPatternVariableMap.entrySet()) {
            logMessage = patternVariablePair.getKey().matcher(logMessage).replaceAll(patternVariablePair.getValue());
        }
        for (String delimiter : delimiters) {
            logMessage = logMessage.replace(delimiter, " ");
        }
        logMessage = logMessage.trim();
        return new ArrayList<String>(Arrays.asList(logMessage.split("\\s+")));
    }

    public void processTokenHistogram(List<String> tokens) {
        for (int i = 0; i < tokens.size() - 1; ++i) {
            String tokenKey = String.format(Locale.ROOT, POSITIONED_TOKEN_KEY_FORMAT, i, tokens.get(i));
            this.tokenFreqMap.compute(tokenKey, (k, v) -> v == null ? 1L : v + 1L);
        }
    }

    public List<List<String>> preprocessAllLogs(List<String> logMessages) {
        ArrayList<List<String>> preprocessedLogs = new ArrayList<List<String>>();
        for (int i = 0; i < logMessages.size(); ++i) {
            String logId = String.valueOf(i);
            List<String> tokens = this.preprocess(logMessages.get(i), logId);
            preprocessedLogs.add(tokens);
            this.processTokenHistogram(tokens);
        }
        this.calculateGroupTokenFreq(preprocessedLogs);
        return preprocessedLogs;
    }

    void calculateGroupTokenFreq(List<List<String>> preprocessedLogs) {
        for (List<String> tokens : preprocessedLogs) {
            Map<Long, Integer> wordOccurrences = this.getWordOccurrences(tokens);
            List<WordCombination> sortedWordCombinations = wordOccurrences.entrySet().stream().map(entry -> new WordCombination((Long)entry.getKey(), (Integer)entry.getValue())).sorted().collect(Collectors.toList());
            WordCombination candidate = this.findCandidate(sortedWordCombinations);
            String groupCandidateStr = String.format(Locale.ROOT, "%d,%d", candidate.wordFreq(), candidate.sameFreqCount());
            this.logIdGroupCandidateMap.put(tokens.get(tokens.size() - 1), groupCandidateStr);
            this.updateGroupTokenFreqMap(tokens, groupCandidateStr);
        }
    }

    public List<String> parseLogPattern(List<String> tokens) {
        return BrainLogParser.parseLogPattern(tokens, this.tokenFreqMap, this.groupTokenSetMap, this.logIdGroupCandidateMap, this.variableCountThreshold);
    }

    public static List<String> parseLogPattern(List<String> tokens, Map<String, Long> tokenFreqMap, Map<String, Set<String>> groupTokenSetMap, Map<String, String> logIdGroupCandidateMap, int variableCountThreshold) {
        String logId = tokens.get(tokens.size() - 1);
        String groupCandidateStr = logIdGroupCandidateMap.get(logId);
        String[] groupCandidate = groupCandidateStr.split(",");
        Long repFreq = Long.parseLong(groupCandidate[0]);
        return IntStream.range(0, tokens.size() - 1).mapToObj(i -> new AbstractMap.SimpleEntry<Integer, String>(i, (String)tokens.get(i))).map(entry -> {
            int index = (Integer)entry.getKey();
            String token = (String)entry.getValue();
            String tokenKey = String.format(Locale.ROOT, POSITIONED_TOKEN_KEY_FORMAT, index, token);
            assert (tokenFreqMap.get(tokenKey) != null) : String.format(Locale.ROOT, "Not found token: %s on position %d", token, index);
            boolean isHigherFrequency = (Long)tokenFreqMap.get(tokenKey) > repFreq;
            boolean isLowerFrequency = (Long)tokenFreqMap.get(tokenKey) < repFreq;
            String groupTokenKey = String.format(Locale.ROOT, GROUP_TOKEN_SET_KEY_FORMAT, tokens.size() - 1, groupCandidateStr, index);
            assert (groupTokenSetMap.get(groupTokenKey) != null) : String.format(Locale.ROOT, "Not found any token in group: %s", groupTokenKey);
            if (isHigherFrequency) {
                boolean isUniqueToken;
                boolean bl = isUniqueToken = ((Set)groupTokenSetMap.get(groupTokenKey)).size() == 1;
                if (!isUniqueToken) {
                    return VARIABLE_DENOTER;
                }
            } else if (isLowerFrequency && ((Set)groupTokenSetMap.get(groupTokenKey)).size() >= variableCountThreshold) {
                return VARIABLE_DENOTER;
            }
            return token;
        }).collect(Collectors.toList());
    }

    public Map<String, Map<String, Object>> parseAllLogPatterns(List<String> logMessages, int maxSampleCount) {
        List<List<String>> processedMessages = this.preprocessAllLogs(logMessages);
        HashMap<String, Map<String, Object>> logPatternMap = new HashMap<String, Map<String, Object>>();
        for (int i = 0; i < processedMessages.size(); ++i) {
            List<String> logPattern = this.parseLogPattern(processedMessages.get(i));
            String patternKey = String.join((CharSequence)" ", logPattern);
            String sampleLog = logMessages.get(i);
            logPatternMap.compute(patternKey, (key, stats) -> {
                if (stats == null) {
                    HashMap<String, Object> newStats = new HashMap<String, Object>();
                    newStats.put("pattern", key);
                    newStats.put("pattern_count", 1L);
                    ArrayList<String> samples = new ArrayList<String>();
                    if (sampleLog != null && samples.size() < maxSampleCount) {
                        samples.add(sampleLog);
                    }
                    newStats.put("sample_logs", samples);
                    return newStats;
                }
                stats.put("pattern_count", (Long)stats.get("pattern_count") + 1L);
                List samples = (List)stats.get("sample_logs");
                if (sampleLog != null && samples.size() < maxSampleCount) {
                    samples.add(sampleLog);
                }
                return stats;
            });
        }
        return logPatternMap;
    }

    private Map<Long, Integer> getWordOccurrences(List<String> tokens) {
        HashMap<Long, Integer> occurrences = new HashMap<Long, Integer>();
        for (int i = 0; i < tokens.size() - 1; ++i) {
            String tokenKey = String.format(Locale.ROOT, POSITIONED_TOKEN_KEY_FORMAT, i, tokens.get(i));
            Long tokenFreq = this.tokenFreqMap.get(tokenKey);
            occurrences.compute(tokenFreq, (k, v) -> v == null ? 1 : v + 1);
        }
        return occurrences;
    }

    private WordCombination findCandidate(List<WordCombination> sortedWordCombinations) {
        if (sortedWordCombinations.isEmpty()) {
            throw new IllegalArgumentException("Sorted word combinations must be non empty");
        }
        OptionalLong maxFreqOptional = sortedWordCombinations.stream().mapToLong(WordCombination::wordFreq).max();
        long maxFreq = maxFreqOptional.getAsLong();
        float threshold = (float)maxFreq * this.thresholdPercentage;
        for (WordCombination wordCombination : sortedWordCombinations) {
            if (!((float)wordCombination.wordFreq().longValue() > threshold)) continue;
            return wordCombination;
        }
        return sortedWordCombinations.get(0);
    }

    private void updateGroupTokenFreqMap(List<String> tokens, String groupCandidateStr) {
        int tokensLen = tokens.size() - 1;
        for (int i = 0; i < tokensLen; ++i) {
            String groupTokenFreqKey = String.format(Locale.ROOT, GROUP_TOKEN_SET_KEY_FORMAT, tokensLen, groupCandidateStr, i);
            this.groupTokenSetMap.computeIfAbsent(groupTokenFreqKey, k -> new HashSet()).add(tokens.get(i));
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        BrainLogParser other = (BrainLogParser)obj;
        return Objects.equals(this.variableCountThreshold, other.variableCountThreshold) && Objects.equals(Float.valueOf(this.thresholdPercentage), Float.valueOf(other.thresholdPercentage)) && Objects.equals(this.filterPatternVariableMap, other.filterPatternVariableMap) && Objects.equals(this.delimiters, other.delimiters);
    }

    public int hashCode() {
        return Objects.hash(this.variableCountThreshold, Float.valueOf(this.thresholdPercentage), this.filterPatternVariableMap, this.delimiters);
    }

    @Generated
    public Map<String, Long> getTokenFreqMap() {
        return this.tokenFreqMap;
    }

    @Generated
    public Map<String, Set<String>> getGroupTokenSetMap() {
        return this.groupTokenSetMap;
    }

    @Generated
    public Map<String, String> getLogIdGroupCandidateMap() {
        return this.logIdGroupCandidateMap;
    }

    @Generated
    public int getVariableCountThreshold() {
        return this.variableCountThreshold;
    }

    @Generated
    public float getThresholdPercentage() {
        return this.thresholdPercentage;
    }

    static {
        DEFAULT_FILTER_PATTERN_VARIABLE_MAP.put(Pattern.compile("(/|)([0-9]+\\.){3}[0-9]+(:[0-9]+|)(:|)"), "<*IP*>");
        DEFAULT_FILTER_PATTERN_VARIABLE_MAP.put(Pattern.compile("(\\d{4}-\\d{2}-\\d{2})[T ]?(\\d{2}:\\d{2}:\\d{2})(\\.\\d{3})?(Z|([+-]\\d{2}:?\\d{2}))?"), "<*DATETIME*>");
        DEFAULT_FILTER_PATTERN_VARIABLE_MAP.put(Pattern.compile("((0x|0X)[0-9a-fA-F]+)|[a-zA-Z]+\\d+|([+-]?(?!\\d{3}$)\\d{4,}(\\.\\d*)?|\\.\\d+)"), VARIABLE_DENOTER);
        DEFAULT_FILTER_PATTERN_VARIABLE_MAP.put(Pattern.compile("(?<=[^A-Za-z0-9 ])(-?\\+?\\d+)(?=[^A-Za-z0-9])"), VARIABLE_DENOTER);
        DEFAULT_DELIMITERS = List.of(",", "+");
    }

    private static final class WordCombination
    implements Comparable<WordCombination> {
        private final Long wordFreq;
        private final Integer sameFreqCount;

        public WordCombination(Long wordFreq, Integer sameFreqCount) {
            this.wordFreq = wordFreq;
            this.sameFreqCount = sameFreqCount;
        }

        public Long wordFreq() {
            return this.wordFreq;
        }

        public Integer sameFreqCount() {
            return this.sameFreqCount;
        }

        @Override
        public int compareTo(WordCombination other) {
            int wordFreqComparison = other.sameFreqCount.compareTo(this.sameFreqCount);
            if (wordFreqComparison != 0) {
                return wordFreqComparison;
            }
            return other.wordFreq.compareTo(this.wordFreq);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            WordCombination other = (WordCombination)obj;
            return Objects.equals(this.wordFreq, other.wordFreq) && Objects.equals(this.sameFreqCount, other.sameFreqCount);
        }

        public int hashCode() {
            return Objects.hash(this.wordFreq, this.sameFreqCount);
        }
    }
}

