/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.memory.action.conversation;

import java.io.IOException;
import java.util.List;
import lombok.Generated;
import org.opensearch.core.action.ActionResponse;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.ml.common.conversation.Interaction;

public class GetInteractionsResponse
extends ActionResponse
implements ToXContentObject {
    private List<Interaction> interactions;
    private int nextToken;
    private boolean hasMoreTokens;

    public GetInteractionsResponse(StreamInput in) throws IOException {
        super(in);
        this.interactions = in.readList(Interaction::fromStream);
        this.nextToken = in.readInt();
        this.hasMoreTokens = in.readBoolean();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeList(this.interactions);
        out.writeInt(this.nextToken);
        out.writeBoolean(this.hasMoreTokens);
    }

    public boolean hasMorePages() {
        return this.hasMoreTokens;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startArray("messages");
        for (Interaction inter : this.interactions) {
            inter.toXContent(builder, params);
        }
        builder.endArray();
        if (this.hasMoreTokens) {
            builder.field("next_token", this.nextToken);
        }
        builder.endObject();
        return builder;
    }

    @Generated
    public GetInteractionsResponse(List<Interaction> interactions, int nextToken, boolean hasMoreTokens) {
        this.interactions = interactions;
        this.nextToken = nextToken;
        this.hasMoreTokens = hasMoreTokens;
    }

    @Generated
    public List<Interaction> getInteractions() {
        return this.interactions;
    }

    @Generated
    public int getNextToken() {
        return this.nextToken;
    }
}

