/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.searchrelevance.judgments;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.StepListener;
import org.opensearch.common.inject.Inject;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.searchrelevance.exception.SearchRelevanceException;
import org.opensearch.searchrelevance.judgments.BaseJudgmentsProcessor;
import org.opensearch.searchrelevance.judgments.clickmodel.coec.CoecClickModel;
import org.opensearch.searchrelevance.judgments.clickmodel.coec.CoecClickModelParameters;
import org.opensearch.searchrelevance.model.JudgmentType;
import org.opensearch.searchrelevance.stats.events.EventStatName;
import org.opensearch.searchrelevance.stats.events.EventStatsManager;
import org.opensearch.transport.client.Client;

public class UbiJudgmentsProcessor
implements BaseJudgmentsProcessor {
    private static final Logger LOGGER = LogManager.getLogger(UbiJudgmentsProcessor.class);
    private final Client client;

    @Inject
    public UbiJudgmentsProcessor(Client client) {
        this.client = client;
    }

    @Override
    public JudgmentType getJudgmentType() {
        return JudgmentType.UBI_JUDGMENT;
    }

    @Override
    public void generateJudgmentRating(Map<String, Object> metadata, final ActionListener<List<Map<String, Object>>> listener) {
        EventStatsManager.increment(EventStatName.UBI_JUDGMENT_RATING_GENERATIONS);
        String clickModel = (String)metadata.get("clickModel");
        int maxRank = (Integer)metadata.get("maxRank");
        String startDate = (String)metadata.get("startDate");
        String endDate = (String)metadata.get("endDate");
        if ("coec".equalsIgnoreCase(clickModel)) {
            CoecClickModelParameters coecClickModelParameters = new CoecClickModelParameters(maxRank, startDate, endDate);
            CoecClickModel coecClickModel = new CoecClickModel(this.client, coecClickModelParameters);
            StepListener clickModelStep = new StepListener();
            try {
                coecClickModel.calculateJudgments(new ActionListener<List<Map<String, Object>>>(this){

                    public void onResponse(List<Map<String, Object>> judgments) {
                        ArrayList formattedRatings = new ArrayList();
                        for (Map<String, Object> queryJudgment : judgments) {
                            String queryText = (String)queryJudgment.get("query");
                            Object ratingData = queryJudgment.get("ratings");
                            if (!(ratingData instanceof Map)) {
                                listener.onFailure((Exception)((Object)new SearchRelevanceException("queryText " + queryText + " must have rating data as a Map.", RestStatus.BAD_REQUEST)));
                                return;
                            }
                            Map ratingsMap = (Map)ratingData;
                            ArrayList docIdScoreList = new ArrayList();
                            for (Map.Entry entry : ratingsMap.entrySet()) {
                                String docId = (String)entry.getKey();
                                Object ratingObject = entry.getValue();
                                if (docId == null || docId.isEmpty()) {
                                    listener.onFailure((Exception)((Object)new SearchRelevanceException("docId (map key) for queryText " + queryText + " must not be null or empty", RestStatus.BAD_REQUEST)));
                                    return;
                                }
                                if (ratingObject == null) {
                                    listener.onFailure((Exception)((Object)new SearchRelevanceException("rating for docId '" + docId + "' in queryText " + queryText + " must not be null", RestStatus.BAD_REQUEST)));
                                    return;
                                }
                                String rating = String.valueOf(ratingObject);
                                try {
                                    Float.parseFloat(rating);
                                }
                                catch (NumberFormatException e) {
                                    listener.onFailure((Exception)((Object)new SearchRelevanceException("rating '" + rating + "' for docId '" + docId + "' in queryText " + queryText + " must be a valid float", RestStatus.BAD_REQUEST)));
                                    return;
                                }
                                HashMap<String, String> docScoreMap = new HashMap<String, String>();
                                docScoreMap.put("docId", docId);
                                docScoreMap.put("rating", rating);
                                docIdScoreList.add(docScoreMap);
                            }
                            HashMap<String, Object> queryRatings = new HashMap<String, Object>();
                            queryRatings.put("query", queryText);
                            queryRatings.put("ratings", docIdScoreList);
                            formattedRatings.add(queryRatings);
                        }
                        listener.onResponse(formattedRatings);
                    }

                    public void onFailure(Exception e) {
                        LOGGER.error("Failed to calculate COEC click model judgments", (Throwable)e);
                        listener.onFailure((Exception)((Object)new SearchRelevanceException(e.getLocalizedMessage(), e, RestStatus.INTERNAL_SERVER_ERROR)));
                    }
                });
            }
            catch (Exception e) {
                LOGGER.error("Error initiating COEC click model calculation", (Throwable)e);
                listener.onFailure((Exception)((Object)new SearchRelevanceException("Error initiating COEC click model calculation", e, RestStatus.INTERNAL_SERVER_ERROR)));
            }
        } else {
            listener.onFailure((Exception)((Object)new SearchRelevanceException("Unsupported click model: " + clickModel, RestStatus.BAD_REQUEST)));
        }
    }
}

