/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.searchrelevance.rest;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.ExceptionsHelper;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.index.IndexResponse;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestResponse;
import org.opensearch.searchrelevance.settings.SearchRelevanceSettingsAccessor;
import org.opensearch.searchrelevance.transport.queryset.PostQuerySetAction;
import org.opensearch.searchrelevance.transport.queryset.PostQuerySetRequest;
import org.opensearch.searchrelevance.utils.TextValidationUtil;
import org.opensearch.transport.client.node.NodeClient;

public class RestCreateQuerySetAction
extends BaseRestHandler {
    private static final Logger LOGGER = LogManager.getLogger(RestCreateQuerySetAction.class);
    private static final String CREATE_QUERYSET_ACTION = "create_queryset_action";
    private SearchRelevanceSettingsAccessor settingsAccessor;

    public String getName() {
        return CREATE_QUERYSET_ACTION;
    }

    public List<RestHandler.Route> routes() {
        return Collections.singletonList(new RestHandler.Route(RestRequest.Method.POST, "/_plugins/_search_relevance/query_sets"));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        TextValidationUtil.ValidationResult descriptionValidation;
        if (!this.settingsAccessor.isWorkbenchEnabled()) {
            return channel -> channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.FORBIDDEN, "Search Relevance Workbench is disabled"));
        }
        XContentParser parser = request.contentParser();
        Map source = parser.map();
        String name = (String)source.get("name");
        TextValidationUtil.ValidationResult nameValidation = TextValidationUtil.validateText(name);
        if (!nameValidation.isValid()) {
            return channel -> channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.BAD_REQUEST, "Invalid name: " + nameValidation.getErrorMessage()));
        }
        String description = (String)source.get("description");
        if (description != null && !(descriptionValidation = TextValidationUtil.validateText(description)).isValid()) {
            return channel -> channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.BAD_REQUEST, "Invalid description: " + descriptionValidation.getErrorMessage()));
        }
        String sampling = source.getOrDefault("sampling", "pptss");
        int querySetSize = source.getOrDefault("querySetSize", 10);
        if (querySetSize > this.settingsAccessor.getMaxQuerySetAllowed()) {
            return channel -> channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.FORBIDDEN, "Query Set Limit Exceeded."));
        }
        PostQuerySetRequest createRequest = new PostQuerySetRequest(name, description, sampling, querySetSize);
        return channel -> client.execute((ActionType)PostQuerySetAction.INSTANCE, (ActionRequest)createRequest, (ActionListener)new ActionListener<IndexResponse>(){

            public void onResponse(IndexResponse response) {
                try {
                    XContentBuilder builder = channel.newBuilder();
                    builder.startObject();
                    builder.field("query_set_id", response.getId());
                    builder.field("query_set_result", (Object)response.getResult());
                    builder.endObject();
                    channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.OK, builder));
                }
                catch (IOException e) {
                    this.onFailure(e);
                }
            }

            public void onFailure(Exception e) {
                try {
                    channel.sendResponse((RestResponse)new BytesRestResponse(channel, ExceptionsHelper.status((Throwable)e), e));
                }
                catch (IOException ex) {
                    LOGGER.error("Failed to send error response", (Throwable)ex);
                }
            }
        });
    }

    @Generated
    public RestCreateQuerySetAction(SearchRelevanceSettingsAccessor settingsAccessor) {
        this.settingsAccessor = settingsAccessor;
    }
}

