/*
 * Decompiled with CFR 0.152.
 */
package com.o19s.es.ltr.rest;

import com.o19s.es.ltr.action.CreateModelFromSetAction;
import com.o19s.es.ltr.feature.FeatureValidation;
import com.o19s.es.ltr.feature.store.StoredLtrModel;
import com.o19s.es.ltr.rest.FeatureStoreBaseRestHandler;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.opensearch.ExceptionsHelper;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.core.ParseField;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.ParsingException;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.ObjectParser;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.index.engine.VersionConflictEngineException;
import org.opensearch.ltr.settings.LTRSettings;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestResponse;
import org.opensearch.rest.action.RestStatusToXContentListener;
import org.opensearch.transport.client.OpenSearchClient;
import org.opensearch.transport.client.node.NodeClient;

public class RestCreateModelFromSet
extends FeatureStoreBaseRestHandler {
    public String getName() {
        return "Create initial models for features";
    }

    public List<RestHandler.Route> routes() {
        return Collections.unmodifiableList(Arrays.asList(new RestHandler.Route(RestRequest.Method.POST, "/_ltr/{store}/_featureset/{name}/_createmodel"), new RestHandler.Route(RestRequest.Method.POST, "/_ltr/_featureset/{name}/_createmodel")));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        if (!LTRSettings.isLTRPluginEnabled()) {
            throw new IllegalStateException("LTR plugin is disabled. To enable, update ltr.plugin.enabled to true");
        }
        String store = this.indexName(request);
        Long expectedVersion = null;
        if (request.hasParam("version") && (expectedVersion = Long.valueOf(request.paramAsLong("version", -1L))) <= 0L) {
            throw new IllegalArgumentException("version must be a strictly positive long value");
        }
        String routing = request.param("routing");
        ParserState state = new ParserState();
        request.withContentOrSourceParamParserOrNull(p -> ParserState.parse(p, state));
        CreateModelFromSetAction.CreateModelFromSetRequestBuilder builder = new CreateModelFromSetAction.CreateModelFromSetRequestBuilder((OpenSearchClient)client);
        if (expectedVersion != null) {
            builder.withVersion(store, request.param("name"), expectedVersion, state.model.name, state.model.model);
        } else {
            builder.withoutVersion(store, request.param("name"), state.model.name, state.model.model);
        }
        ((CreateModelFromSetAction.CreateModelFromSetRequest)builder.request()).setValidation(state.validation);
        builder.routing(routing);
        return channel -> {
            try (ThreadContext.StoredContext threadContext = client.threadPool().getThreadContext().stashContext();){
                ActionListener wrappedListener = ActionListener.wrap(response -> new RestStatusToXContentListener(channel, r -> r.getResponse().getLocation(routing)).onResponse((Object)response), e -> {
                    RestStatus status;
                    Exception exc;
                    if (ExceptionsHelper.unwrap((Throwable)e, (Class[])new Class[]{VersionConflictEngineException.class}) != null) {
                        exc = new IllegalArgumentException("Element of type [model] are not updatable, please create a new one instead.");
                        exc.addSuppressed((Throwable)e);
                        status = RestStatus.METHOD_NOT_ALLOWED;
                    } else {
                        exc = e;
                        status = ExceptionsHelper.status((Throwable)exc);
                    }
                    try {
                        channel.sendResponse((RestResponse)new BytesRestResponse(channel, status, exc));
                    }
                    catch (Exception inner) {
                        inner.addSuppressed((Throwable)e);
                        this.logger.error("failed to send failure response", (Throwable)inner);
                    }
                });
                ActionListener contextRestoringListener = ActionListener.runBefore((ActionListener)wrappedListener, () -> threadContext.restore());
                builder.execute(contextRestoringListener);
            }
            catch (Exception e2) {
                channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.INTERNAL_SERVER_ERROR, e2.getMessage()));
            }
        };
    }

    private static class ParserState {
        private static final ObjectParser<ParserState, Void> PARSER = new ObjectParser("create_model_from_set", ParserState::new);
        private Model model;
        private FeatureValidation validation;

        private ParserState() {
        }

        public Model getModel() {
            return this.model;
        }

        public void setModel(Model model) {
            this.model = model;
        }

        public FeatureValidation getValidation() {
            return this.validation;
        }

        public void setValidation(FeatureValidation validation) {
            this.validation = validation;
        }

        public static void parse(XContentParser parser, ParserState value) throws IOException {
            PARSER.parse(parser, (Object)value, null);
            if (value.model == null) {
                throw new ParsingException(parser.getTokenLocation(), "Missing required value [model]", new Object[0]);
            }
        }

        static {
            PARSER.declareObject(ParserState::setModel, (arg_0, arg_1) -> Model.MODEL_PARSER.apply(arg_0, arg_1), new ParseField("model", new String[0]));
            PARSER.declareObject(ParserState::setValidation, (arg_0, arg_1) -> FeatureValidation.PARSER.apply(arg_0, arg_1), new ParseField("validation", new String[0]));
        }

        private static class Model {
            private static final ObjectParser<Model, Void> MODEL_PARSER = new ObjectParser("model", Model::new);
            String name;
            StoredLtrModel.LtrModelDefinition model;

            private Model() {
            }

            public void setName(String name) {
                this.name = name;
            }

            public void setModel(StoredLtrModel.LtrModelDefinition model) {
                this.model = model;
            }

            public static void parse(XContentParser parser, Model value) throws IOException {
                MODEL_PARSER.parse(parser, (Object)value, null);
                if (value.name == null) {
                    throw new ParsingException(parser.getTokenLocation(), "Missing required value [name]", new Object[0]);
                }
            }

            static {
                MODEL_PARSER.declareString(Model::setName, new ParseField("name", new String[0]));
                MODEL_PARSER.declareObject(Model::setModel, StoredLtrModel.LtrModelDefinition::parse, new ParseField("model", new String[0]));
            }
        }
    }
}

