/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel.colopedia;

import java.awt.Component;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.tree.DefaultMutableTreeNode;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.ModifierFormat;
import net.sf.freecol.client.gui.action.ColopediaAction;
import net.sf.freecol.client.gui.panel.Utility;
import net.sf.freecol.client.gui.panel.colopedia.ColopediaGameObjectTypePanel;
import net.sf.freecol.client.gui.panel.colopedia.ColopediaPanel;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.ResourceType;
import net.sf.freecol.common.model.Scope;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.util.CollectionUtils;

public class ResourcesDetailPanel
extends ColopediaGameObjectTypePanel<ResourceType> {
    public ResourcesDetailPanel(FreeColClient freeColClient, ColopediaPanel colopediaPanel) {
        super(freeColClient, colopediaPanel, ColopediaAction.PanelType.RESOURCES.getKey());
    }

    @Override
    public void addSubTrees(DefaultMutableTreeNode root) {
        super.addSubTrees(root, this.getSpecification().getResourceTypeList());
    }

    @Override
    public void buildDetail(String id, JPanel panel) {
        if (this.getId().equals(id)) {
            return;
        }
        Specification spec = this.getSpecification();
        ResourceType type = spec.getResourceType(id);
        panel.setLayout(new MigLayout("wrap 2", "[]20[]"));
        JLabel name = Utility.localizedHeaderLabel(type, Utility.FONTSPEC_SUBTITLE);
        panel.add((Component)name, "span, align center, wrap 40");
        panel.add(Utility.localizedLabel("colopedia.resource.bonusProduction"));
        JPanel goodsPanel = new JPanel();
        goodsPanel.setOpaque(false);
        List<Modifier> mods = CollectionUtils.sort(type.getModifiers(), Modifier.ascendingModifierIndexComparator);
        for (Modifier modifier : mods) {
            String scopes;
            Object text = ModifierFormat.getModifierAsString(modifier);
            if (modifier.hasScope() && !(scopes = CollectionUtils.transform(modifier.getScopes(), CollectionUtils.isNotNull(Scope::getType), s -> Messages.getName(spec.getType(s.getType())), Collectors.joining(", "))).isEmpty()) {
                text = (String)text + " (" + scopes + ")";
            }
            GoodsType goodsType = spec.getGoodsType(modifier.getId());
            JButton goodsButton = this.getGoodsButton(goodsType, (String)text);
            goodsPanel.add(goodsButton);
        }
        panel.add(goodsPanel);
        panel.add((Component)Utility.localizedLabel("colopedia.resource.description"), "newline 20");
        panel.add((Component)Utility.localizedTextArea(Messages.descriptionKey(type), 30), "growx");
    }
}

