/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.Collection;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Scope;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.common.util.Utils;

public class Operand
extends Scope {
    private static final Logger logger = Logger.getLogger(Operand.class.getName());
    private OperandType operandType = OperandType.NONE;
    private ScopeLevel scopeLevel = ScopeLevel.NONE;
    private Integer value = null;
    private static final String OPERAND_TYPE_TAG = "operand-type";
    private static final String SCOPE_LEVEL_TAG = "scope-level";
    private static final String OLD_OPERAND_TYPE_TAG = "operandType";
    private static final String OLD_SCOPE_LEVEL_TAG = "scopeLevel";

    public Operand() {
    }

    public Operand(int value) {
        this.value = value;
    }

    public Operand(OperandType operandType, ScopeLevel scopeLevel) {
        this.operandType = operandType;
        this.scopeLevel = scopeLevel;
    }

    protected Operand(FreeColXMLReader xr) throws XMLStreamException {
        this.readFromXML(xr);
    }

    public final OperandType getOperandType() {
        return this.operandType;
    }

    public final void setOperandType(OperandType newOperandType) {
        this.operandType = newOperandType;
    }

    public final ScopeLevel getScopeLevel() {
        return this.scopeLevel;
    }

    public final void setScopeLevel(ScopeLevel newScopeLevel) {
        this.scopeLevel = newScopeLevel;
    }

    public final Integer getValue() {
        return this.value;
    }

    public final void setValue(Integer newValue) {
        this.value = newValue;
    }

    private Integer ourCount(Collection<? extends FreeColObject> objects) {
        return CollectionUtils.count(objects, o -> this.appliesTo((FreeColObject)o));
    }

    public Integer getValue(Game game) {
        if (this.value != null) {
            return this.value;
        }
        if (this.scopeLevel != ScopeLevel.GAME) {
            return null;
        }
        String methodName = this.getMethodName();
        int result = 0;
        switch (this.operandType) {
            case NONE: {
                result = game.invokeMethod(methodName, Integer.class, 0);
                break;
            }
            case YEAR: {
                result = game.getTurn().getYear();
                break;
            }
            case OPTION: {
                result = game.getSpecification().getInteger(this.getType());
                break;
            }
            default: {
                block11: for (Player player : game.getLivePlayerList(new Player[0])) {
                    switch (this.operandType) {
                        case UNITS: {
                            result += this.ourCount(player.getUnitSet()).intValue();
                            continue block11;
                        }
                        case BUILDINGS: {
                            result += CollectionUtils.sum(player.getColonies(), c -> this.ourCount(c.getBuildings()));
                            continue block11;
                        }
                        case SETTLEMENTS: {
                            result += this.ourCount(player.getSettlementList()).intValue();
                            continue block11;
                        }
                        case FOUNDING_FATHERS: {
                            result += this.ourCount(player.getFoundingFathers()).intValue();
                            continue block11;
                        }
                    }
                    return null;
                }
            }
        }
        return result;
    }

    public Integer getValue(Player player) {
        if (this.value != null) {
            return this.value;
        }
        switch (this.scopeLevel) {
            case GAME: {
                return this.getValue(player.getGame());
            }
            case PLAYER: {
                break;
            }
            default: {
                return null;
            }
        }
        Specification spec = player.getSpecification();
        String methodName = this.getMethodName();
        switch (this.operandType) {
            case UNITS: {
                return this.ourCount(player.getUnitSet());
            }
            case BUILDINGS: {
                return CollectionUtils.sum(player.getColonies(), c -> this.ourCount(c.getBuildings()));
            }
            case SETTLEMENTS: {
                if (methodName == null) {
                    return this.ourCount(player.getSettlementList()) + spec.getInteger("model.option.settlementLimitModifier");
                }
                String methodValue = this.getMethodValue();
                return CollectionUtils.count(player.getSettlementList(), s -> String.valueOf(s.invokeMethod(methodName, Boolean.class, Boolean.FALSE)).equals(methodValue));
            }
            case FOUNDING_FATHERS: {
                return this.ourCount(player.getFoundingFathers());
            }
        }
        return player.invokeMethod(methodName, Integer.class, null);
    }

    public Integer getValue(Settlement settlement) {
        if (this.value != null) {
            return this.value;
        }
        if (this.scopeLevel != ScopeLevel.SETTLEMENT || !(settlement instanceof Colony)) {
            return null;
        }
        Colony colony = (Colony)settlement;
        switch (this.operandType) {
            case UNITS: {
                return this.ourCount(colony.getUnitList());
            }
            case BUILDINGS: {
                return this.ourCount(colony.getBuildings());
            }
        }
        return colony.invokeMethod(this.getMethodName(), Integer.class, null);
    }

    @Override
    public <T extends FreeColObject> boolean copyIn(T other) {
        Operand o = this.copyInCast(other, Operand.class);
        if (o == null || !super.copyIn(o)) {
            return false;
        }
        this.operandType = o.getOperandType();
        this.scopeLevel = o.getScopeLevel();
        this.value = o.getValue();
        return true;
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        xw.writeAttribute(OPERAND_TYPE_TAG, this.operandType);
        xw.writeAttribute(SCOPE_LEVEL_TAG, this.scopeLevel);
        if (this.value != null) {
            xw.writeAttribute("value", this.value);
        }
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        this.operandType = xr.hasAttribute(OLD_OPERAND_TYPE_TAG) ? xr.getAttribute(OLD_OPERAND_TYPE_TAG, OperandType.class, OperandType.NONE) : xr.getAttribute(OPERAND_TYPE_TAG, OperandType.class, OperandType.NONE);
        this.scopeLevel = xr.hasAttribute(OLD_SCOPE_LEVEL_TAG) ? xr.getAttribute(OLD_SCOPE_LEVEL_TAG, ScopeLevel.class, ScopeLevel.NONE) : xr.getAttribute(SCOPE_LEVEL_TAG, ScopeLevel.class, ScopeLevel.NONE);
        int val = xr.getAttribute("value", Integer.MAX_VALUE);
        if (val != Integer.MAX_VALUE) {
            this.value = val;
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof Operand) {
            Operand other = (Operand)o;
            return this.operandType == other.operandType && this.scopeLevel == other.scopeLevel && Utils.equals(this.value, other.value) && super.equals(other);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = 31 * hash + this.operandType.ordinal();
        hash = 31 * hash + this.scopeLevel.ordinal();
        hash = 31 * hash + this.value;
        return hash;
    }

    @Override
    public String toString() {
        if (this.value != null) {
            return Integer.toString(this.value);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("[Operand type=").append((Object)this.operandType).append(" scopeLevel=").append((Object)this.scopeLevel);
        return super.toString().replaceFirst("^[^ ]*", sb.toString());
    }

    public static enum ScopeLevel {
        SETTLEMENT,
        PLAYER,
        GAME,
        NONE;

    }

    public static enum OperandType {
        UNITS,
        BUILDINGS,
        SETTLEMENTS,
        FOUNDING_FATHERS,
        YEAR,
        OPTION,
        NONE;

    }
}

