/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.temp;

import java.io.File;
import java.io.IOException;
import javax.annotation.Nullable;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.internal.file.temp.TempFiles;
import org.gradle.api.internal.file.temp.TemporaryFileProvider;
import org.gradle.internal.Factory;

public class DefaultTemporaryFileProvider
implements TemporaryFileProvider {
    private final Factory<File> baseDirFactory;

    public DefaultTemporaryFileProvider(Factory<File> fileFactory) {
        this.baseDirFactory = fileFactory;
    }

    @Override
    public File newTemporaryFile(String ... path) {
        StringBuilder pathBuilder = new StringBuilder();
        for (int i = 0; i < path.length; ++i) {
            if (i > 0) {
                pathBuilder.append("/");
            }
            pathBuilder.append(path[i]);
        }
        return new File((File)this.baseDirFactory.create(), pathBuilder.toString()).toPath().normalize().toFile();
    }

    @Override
    public File newTemporaryDirectory(String ... path) {
        File dir = this.newTemporaryFile(path);
        DefaultTemporaryFileProvider.forceMkdir(dir);
        return dir;
    }

    @Override
    public Factory<File> temporaryDirectoryFactory(final String ... path) {
        return new Factory<File>(){

            @Nullable
            public File create() {
                return DefaultTemporaryFileProvider.this.newTemporaryDirectory(path);
            }
        };
    }

    @Override
    public File createTemporaryFile(String prefix, @Nullable String suffix, String ... path) {
        File dir = this.newTemporaryFile(path);
        DefaultTemporaryFileProvider.forceMkdir(dir);
        try {
            return TempFiles.createTempFile(prefix, suffix, dir);
        }
        catch (IOException e) {
            throw new UncheckedIOException((Throwable)e);
        }
    }

    @Override
    public File createTemporaryDirectory(String prefix, @Nullable String suffix, String ... path) {
        File dir = this.newTemporaryFile(path);
        DefaultTemporaryFileProvider.forceMkdir(dir);
        try {
            File tmpDir = TempFiles.createTempFile(prefix, suffix, dir);
            if (!tmpDir.delete()) {
                throw new IOException("Failed to delete file: " + tmpDir);
            }
            if (!tmpDir.mkdir()) {
                throw new IOException("Failed to make directory: " + tmpDir);
            }
            return tmpDir;
        }
        catch (IOException e) {
            throw new UncheckedIOException((Throwable)e);
        }
    }

    private static File forceMkdir(File directory) {
        if (!directory.mkdirs() && !directory.isDirectory()) {
            throw new UncheckedIOException("Cannot create directory '" + directory + "'.");
        }
        return directory;
    }
}

