/*
 * Decompiled with CFR 0.152.
 */
package org.jxmpp.xml.splitter;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.jxmpp.xml.splitter.DeclarationCallback;
import org.jxmpp.xml.splitter.ProcessingInstructionCallback;
import org.jxmpp.xml.splitter.XmlPrinter;
import org.jxmpp.xml.splitter.XmlSplitter;
import org.jxmpp.xml.splitter.XmppElementCallback;

public class XmppXmlSplitter
extends XmlSplitter {
    private final XmppElementCallback xmppElementCallback;
    private final int maxElementSize;
    private String streamPrefix;

    public XmppXmlSplitter(XmppElementCallback xmppElementCallback) {
        this(10000, xmppElementCallback);
    }

    public XmppXmlSplitter(XmppElementCallback xmppElementCallback, DeclarationCallback declarationCallback, ProcessingInstructionCallback processingInstructionCallback) {
        this(10000, xmppElementCallback, declarationCallback, processingInstructionCallback);
    }

    public XmppXmlSplitter(int maxElementSize, XmppElementCallback xmppElementCallback) {
        this(maxElementSize, xmppElementCallback, null, null);
    }

    public XmppXmlSplitter(int maxElementSize, XmppElementCallback xmppElementCallback, DeclarationCallback declarationCallback, ProcessingInstructionCallback processingInstructionCallback) {
        this(maxElementSize, xmppElementCallback, declarationCallback, processingInstructionCallback, null);
    }

    public XmppXmlSplitter(XmlPrinter xmlPrinter) {
        this(-1, null, xmlPrinter);
    }

    public XmppXmlSplitter(int maxElementSize, XmppElementCallback xmppElementCallback, XmlPrinter xmlPrinter) {
        this(maxElementSize, xmppElementCallback, null, null, xmlPrinter);
    }

    public XmppXmlSplitter(int maxElementSize, XmppElementCallback xmppElementCallback, DeclarationCallback declarationCallback, ProcessingInstructionCallback processingInstructionCallback, XmlPrinter xmlPrinter) {
        super(maxElementSize, xmppElementCallback, declarationCallback, processingInstructionCallback, xmlPrinter);
        this.maxElementSize = maxElementSize;
        this.xmppElementCallback = xmppElementCallback;
    }

    @Override
    protected void onNextChar() throws IOException {
        if (this.maxElementSize > 0 && this.getCurrentSplittedPartSize() >= this.maxElementSize) {
            throw new IOException("Max element size exceeded");
        }
    }

    @Override
    protected void onStartTag(String prefix, String localpart, Map<String, String> attributes) {
        if (!"stream".equals(localpart)) {
            return;
        }
        if ("http://etherx.jabber.org/streams".equals(attributes.get("xmlns:" + prefix))) {
            this.streamPrefix = prefix;
            this.newSplittedPart();
            if (this.xmppElementCallback != null) {
                this.xmppElementCallback.streamOpened(prefix, Collections.unmodifiableMap(attributes));
            }
        }
    }

    @Override
    protected void onEndTag(String qName) {
        if (this.streamPrefix == null || !qName.startsWith(this.streamPrefix)) {
            return;
        }
        if ((this.streamPrefix + ":stream").equals(qName) && this.xmppElementCallback != null) {
            this.xmppElementCallback.streamClosed();
        }
    }
}

