/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.util.List;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.LocationProvider;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.expr.Container;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.style.AbsentExtensionElement;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.DataElement;
import net.sf.saxon.style.LiteralResultElement;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.StylesheetPackage;
import net.sf.saxon.style.XSLAnalyzeString;
import net.sf.saxon.style.XSLApplyImports;
import net.sf.saxon.style.XSLApplyTemplates;
import net.sf.saxon.style.XSLAttribute;
import net.sf.saxon.style.XSLAttributeSet;
import net.sf.saxon.style.XSLCallTemplate;
import net.sf.saxon.style.XSLCharacterMap;
import net.sf.saxon.style.XSLChoose;
import net.sf.saxon.style.XSLComment;
import net.sf.saxon.style.XSLCopy;
import net.sf.saxon.style.XSLCopyOf;
import net.sf.saxon.style.XSLDecimalFormat;
import net.sf.saxon.style.XSLDocument;
import net.sf.saxon.style.XSLElement;
import net.sf.saxon.style.XSLFallback;
import net.sf.saxon.style.XSLForEach;
import net.sf.saxon.style.XSLForEachGroup;
import net.sf.saxon.style.XSLFunction;
import net.sf.saxon.style.XSLGlobalParam;
import net.sf.saxon.style.XSLGlobalVariable;
import net.sf.saxon.style.XSLIf;
import net.sf.saxon.style.XSLImport;
import net.sf.saxon.style.XSLImportSchema;
import net.sf.saxon.style.XSLInclude;
import net.sf.saxon.style.XSLKey;
import net.sf.saxon.style.XSLLocalParam;
import net.sf.saxon.style.XSLLocalVariable;
import net.sf.saxon.style.XSLMatchingSubstring;
import net.sf.saxon.style.XSLMessage;
import net.sf.saxon.style.XSLModuleRoot;
import net.sf.saxon.style.XSLNamespace;
import net.sf.saxon.style.XSLNamespaceAlias;
import net.sf.saxon.style.XSLNextMatch;
import net.sf.saxon.style.XSLNumber;
import net.sf.saxon.style.XSLOtherwise;
import net.sf.saxon.style.XSLOutput;
import net.sf.saxon.style.XSLOutputCharacter;
import net.sf.saxon.style.XSLPackage;
import net.sf.saxon.style.XSLPerformSort;
import net.sf.saxon.style.XSLPreserveSpace;
import net.sf.saxon.style.XSLProcessingInstruction;
import net.sf.saxon.style.XSLResultDocument;
import net.sf.saxon.style.XSLSequence;
import net.sf.saxon.style.XSLSort;
import net.sf.saxon.style.XSLStylesheet;
import net.sf.saxon.style.XSLTemplate;
import net.sf.saxon.style.XSLText;
import net.sf.saxon.style.XSLValueOf;
import net.sf.saxon.style.XSLWhen;
import net.sf.saxon.style.XSLWithParam;
import net.sf.saxon.trans.IAccumulatorManager;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.linked.ElementImpl;
import net.sf.saxon.tree.linked.NodeFactory;
import net.sf.saxon.tree.linked.TextImpl;
import net.sf.saxon.tree.util.AttributeCollectionImpl;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.value.DecimalValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StyleNodeFactory
implements NodeFactory {
    protected Configuration config;
    protected NamePool namePool;
    private Compilation compilation;
    private boolean topLevelModule;

    public StyleNodeFactory(Configuration config, Compilation compilation) {
        this.config = config;
        this.compilation = compilation;
        this.namePool = config.getNamePool();
    }

    public void setTopLevelModule(boolean topLevelModule) {
        this.topLevelModule = topLevelModule;
    }

    public boolean isTopLevelModule() {
        return this.topLevelModule;
    }

    public Compilation getCompilation() {
        return this.compilation;
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public void setXsltProcessorVersion(DecimalValue version) {
    }

    public DecimalValue getXsltProcessorVersion() {
        return this.compilation.getVersion();
    }

    @Override
    public ElementImpl makeElementNode(NodeInfo parent, NodeName elemName, SchemaType elemType, boolean isNilled, AttributeCollectionImpl attlist, NamespaceBinding[] namespaces, int namespacesUsed, PipelineConfiguration pipe, int locationId, int sequence) {
        StyleElement node;
        Class actualClass;
        int nameCode = elemName.allocateNameCode(pipe.getConfiguration().getNamePool());
        boolean toplevel = parent instanceof XSLModuleRoot;
        String baseURI = null;
        int lineNumber = -1;
        int columnNumber = -1;
        LocationProvider locator = pipe.getLocationProvider();
        if (locator != null) {
            baseURI = locator.getSystemId(locationId);
            lineNumber = locator.getLineNumber(locationId);
            columnNumber = locator.getColumnNumber(locationId);
        }
        if (parent instanceof DataElement) {
            DataElement d = new DataElement();
            d.setNamespaceDeclarations(namespaces, namespacesUsed);
            d.initialise(elemName, elemType, attlist, parent, sequence);
            d.setLocation(baseURI, lineNumber, columnNumber);
            return d;
        }
        int f = nameCode & 0xFFFFF;
        StyleElement e = this.makeXSLElement(f, parent);
        if ((e instanceof XSLStylesheet || e instanceof XSLPackage) && parent.getNodeKind() != 9) {
            e = new AbsentExtensionElement();
            XPathException reason = new XPathException(elemName.getDisplayName() + " can only appear at the outermost level", "XTSE0010");
            e.setValidationError(reason, 1);
        }
        if (e != null) {
            e.setCompilation(this.compilation);
            e.setNamespaceDeclarations(namespaces, namespacesUsed);
            e.initialise(elemName, elemType, attlist, parent, sequence);
            e.setLocation(baseURI, lineNumber, columnNumber);
            try {
                e.processExtensionElementAttribute("");
            }
            catch (TransformerException err) {
                e.setValidationError(err, 1);
            }
            try {
                e.processExcludedNamespaces("");
            }
            catch (TransformerException err) {
                e.setValidationError(err, 1);
            }
            try {
                e.processVersionAttribute("");
            }
            catch (TransformerException err) {
                e.setValidationError(err, 1);
            }
            e.processDefaultXPathNamespaceAttribute("");
            try {
                e.processExpandTextAttribute("");
            }
            catch (XPathException err) {
                e.setValidationError(err, 1);
            }
            if (e instanceof XSLModuleRoot && this.compilation.getVersion().compareTo(DecimalValue.ZERO) == 0) {
                DecimalValue effectiveVersion = e.getEffectiveVersion();
                this.compilation.setVersion(effectiveVersion.equals(DecimalValue.THREE) ? DecimalValue.THREE : DecimalValue.TWO);
            }
            return e;
        }
        short uriCode = this.namePool.getURICode(nameCode);
        String uri = this.namePool.getURI(nameCode);
        if (toplevel && uriCode != 0 && uriCode != 2) {
            DataElement d = new DataElement();
            d.setNamespaceDeclarations(namespaces, namespacesUsed);
            d.initialise(elemName, elemType, attlist, parent, sequence);
            d.setLocation(baseURI, lineNumber, columnNumber);
            return d;
        }
        String localname = this.namePool.getLocalName(nameCode);
        StyleElement temp = null;
        if (uri.equals("http://www.w3.org/1999/XSL/Transform")) {
            if (parent instanceof XSLStylesheet) {
                if (((XSLStylesheet)parent).getEffectiveVersion().compareTo(DecimalValue.TWO) <= 0) {
                    temp = new AbsentExtensionElement();
                    temp.setValidationError(new XPathException("Unknown top-level XSLT declaration"), 2);
                }
            } else {
                temp = new AbsentExtensionElement();
                temp.initialise(elemName, elemType, attlist, parent, sequence);
                temp.setLocation(baseURI, lineNumber, columnNumber);
                try {
                    temp.processStandardAttributes("");
                    if (temp.getEffectiveVersion().compareTo(DecimalValue.TWO) > 0) {
                        temp.setValidationError(new XPathException("Unknown XSLT instruction"), 4);
                    } else {
                        temp.setValidationError(new XPathException("Unknown XSLT instruction"), 3);
                    }
                }
                catch (XPathException err) {
                    temp.setValidationError(err, 1);
                }
            }
        }
        if (uri.equals("http://saxon.sf.net/")) {
            XPathException te = new XPathException(this.namePool.getDisplayName(nameCode) + " is not recognized as a Saxon instruction");
            te.setLocator(pipe.getSourceLocation(locationId));
            te.setErrorCode("SXWN9008");
            pipe.getErrorListener().warning(te);
        }
        Class<LiteralResultElement> assumedClass = LiteralResultElement.class;
        if (temp == null) {
            temp = new LiteralResultElement();
        }
        temp.setNamespaceDeclarations(namespaces, namespacesUsed);
        try {
            temp.setCompilation(this.compilation);
            temp.initialise(elemName, elemType, attlist, parent, sequence);
            temp.setLocation(baseURI, lineNumber, columnNumber);
            temp.processStandardAttributes("http://www.w3.org/1999/XSL/Transform");
        }
        catch (XPathException err) {
            temp.setValidationError(err, 1);
        }
        if (uri.equals("http://www.w3.org/1999/XSL/Transform")) {
            XPathException reason = new XPathException("Unknown XSLT element: " + localname);
            reason.setErrorCode("XTSE0010");
            reason.setIsStaticError(true);
            actualClass = AbsentExtensionElement.class;
            temp.setValidationError(reason, 4);
        } else if (temp.isExtensionNamespace(uri) && !toplevel) {
            actualClass = AbsentExtensionElement.class;
            XPathException se = new XPathException("Unknown extension instruction", temp);
            se.setErrorCode("XTDE1450");
            XPathException reason = se;
            temp.setValidationError(reason, 3);
        } else {
            actualClass = LiteralResultElement.class;
        }
        if (actualClass.equals(assumedClass)) {
            node = temp;
        } else {
            try {
                node = (StyleElement)actualClass.newInstance();
            }
            catch (InstantiationException err1) {
                throw new TransformerFactoryConfigurationError(err1, "Failed to create instance of " + actualClass.getName());
            }
            catch (IllegalAccessException err2) {
                throw new TransformerFactoryConfigurationError(err2, "Failed to access class " + actualClass.getName());
            }
            node.substituteFor(temp);
        }
        return node;
    }

    protected StyleElement makeXSLElement(int f, NodeInfo parent) {
        switch (f) {
            case 131: {
                return new XSLAnalyzeString();
            }
            case 132: {
                return new XSLApplyImports();
            }
            case 133: {
                return new XSLApplyTemplates();
            }
            case 135: {
                return new XSLAttribute();
            }
            case 136: {
                return new XSLAttributeSet();
            }
            case 138: {
                return new XSLCallTemplate();
            }
            case 140: {
                return new XSLCharacterMap();
            }
            case 141: {
                return new XSLChoose();
            }
            case 142: {
                return new XSLComment();
            }
            case 143: {
                return new XSLCopy();
            }
            case 144: {
                return new XSLCopyOf();
            }
            case 145: {
                return new XSLDecimalFormat();
            }
            case 146: {
                return new XSLDocument();
            }
            case 147: {
                return new XSLElement();
            }
            case 150: {
                return new XSLFallback();
            }
            case 151: {
                return new XSLForEach();
            }
            case 154: {
                return new XSLForEachGroup();
            }
            case 155: {
                return new XSLFunction();
            }
            case 156: {
                return new XSLIf();
            }
            case 157: {
                return new XSLImport();
            }
            case 158: {
                return new XSLImportSchema();
            }
            case 163: {
                return new XSLInclude();
            }
            case 165: {
                return new XSLKey();
            }
            case 168: {
                return new XSLMatchingSubstring();
            }
            case 173: {
                return new XSLMessage();
            }
            case 178: {
                return new XSLNextMatch();
            }
            case 179: {
                return new XSLMatchingSubstring();
            }
            case 180: {
                return new XSLNumber();
            }
            case 175: {
                return new XSLNamespace();
            }
            case 176: {
                return new XSLNamespaceAlias();
            }
            case 181: {
                return new XSLOtherwise();
            }
            case 183: {
                return new XSLOutput();
            }
            case 186: {
                return new XSLOutputCharacter();
            }
            case 187: {
                return new XSLPackage();
            }
            case 188: {
                return parent instanceof XSLModuleRoot || this.isXSLOverride(parent) ? new XSLGlobalParam() : new XSLLocalParam();
            }
            case 189: {
                return new XSLPerformSort();
            }
            case 190: {
                return new XSLPreserveSpace();
            }
            case 191: {
                return new XSLProcessingInstruction();
            }
            case 192: {
                return new XSLResultDocument();
            }
            case 193: {
                return new XSLSequence();
            }
            case 194: {
                return new XSLSort();
            }
            case 198: {
                return new XSLPreserveSpace();
            }
            case 199: {
                return this.topLevelModule ? new XSLPackage() : new XSLStylesheet();
            }
            case 200: {
                return new XSLTemplate();
            }
            case 201: {
                return new XSLText();
            }
            case 202: {
                return this.topLevelModule ? new XSLPackage() : new XSLStylesheet();
            }
            case 205: {
                return new XSLValueOf();
            }
            case 206: {
                return parent instanceof XSLModuleRoot || this.isXSLOverride(parent) ? new XSLGlobalVariable() : new XSLLocalVariable();
            }
            case 208: {
                return new XSLWithParam();
            }
            case 207: {
                return new XSLWhen();
            }
        }
        return null;
    }

    @Override
    public TextImpl makeTextNode(NodeInfo parent, CharSequence content) {
        return new TextImpl(content.toString());
    }

    public boolean isElementAvailable(String uri, String localName) {
        int fingerprint = this.namePool.getFingerprint(uri, localName);
        if (uri.equals("http://www.w3.org/1999/XSL/Transform")) {
            if (fingerprint == -1) {
                return false;
            }
            StyleElement e = this.makeXSLElement(fingerprint, null);
            if (e != null) {
                return e.isInstruction();
            }
        }
        return false;
    }

    public IAccumulatorManager makeAccumulatorManager() {
        return null;
    }

    public boolean validateTextNode(NodeInfo node) throws XPathException {
        return false;
    }

    public void compileContentValueTemplate(TextImpl node, List<Expression> contents, Container container) throws XPathException {
    }

    public boolean isXSLOverride(NodeInfo node) {
        return node.getFingerprint() == 185;
    }

    public StylesheetPackage newStylesheetPackage(XSLPackage node) {
        return new StylesheetPackage(node);
    }
}

