/*
 * Decompiled with CFR 0.152.
 */
package tr.view.action;

import au.com.trgtd.tr.appl.Constants;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.Calendar;
import java.util.Date;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import net.miginfocom.swing.MigLayout;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import tr.model.Data;
import tr.model.DataLookup;
import tr.model.action.Action;
import tr.model.action.ActionState;
import tr.model.action.ActionStateASAP;
import tr.model.action.ActionStateDelegated;
import tr.model.action.ActionStateInactive;
import tr.model.action.ActionStateScheduled;
import tr.model.action.Recurrence;
import tr.model.context.Context;
import tr.model.criteria.Value;
import tr.model.thought.Thought;
import tr.model.topic.Topic;
import tr.runtime.Email;
import tr.runtime.Open;
import tr.swing.TRButton;
import tr.swing.TRComboBox;
import tr.swing.TRLabel;
import tr.swing.TRTextField;
import tr.swing.date.field.DateField;
import tr.swing.document.LazyDocumentListener;
import tr.swing.editorpane.HyperEditorPane;
import tr.swing.mig.MTextArea;
import tr.swing.time.HourSpinner;
import tr.swing.time.MinuteSpinner;
import tr.util.Observable;
import tr.util.Observer;
import tr.util.Utils;
import tr.view.ViewUtils;
import tr.view.action.StatusComboBoxModel;
import tr.view.action.StatusEnum;
import tr.view.action.prefs.ActionPrefs;
import tr.view.action.recurrence.NewRecurrenceWizard;
import tr.view.action.recurrence.modify.ModifyRecurrenceWizard;
import tr.view.contexts.ContextsComboBox;
import tr.view.contexts.ContextsComboBoxModel;
import tr.view.criteria.EnergyComboBoxModel;
import tr.view.criteria.PriorityComboBoxModel;
import tr.view.criteria.TimeComboBoxModel;
import tr.view.topics.TopicsComboBox;
import tr.view.topics.TopicsComboBoxModel;

public class ActionPanel
extends JPanel
implements Observer {
    private final PropertyChangeListener descrListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (ActionPanel.this.descriptionText.hasFocus()) {
                return;
            }
            if (!ActionPanel.this.descriptionText.getText().equals(ActionPanel.this.action.getDescription())) {
                ActionPanel.this.descriptionText.setText(ActionPanel.this.action.getDescription());
            }
        }
    };
    private final PropertyChangeListener topicListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (ActionPanel.this.topicCombo.hasFocus()) {
                return;
            }
            if (!Utils.equal((Object)ActionPanel.this.action.getTopic(), (Object)ActionPanel.this.topicCombo.getSelectedItem())) {
                ActionPanel.this.topicCombo.setSelectedItem((Object)ActionPanel.this.action.getTopic());
            }
        }
    };
    private final PropertyChangeListener contextListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (ActionPanel.this.contextCombo.hasFocus()) {
                return;
            }
            if (!Utils.equal((Object)ActionPanel.this.action.getContext(), (Object)ActionPanel.this.contextCombo.getSelectedItem())) {
                ActionPanel.this.contextCombo.setSelectedItem((Object)ActionPanel.this.action.getContext());
            }
        }
    };
    private final PropertyChangeListener doneListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (ActionPanel.this.doneCheckBox.isSelected() != ActionPanel.this.action.isDone()) {
                ActionPanel.this.doneCheckBox.setSelected(ActionPanel.this.action.isDone());
                ActionPanel.this.doneDateField.setDate(ActionPanel.this.action.getDoneDate());
                ActionPanel.this.doneDateField.setEnabled(ActionPanel.this.action.canSetDone(true));
            }
        }
    };
    private MigLayout statusLayoutA1 = new MigLayout(this.getMIGCons("insets 0px"), "0[grow]0", "0[]0");
    private MigLayout statusLayoutA2 = new MigLayout(this.getMIGCons("insets 0px"), "0[grow]0", "0[]2:2:2[]0");
    private MigLayout statusLayoutM1 = new MigLayout(this.getMIGCons("insets 0px"), "0[grow]0", "0[top]0");
    private MigLayout statusLayoutM2 = new MigLayout(this.getMIGCons("insets 0px"), "0[grow]0", "0[top]2[top]0");
    private static final boolean DEBUG_MIG_LAYOUT = false;
    private static final String DEFAULT_DESCRIPTION = ActionPanel.getMsg("new.action");
    private static final TRLabel fillerLabel1 = new TRLabel("");
    private static final TRLabel fillerLabel2 = new TRLabel("");
    private static final TRLabel fillerLabel3 = new TRLabel("");
    private Action action;
    private ActionStateInactive stateInactive;
    private ActionStateASAP stateASAP;
    private ActionStateDelegated stateDelegated;
    private ActionStateScheduled stateScheduled;
    private ComboBoxModel topicsModel;
    private ComboBoxModel contextsModel;
    private boolean updating;
    private DocumentListener docListenerDescription;
    private FocusAdapter focusAdapterDescription;
    private DocumentListener docListenerSuccess;
    private DocumentListener docListenerDelegatedTo;
    private DocumentListener docListenerNotes;
    private ActionListener actionListenerTopic;
    private ActionListener actionListenerContext;
    private ActionListener actionListenerRecurrence;
    private ActionListener actionListenerEmail;
    private ActionListener actionListenerStatusCombo;
    private ActionListener actionListenerPriorityCombo;
    private ActionListener actionListenerEnergyCombo;
    private ActionListener actionListenerTimeCombo;
    private ChangeListener changeListenerScheduledHour;
    private ChangeListener changeListenerScheduledMinute;
    private ChangeListener changeListenerDurationHour;
    private ChangeListener changeListenerDurationMinute;
    private HyperlinkListener notesHyperlinkListener;
    private ActionListener doneCheckBoxActionListener;
    private PropertyChangeListener followupDatePropertyChangeListener;
    private PropertyChangeListener createdDatePropertyChangeListener;
    private PropertyChangeListener startDatePropertyChangeListener;
    private PropertyChangeListener dueDatePropertyChangeListener;
    private PropertyChangeListener doneDatePropertyChangeListener;
    private PropertyChangeListener scheduledDatePropertyChangeListener;
    private Observer criteriaObserver;
    private PreferenceChangeListener prefsChangeListener;
    private TRLabel descriptionLabel;
    private TRTextField descriptionText;
    private TRLabel thoughtLabel;
    private TRTextField thoughtText;
    private TRLabel successLabel;
    private MTextArea successText;
    private TRLabel contextLabel;
    private TRComboBox contextCombo;
    private TRComboBox topicCombo;
    private TRLabel topicLabel;
    private DateField createdDateField;
    private TRLabel createdDateLabel;
    private TRLabel delegatedToLabel;
    private TRTextField delegatedToField;
    private JCheckBox doneCheckBox;
    private DateField doneDateField;
    private DateField dueDateField;
    private TRLabel dueDateLabel;
    private HourSpinner durationHourSpinner;
    private TRLabel durationLabel;
    private MinuteSpinner durationMinuteSpinner;
    private TRButton emailButton;
    private TRComboBox energyCombo;
    private TRLabel energyLabel;
    private DateField followupDateField;
    private TRLabel followupLabel;
    private HyperEditorPane notesField;
    private TRLabel notesLabel;
    private TRComboBox priorityCombo;
    private TRLabel priorityLabel;
    private TRButton recurrenceButton;
    private TRLabel recurrenceLabel;
    private DateField scheduledDateField;
    private HourSpinner scheduledHourSpinner;
    private TRLabel scheduledLabel;
    private MinuteSpinner scheduledMinuteSpinner;
    private DateField startDateField;
    private TRLabel startDateLabel;
    private TRComboBox statusCombo;
    private TRLabel statusLabel;
    private TRComboBox timeCombo;
    private TRLabel timeLabel;
    private JPanel statusPanel;

    public ActionPanel() {
        super(new BorderLayout());
        this.initPanel();
        this.initModel(null);
        this.addExternalListeners();
    }

    private Data getData() {
        return (Data)DataLookup.instance().lookup(Data.class);
    }

    public void addNotify() {
        super.addNotify();
        this.addInternalListeners();
    }

    public void removeNotify() {
        this.removeInternalListeners();
        super.removeNotify();
    }

    public void edit() {
        this.descriptionText.requestFocusInWindow();
    }

    public Action getModel() {
        return this.action;
    }

    public void initModel(Action action) {
        if (this.action != null) {
            this.action.removeObserver((Observer)this);
            this.action.removePropertyChangeListenter("Descr", this.descrListener);
            this.action.removePropertyChangeListenter("Topic", this.topicListener);
            this.action.removePropertyChangeListenter("Context", this.contextListener);
            this.action.removePropertyChangeListenter("Done", this.doneListener);
        }
        this.action = action;
        this.stateInactive = null;
        this.stateASAP = null;
        this.stateScheduled = null;
        this.stateDelegated = null;
        this.storeActionState();
        if (this.action != null) {
            this.action.addObserver((Observer)this);
            this.action.addPropertyChangeListenter("Descr", this.descrListener);
            this.action.addPropertyChangeListenter("Topic", this.topicListener);
            this.action.addPropertyChangeListenter("Context", this.contextListener);
            this.action.addPropertyChangeListenter("Done", this.doneListener);
        }
        this.initView();
    }

    private void initView() {
        this.updating = true;
        if (this.action == null) {
            this.descriptionText.setText("");
            this.thoughtText.setText("");
            this.successText.setText("");
            this.topicCombo.setSelectedItem(null);
            this.contextCombo.setSelectedItem(null);
            this.statusCombo.setSelectedItem(null);
            this.followupDateField.setDate(null);
            this.scheduledDateField.setDate(null);
            this.scheduledHourSpinner.setVal(0);
            this.scheduledMinuteSpinner.setVal(0);
            this.durationHourSpinner.setVal(0);
            this.durationMinuteSpinner.setVal(0);
            this.timeCombo.setSelectedItem(null);
            this.energyCombo.setSelectedItem(null);
            this.priorityCombo.setSelectedItem(null);
            this.notesField.setText("");
            this.createdDateField.setDate(null);
            this.startDateField.setDate(null);
            this.dueDateField.setDate(null);
            this.doneCheckBox.setSelected(false);
            this.doneDateField.setDate(null);
            this.setEnabled(false);
        } else {
            ActionStateASAP state;
            this.descriptionText.setText(this.action.getDescription());
            Thought thought = this.action.getThought();
            this.thoughtText.setText(thought == null ? "" : thought.getDescription());
            this.successText.setText(this.action.getSuccess());
            this.topicCombo.setSelectedItem((Object)this.action.getTopic());
            this.contextCombo.setSelectedItem((Object)this.action.getContext());
            this.statusCombo.setSelectedItem(null);
            if (this.action.isStateInactive()) {
                this.statusCombo.setSelectedItem((Object)StatusEnum.INACTIVE);
                this.setStatusInactive();
            } else if (this.action.isStateASAP()) {
                this.statusCombo.setSelectedItem((Object)StatusEnum.DO_ASAP);
                state = (ActionStateASAP)this.action.getState();
                this.setStatusDoASAP();
            }
            if (this.action.isStateDelegated()) {
                this.statusCombo.setSelectedItem((Object)StatusEnum.DELEGATED);
                state = (ActionStateDelegated)this.action.getState();
                this.delegatedToField.setText(state.getTo());
                this.followupDateField.setDate(state.getDate());
                this.setStatusDelegated();
            } else {
                this.delegatedToField.setText("");
                this.followupDateField.setDate(null);
            }
            if (this.action.isStateScheduled()) {
                this.statusCombo.setSelectedItem((Object)StatusEnum.SCHEDULED);
                state = (ActionStateScheduled)this.action.getState();
                this.scheduledDateField.setDate(state.getDate());
                if (state.getDate() == null) {
                    this.scheduledHourSpinner.setValue((Object)new Integer(0));
                    this.scheduledMinuteSpinner.setValue((Object)new Integer(0));
                    this.durationHourSpinner.setValue((Object)new Integer(0));
                    this.durationMinuteSpinner.setValue((Object)new Integer(0));
                } else {
                    Calendar c = Calendar.getInstance();
                    c.setTime(state.getDate());
                    this.scheduledHourSpinner.setVal(c.get(11));
                    this.scheduledMinuteSpinner.setVal(c.get(12));
                    this.durationHourSpinner.setVal(state.getDurationHours());
                    this.durationMinuteSpinner.setVal(state.getDurationMinutes());
                }
                this.setStatusScheduled();
            } else {
                this.scheduledDateField.setDate(null);
                this.scheduledHourSpinner.setValue((Object)new Integer(0));
                this.scheduledMinuteSpinner.setValue((Object)new Integer(0));
                this.durationHourSpinner.setValue((Object)new Integer(0));
                this.durationMinuteSpinner.setValue((Object)new Integer(0));
            }
            this.timeCombo.setSelectedItem((Object)this.action.getTime());
            this.energyCombo.setSelectedItem((Object)this.action.getEnergy());
            this.priorityCombo.setSelectedItem((Object)this.action.getPriority());
            this.notesField.setText(this.action.getNotes());
            this.createdDateField.setDate(this.action.getCreated());
            this.startDateField.setDate(this.action.getStartDate());
            this.dueDateField.setDate(this.action.getDueDate());
            this.doneCheckBox.setSelected(this.action.isDone());
            this.doneDateField.setDate(this.action.getDoneDate());
            this.setEnabled(true);
        }
        this.updating = false;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.descriptionLabel.setEnabled(enabled);
        this.descriptionText.setEnabled(enabled);
        this.successText.setEnabled(enabled);
        this.topicLabel.setEnabled(enabled);
        this.topicCombo.setEnabled(enabled);
        this.contextLabel.setEnabled(enabled);
        this.contextCombo.setEnabled(enabled);
        this.statusLabel.setEnabled(enabled);
        this.statusCombo.setEnabled(enabled);
        this.delegatedToLabel.setEnabled(enabled);
        this.delegatedToField.setEnabled(enabled);
        this.emailButton.setEnabled(enabled);
        this.followupLabel.setEnabled(enabled);
        this.followupDateField.setEnabled(enabled);
        this.scheduledLabel.setEnabled(enabled);
        this.scheduledDateField.setEnabled(enabled);
        this.scheduledHourSpinner.setEnabled(enabled);
        this.scheduledMinuteSpinner.setEnabled(enabled);
        this.durationLabel.setEnabled(enabled);
        this.durationHourSpinner.setEnabled(enabled);
        this.durationMinuteSpinner.setEnabled(enabled);
        if (enabled && this.action.isStateScheduled()) {
            this.recurrenceLabel.setEnabled(this.scheduledDateField.getDate() != null);
            this.recurrenceButton.setEnabled(this.scheduledDateField.getDate() != null);
            ActionStateScheduled state = (ActionStateScheduled)this.action.getState();
            if (state.getRecurrence() == null) {
                this.recurrenceButton.setText(ActionPanel.getMsg("recurrence.create"));
            } else {
                this.recurrenceButton.setText(ActionPanel.getMsg("recurrence.modify"));
            }
        }
        this.notesLabel.setEnabled(enabled);
        this.notesField.setEnabled(enabled);
        this.notesField.setEditable(false);
        this.createdDateLabel.setEnabled(enabled);
        this.createdDateField.setEnabled(enabled && ActionPrefs.isEditCreateDate());
        this.startDateLabel.setEnabled(enabled);
        this.startDateField.setEnabled(enabled);
        this.dueDateLabel.setEnabled(enabled);
        this.dueDateField.setEnabled(enabled);
        this.doneCheckBox.setEnabled(enabled);
        this.doneDateField.setEnabled(enabled && this.action.canSetDone(true));
        this.timeLabel.setEnabled(enabled);
        this.timeCombo.setEnabled(enabled);
        this.energyLabel.setEnabled(enabled);
        this.energyCombo.setEnabled(enabled);
        this.priorityLabel.setEnabled(enabled);
        this.priorityCombo.setEnabled(enabled);
    }

    public void focus() {
        this.descriptionText.requestFocusInWindow();
    }

    public void refresh() {
        this.setEnabled(this.action != null);
    }

    private void addToNotes(String text) {
        String notes = this.notesField.getText().trim();
        if (notes.contains(text)) {
            return;
        }
        if (notes.length() == 0) {
            this.notesField.setText(text);
        } else {
            this.notesField.setText(notes + "\n" + text);
        }
    }

    private void storeActionState() {
        if (this.action == null) {
            return;
        }
        if (this.action.isStateInactive()) {
            this.stateInactive = (ActionStateInactive)this.action.getState();
        } else if (this.action.isStateASAP()) {
            this.stateASAP = (ActionStateASAP)this.action.getState();
        } else if (this.action.isStateScheduled()) {
            this.stateScheduled = (ActionStateScheduled)this.action.getState();
        } else if (this.action.isStateDelegated()) {
            this.stateDelegated = (ActionStateDelegated)this.action.getState();
        }
    }

    private void hyperlink(HyperlinkEvent evt) {
        URL url = evt.getURL();
        if (url == null) {
            return;
        }
        if (evt.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            Open.open((URL)url);
        }
    }

    private void recurrenceActionPerformed(ActionEvent evt) {
        if (this.updating || this.action == null) {
            return;
        }
        if (!this.action.isStateScheduled()) {
            return;
        }
        Recurrence recurrence = this.action.getRecurrence();
        if (recurrence == null) {
            NewRecurrenceWizard wizard = new NewRecurrenceWizard();
            wizard.start(this.action);
        } else {
            ModifyRecurrenceWizard wizard = new ModifyRecurrenceWizard();
            wizard.start(this.action);
        }
        if (this.action.getRecurrence() == null) {
            this.recurrenceButton.setText(ActionPanel.getMsg("recurrence.create"));
        } else {
            this.recurrenceButton.setText(ActionPanel.getMsg("recurrence.modify"));
        }
    }

    private void changedDurationMinutes() {
        if (this.updating || this.action == null) {
            return;
        }
        if (!this.action.isStateScheduled()) {
            return;
        }
        this.stateScheduled = (ActionStateScheduled)this.action.getState();
        if (this.stateScheduled.getDate() == null) {
            this.durationMinuteSpinner.setVal(0);
        } else {
            this.stateScheduled.setDurationMins(this.durationMinuteSpinner.getVal());
        }
    }

    private void changedDurationHours() {
        if (this.updating || this.action == null) {
            return;
        }
        if (!this.action.isStateScheduled()) {
            return;
        }
        this.stateScheduled = (ActionStateScheduled)this.action.getState();
        if (this.stateScheduled.getDate() == null) {
            this.durationHourSpinner.setVal(0);
        } else {
            this.stateScheduled.setDurationHours(this.durationHourSpinner.getVal());
        }
    }

    private void changedScheduledDate(Date date) {
        if (this.updating || this.action == null) {
            return;
        }
        if (!this.action.isStateScheduled()) {
            return;
        }
        this.stateScheduled = (ActionStateScheduled)this.action.getState();
        if (date == null) {
            this.stateScheduled.setDate(null);
            this.scheduledHourSpinner.setVal(0);
            this.scheduledMinuteSpinner.setVal(0);
            this.durationHourSpinner.setVal(0);
            this.durationMinuteSpinner.setVal(0);
            this.recurrenceLabel.setEnabled(false);
            this.recurrenceButton.setEnabled(false);
        } else {
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            cal.set(11, this.scheduledHourSpinner.getVal());
            cal.set(12, this.scheduledMinuteSpinner.getVal());
            cal.set(13, 0);
            cal.set(14, 0);
            this.stateScheduled.setDate(cal.getTime());
            this.scheduledHourSpinner.setEnabled(true);
            this.scheduledMinuteSpinner.setEnabled(true);
            this.durationHourSpinner.setEnabled(true);
            this.durationMinuteSpinner.setEnabled(true);
            this.durationLabel.setEnabled(true);
            this.recurrenceLabel.setEnabled(true);
            this.recurrenceButton.setEnabled(true);
        }
    }

    private void changedFollowupDate(Date date) {
        if (this.updating || this.action == null) {
            return;
        }
        if (this.action.isStateDelegated()) {
            this.stateDelegated = (ActionStateDelegated)this.action.getState();
            this.stateDelegated.setDate(date);
        }
    }

    private void changedPriority() {
        if (this.updating || this.action == null) {
            return;
        }
        this.action.setPriority((Value)this.priorityCombo.getSelectedItem());
    }

    private void changedTime() {
        if (this.updating || this.action == null) {
            return;
        }
        this.action.setTime((Value)this.timeCombo.getSelectedItem());
    }

    private void changedEnergy() {
        if (this.updating || this.action == null) {
            return;
        }
        this.action.setEnergy((Value)this.energyCombo.getSelectedItem());
    }

    private void changedStatus() {
        if (this.updating || this.action == null) {
            return;
        }
        StatusEnum status = (StatusEnum)((Object)this.statusCombo.getSelectedItem());
        switch (status) {
            case INACTIVE: {
                this.action.setState((ActionState)this.getStateInactive());
                this.setStatusInactive();
                break;
            }
            case DO_ASAP: {
                this.action.setState((ActionState)this.getStateASAP());
                this.setStatusDoASAP();
                break;
            }
            case SCHEDULED: {
                this.action.setState((ActionState)this.getStateScheduled());
                this.setStatusScheduled();
                break;
            }
            case DELEGATED: {
                this.action.setState((ActionState)this.getStateDelegated());
                this.setStatusDelegated();
            }
        }
        this.setEnabled(true);
    }

    private void emailActionPerformed(ActionEvent evt) {
        String to = this.delegatedToField.getText();
        if (Utilities.getOperatingSystem() == 16 && to.indexOf("@") == -1) {
            JOptionPane.showMessageDialog(null, ActionPanel.getMsg("ERR_EmailRequired"), "", 1);
            return;
        }
        String subject = this.descriptionText.getText();
        String body = this.notesField.getText();
        Email.email((String)to, (String)subject, (String)body, (String)ActionPrefs.getEmailEncoding());
        Date today = Calendar.getInstance().getTime();
        if (ActionPrefs.isNoteDelegateEmail()) {
            this.addToNotes(ActionPanel.getMsg("MSG_EmailSent") + " " + Constants.DATE_FORMAT_FIXED.format(today));
        }
    }

    private void changedScheduledHour() {
        if (this.updating || this.action == null) {
            return;
        }
        if (!this.action.isStateScheduled()) {
            return;
        }
        this.stateScheduled = (ActionStateScheduled)this.action.getState();
        if (this.stateScheduled.getDate() == null) {
            this.scheduledHourSpinner.setVal(0);
        } else {
            Calendar c = Calendar.getInstance();
            c.setTime(this.stateScheduled.getDate());
            c.set(11, this.scheduledHourSpinner.getVal());
            c.set(13, 0);
            this.stateScheduled.setDate(c.getTime());
            this.scheduledDateField.setDate(c.getTime());
        }
    }

    private void changedScheduledMinute() {
        if (this.updating || this.action == null) {
            return;
        }
        if (!this.action.isStateScheduled()) {
            return;
        }
        this.stateScheduled = (ActionStateScheduled)this.action.getState();
        if (this.stateScheduled.getDate() == null) {
            this.scheduledMinuteSpinner.setVal(0);
        } else {
            Calendar c = Calendar.getInstance();
            c.setTime(this.stateScheduled.getDate());
            c.set(12, this.scheduledMinuteSpinner.getVal());
            c.set(13, 0);
            this.stateScheduled.setDate(c.getTime());
            this.scheduledDateField.setDate(c.getTime());
        }
    }

    private void changedDoneDate(Date date) {
        if (this.updating || this.action == null) {
            return;
        }
        this.action.setDoneDate(this.doneDateField.getDate());
    }

    private void changedDone() {
        if (this.updating || this.action == null) {
            return;
        }
        if (this.action.canSetDone(this.doneCheckBox.isSelected())) {
            this.action.setDone(this.doneCheckBox.isSelected());
            this.doneDateField.setDate(this.action.getDoneDate());
            this.doneDateField.setEnabled(this.action.canSetDone(true));
        }
    }

    private void changedCreatedDate(Date date) {
        if (this.updating || this.action == null) {
            return;
        }
        this.action.setCreated(date);
    }

    private void changedStartDate(Date date) {
        if (this.updating || this.action == null) {
            return;
        }
        this.action.setStartDate(date);
    }

    private void changedDueDate(Date date) {
        if (this.updating || this.action == null) {
            return;
        }
        this.action.setDueDate(this.dueDateField.getDate());
    }

    private void changedContext(ActionEvent evt) {
        if (this.updating || this.action == null) {
            return;
        }
        TRComboBox combo = (TRComboBox)evt.getSource();
        this.action.setContext((Context)combo.getSelectedItem());
    }

    private void changedTopic(ActionEvent evt) {
        if (this.updating || this.action == null) {
            return;
        }
        TRComboBox combo = (TRComboBox)evt.getSource();
        this.action.setTopic((Topic)combo.getSelectedItem());
    }

    private void changedPrefs(PreferenceChangeEvent e) {
        String key = e.getKey();
        if (key.equals("edit.create-date")) {
            this.createdDateField.setEnabled(this.action != null && ActionPrefs.isEditCreateDate());
            return;
        }
        if (key.equals("note.delegate.email")) {
            return;
        }
        if (key.equals("show.due")) {
            this.changedStatus();
            return;
        }
        if (key.equals("show.start")) {
            this.changedStatus();
            return;
        }
        if (key.equals("show.success")) {
            this.removeAll();
            this.add((Component)this.createPanel(), "Center");
            if (this.isShowing()) {
                this.revalidate();
                this.repaint();
            }
            return;
        }
    }

    private void changedCriteria() {
        this.removeAll();
        this.add((Component)this.createPanel(), "Center");
        if (this.isShowing()) {
            this.revalidate();
            this.repaint();
        }
    }

    private void descriptionTextFocusGained(FocusEvent evt) {
        if (this.descriptionText.getText().equals(DEFAULT_DESCRIPTION)) {
            this.descriptionText.setSelectionStart(0);
            this.descriptionText.setSelectionEnd(DEFAULT_DESCRIPTION.length());
        }
    }

    private ActionStateInactive getStateInactive() {
        if (this.stateInactive == null) {
            this.stateInactive = this.action.isStateInactive() ? (ActionStateInactive)this.action.getState() : new ActionStateInactive();
        }
        return this.stateInactive;
    }

    private ActionStateASAP getStateASAP() {
        if (this.stateASAP == null) {
            this.stateASAP = this.action.isStateASAP() ? (ActionStateASAP)this.action.getState() : new ActionStateASAP();
        }
        return this.stateASAP;
    }

    private ActionStateDelegated getStateDelegated() {
        if (this.stateDelegated == null) {
            this.stateDelegated = this.action.isStateDelegated() ? (ActionStateDelegated)this.action.getState() : new ActionStateDelegated();
        }
        return this.stateDelegated;
    }

    private ActionStateScheduled getStateScheduled() {
        if (this.stateScheduled == null) {
            this.stateScheduled = this.action.isStateScheduled() ? (ActionStateScheduled)this.action.getState() : new ActionStateScheduled();
        }
        return this.stateScheduled;
    }

    private void changedDescription() {
        if (this.updating || this.action == null) {
            return;
        }
        this.action.setDescription(this.descriptionText.getText());
    }

    private void changedSuccess() {
        if (this.updating || this.action == null) {
            return;
        }
        this.action.setSuccess(this.successText.getText());
    }

    private void changedDelegatedTo() {
        if (this.updating || this.action == null) {
            return;
        }
        if (this.action.isStateDelegated()) {
            this.stateDelegated = (ActionStateDelegated)this.action.getState();
            this.stateDelegated.setTo(this.delegatedToField.getText());
        }
    }

    private void changedNotes() {
        if (this.updating || this.action == null) {
            return;
        }
        this.action.setNotes(this.notesField.getText());
    }

    private static String getMsg(String key) {
        return NbBundle.getMessage(ActionPanel.class, (String)key);
    }

    private ComboBoxModel getTimeComboBoxModel() {
        return new TimeComboBoxModel();
    }

    private ComboBoxModel getEnergyComboBoxModel() {
        return new EnergyComboBoxModel();
    }

    private ComboBoxModel getPriorityComboBoxModel() {
        return new PriorityComboBoxModel();
    }

    public void update(Observable obs, Object arg) {
        if (this.action == null) {
            return;
        }
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                ActionPanel.this.dueDateField.setDate(ActionPanel.this.action.getDueDate());
                ActionPanel.this.startDateField.setDate(ActionPanel.this.action.getStartDate());
                if (ActionPanel.this.action.isStateDelegated()) {
                    ActionStateDelegated s = (ActionStateDelegated)ActionPanel.this.action.getState();
                    ActionPanel.this.followupDateField.setDate(s.getDate());
                } else if (ActionPanel.this.action.isStateScheduled()) {
                    ActionStateScheduled ass;
                    if (!ActionPanel.this.notesField.getText().equals(ActionPanel.this.action.getNotes())) {
                        ActionPanel.this.notesField.setText(ActionPanel.this.action.getNotes());
                    }
                    if (!ActionPanel.this.successText.getText().equals(ActionPanel.this.action.getSuccess())) {
                        ActionPanel.this.successText.setText(ActionPanel.this.action.getSuccess());
                    }
                    if ((ass = (ActionStateScheduled)ActionPanel.this.action.getState()).getDate() == null) {
                        ActionPanel.this.scheduledHourSpinner.setValue((Object)new Integer(0));
                        ActionPanel.this.scheduledMinuteSpinner.setValue((Object)new Integer(0));
                        ActionPanel.this.durationHourSpinner.setValue((Object)new Integer(0));
                        ActionPanel.this.durationMinuteSpinner.setValue((Object)new Integer(0));
                    } else {
                        Calendar c = Calendar.getInstance();
                        c.setTime(ass.getDate());
                        ActionPanel.this.scheduledHourSpinner.setVal(c.get(11));
                        ActionPanel.this.scheduledMinuteSpinner.setVal(c.get(12));
                        ActionPanel.this.durationHourSpinner.setVal(ass.getDurationHours());
                        ActionPanel.this.durationMinuteSpinner.setVal(ass.getDurationMinutes());
                        ActionPanel.this.scheduledDateField.setDate(ass.getDate());
                    }
                }
            }
        });
    }

    private void addInternalListeners() {
        this.docListenerDescription = new LazyDocumentListener(){

            public void update() {
                ActionPanel.this.changedDescription();
            }
        };
        this.descriptionText.getDocument().addDocumentListener(this.docListenerDescription);
        this.docListenerSuccess = new LazyDocumentListener(){

            public void update() {
                ActionPanel.this.changedSuccess();
            }
        };
        this.successText.getDocument().addDocumentListener(this.docListenerSuccess);
        this.docListenerDelegatedTo = new LazyDocumentListener(){

            public void update() {
                ActionPanel.this.changedDelegatedTo();
            }
        };
        this.delegatedToField.getDocument().addDocumentListener(this.docListenerDelegatedTo);
        this.docListenerNotes = new LazyDocumentListener(){

            public void update() {
                ActionPanel.this.changedNotes();
            }
        };
        this.notesField.addDocumentListener(this.docListenerNotes);
        this.focusAdapterDescription = new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                ActionPanel.this.descriptionTextFocusGained(evt);
            }
        };
        this.descriptionText.addFocusListener((FocusListener)this.focusAdapterDescription);
        this.actionListenerTopic = new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ActionPanel.this.changedTopic(evt);
            }
        };
        this.topicCombo.addActionListener(this.actionListenerTopic);
        this.actionListenerContext = new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ActionPanel.this.changedContext(evt);
            }
        };
        this.contextCombo.addActionListener(this.actionListenerContext);
        this.scheduledDatePropertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                ActionPanel.this.changedScheduledDate((Date)e.getNewValue());
            }
        };
        this.scheduledDateField.addPropertyChangeListener("value", this.scheduledDatePropertyChangeListener);
        this.changeListenerScheduledHour = new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                ActionPanel.this.changedScheduledHour();
            }
        };
        this.scheduledHourSpinner.addChangeListener(this.changeListenerScheduledHour);
        this.changeListenerScheduledMinute = new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                ActionPanel.this.changedScheduledMinute();
            }
        };
        this.scheduledMinuteSpinner.addChangeListener(this.changeListenerScheduledMinute);
        this.changeListenerDurationHour = new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                ActionPanel.this.changedDurationHours();
            }
        };
        this.durationHourSpinner.addChangeListener(this.changeListenerDurationHour);
        this.changeListenerDurationMinute = new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                ActionPanel.this.changedDurationMinutes();
            }
        };
        this.durationMinuteSpinner.addChangeListener(this.changeListenerDurationMinute);
        this.actionListenerRecurrence = new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ActionPanel.this.recurrenceActionPerformed(evt);
            }
        };
        this.recurrenceButton.addActionListener(this.actionListenerRecurrence);
        this.actionListenerEmail = new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ActionPanel.this.emailActionPerformed(evt);
            }
        };
        this.emailButton.addActionListener(this.actionListenerEmail);
        this.actionListenerStatusCombo = new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ActionPanel.this.changedStatus();
            }
        };
        this.statusCombo.addActionListener(this.actionListenerStatusCombo);
        this.actionListenerPriorityCombo = new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ActionPanel.this.changedPriority();
            }
        };
        this.priorityCombo.addActionListener(this.actionListenerPriorityCombo);
        this.actionListenerEnergyCombo = new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ActionPanel.this.changedEnergy();
            }
        };
        this.energyCombo.addActionListener(this.actionListenerEnergyCombo);
        this.actionListenerTimeCombo = new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ActionPanel.this.changedTime();
            }
        };
        this.timeCombo.addActionListener(this.actionListenerTimeCombo);
        this.followupDatePropertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                ActionPanel.this.changedFollowupDate((Date)e.getNewValue());
            }
        };
        this.followupDateField.addPropertyChangeListener("value", this.followupDatePropertyChangeListener);
        this.createdDatePropertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                ActionPanel.this.changedCreatedDate((Date)e.getNewValue());
            }
        };
        this.createdDateField.addPropertyChangeListener("value", this.createdDatePropertyChangeListener);
        this.startDatePropertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                ActionPanel.this.changedStartDate((Date)e.getNewValue());
            }
        };
        this.startDateField.addPropertyChangeListener("value", this.startDatePropertyChangeListener);
        this.dueDatePropertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                ActionPanel.this.changedDueDate((Date)e.getNewValue());
            }
        };
        this.dueDateField.addPropertyChangeListener("value", this.dueDatePropertyChangeListener);
        this.doneCheckBoxActionListener = new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ActionPanel.this.changedDone();
            }
        };
        this.doneCheckBox.addActionListener(this.doneCheckBoxActionListener);
        this.doneDatePropertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                ActionPanel.this.changedDoneDate((Date)e.getNewValue());
            }
        };
        this.doneDateField.addPropertyChangeListener("value", this.doneDatePropertyChangeListener);
        this.notesHyperlinkListener = new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent evt) {
                ActionPanel.this.hyperlink(evt);
            }
        };
        this.notesField.addHyperlinkListener(this.notesHyperlinkListener);
    }

    private void removeInternalListeners() {
        this.descriptionText.getDocument().removeDocumentListener(this.docListenerDescription);
        this.docListenerDescription = null;
        this.descriptionText.removeFocusListener((FocusListener)this.focusAdapterDescription);
        this.focusAdapterDescription = null;
        this.successText.getDocument().removeDocumentListener(this.docListenerSuccess);
        this.docListenerSuccess = null;
        this.contextCombo.removeActionListener(this.actionListenerContext);
        this.actionListenerContext = null;
        this.topicCombo.removeActionListener(this.actionListenerTopic);
        this.actionListenerTopic = null;
        this.statusCombo.removeActionListener(this.actionListenerStatusCombo);
        this.actionListenerStatusCombo = null;
        this.scheduledDateField.removePropertyChangeListener(this.scheduledDatePropertyChangeListener);
        this.scheduledDatePropertyChangeListener = null;
        this.scheduledHourSpinner.removeChangeListener(this.changeListenerScheduledHour);
        this.changeListenerScheduledHour = null;
        this.scheduledMinuteSpinner.removeChangeListener(this.changeListenerScheduledMinute);
        this.changeListenerScheduledMinute = null;
        this.durationHourSpinner.removeChangeListener(this.changeListenerDurationHour);
        this.changeListenerDurationHour = null;
        this.durationMinuteSpinner.removeChangeListener(this.changeListenerDurationMinute);
        this.changeListenerDurationMinute = null;
        this.recurrenceButton.removeActionListener(this.actionListenerRecurrence);
        this.actionListenerRecurrence = null;
        this.delegatedToField.getDocument().removeDocumentListener(this.docListenerDelegatedTo);
        this.docListenerDelegatedTo = null;
        this.emailButton.removeActionListener(this.actionListenerEmail);
        this.actionListenerEmail = null;
        this.followupDateField.removePropertyChangeListener(this.followupDatePropertyChangeListener);
        this.followupDatePropertyChangeListener = null;
        this.timeCombo.removeActionListener(this.actionListenerTimeCombo);
        this.actionListenerTimeCombo = null;
        this.energyCombo.removeActionListener(this.actionListenerEnergyCombo);
        this.actionListenerEnergyCombo = null;
        this.priorityCombo.removeActionListener(this.actionListenerPriorityCombo);
        this.actionListenerPriorityCombo = null;
        this.notesField.removeDocumentListener(this.docListenerNotes);
        this.docListenerNotes = null;
        this.notesField.removeHyperlinkListener(this.notesHyperlinkListener);
        this.notesHyperlinkListener = null;
        this.createdDateField.removePropertyChangeListener(this.createdDatePropertyChangeListener);
        this.createdDatePropertyChangeListener = null;
        this.startDateField.removePropertyChangeListener(this.startDatePropertyChangeListener);
        this.startDatePropertyChangeListener = null;
        this.dueDateField.removePropertyChangeListener(this.dueDatePropertyChangeListener);
        this.dueDatePropertyChangeListener = null;
        this.doneCheckBox.removeActionListener(this.doneCheckBoxActionListener);
        this.doneCheckBoxActionListener = null;
        this.doneDateField.removePropertyChangeListener(this.doneDatePropertyChangeListener);
        this.doneDatePropertyChangeListener = null;
    }

    private void addExternalListeners() {
        this.prefsChangeListener = new PreferenceChangeListener(){

            public void preferenceChange(PreferenceChangeEvent evt) {
                ActionPanel.this.changedPrefs(evt);
            }
        };
        ActionPrefs.prefs.addPreferenceChangeListener(this.prefsChangeListener);
        this.criteriaObserver = new Observer(){

            public void update(Observable obs, Object arg) {
                ActionPanel.this.changedCriteria();
            }
        };
        Data data = this.getData();
        if (data != null) {
            this.getData().getTimeCriterion().addObserver(this.criteriaObserver);
            this.getData().getEnergyCriterion().addObserver(this.criteriaObserver);
            this.getData().getPriorityCriterion().addObserver(this.criteriaObserver);
        }
    }

    private void initPanel() {
        this.scheduledLabel = new TRLabel();
        this.scheduledHourSpinner = new HourSpinner();
        this.scheduledMinuteSpinner = new MinuteSpinner();
        this.durationLabel = new TRLabel();
        this.durationHourSpinner = new HourSpinner();
        this.durationMinuteSpinner = new MinuteSpinner();
        this.recurrenceLabel = new TRLabel();
        this.recurrenceButton = new TRButton();
        this.scheduledDateField = new DateField();
        this.delegatedToLabel = new TRLabel();
        this.delegatedToField = new TRTextField();
        this.emailButton = new TRButton();
        this.followupLabel = new TRLabel();
        this.followupDateField = new DateField();
        this.descriptionLabel = new TRLabel();
        this.descriptionText = new TRTextField();
        this.thoughtLabel = new TRLabel();
        this.thoughtText = new TRTextField();
        this.successLabel = new TRLabel();
        this.successText = new MTextArea();
        this.contextLabel = new TRLabel();
        this.contextsModel = new ContextsComboBoxModel(false);
        this.contextCombo = new ContextsComboBox(this.contextsModel);
        this.topicLabel = new TRLabel();
        this.topicsModel = new TopicsComboBoxModel(false);
        this.topicCombo = new TopicsComboBox(this.topicsModel);
        this.statusLabel = new TRLabel();
        this.statusCombo = new TRComboBox();
        this.priorityLabel = new TRLabel();
        this.energyLabel = new TRLabel();
        this.energyCombo = new TRComboBox();
        this.timeLabel = new TRLabel();
        this.timeCombo = new TRComboBox();
        this.priorityCombo = new TRComboBox();
        this.notesLabel = new TRLabel();
        this.notesField = new HyperEditorPane();
        this.createdDateLabel = new TRLabel();
        this.startDateLabel = new TRLabel();
        this.dueDateLabel = new TRLabel();
        this.doneCheckBox = new JCheckBox();
        this.createdDateField = new DateField();
        this.startDateField = new DateField();
        this.dueDateField = new DateField();
        this.doneDateField = new DateField();
        this.scheduledLabel.setText(ActionPanel.getMsg("LBL_ScheduledFor"));
        this.scheduledHourSpinner.setMaximumSize(new Dimension(46, 23));
        this.scheduledHourSpinner.setMinimumSize(new Dimension(46, 23));
        this.scheduledHourSpinner.setPreferredSize(new Dimension(46, 23));
        this.scheduledMinuteSpinner.setMaximumSize(new Dimension(46, 23));
        this.scheduledMinuteSpinner.setMinimumSize(new Dimension(46, 23));
        this.scheduledMinuteSpinner.setPreferredSize(new Dimension(46, 23));
        this.durationLabel.setText(ActionPanel.getMsg("LBL_Duration"));
        this.durationHourSpinner.setMaximumSize(new Dimension(46, 23));
        this.durationHourSpinner.setMinimumSize(new Dimension(46, 23));
        this.durationHourSpinner.setPreferredSize(new Dimension(46, 23));
        this.durationMinuteSpinner.setMaximumSize(new Dimension(46, 23));
        this.durationMinuteSpinner.setMinimumSize(new Dimension(46, 23));
        this.durationMinuteSpinner.setPreferredSize(new Dimension(46, 23));
        this.recurrenceLabel.setText(ActionPanel.getMsg("LBL_Recurrence"));
        this.recurrenceButton.setText(NbBundle.getMessage(ActionPanel.class, (String)"recurrence.create"));
        this.scheduledDateField.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.scheduledDateField.setMaximumSize(new Dimension(120, 23));
        this.scheduledDateField.setMinimumSize(new Dimension(120, 23));
        this.scheduledDateField.setPreferredSize(new Dimension(120, 23));
        this.delegatedToLabel.setText(ActionPanel.getMsg("LBL_DelegatedTo"));
        this.delegatedToField.setMaximumSize(new Dimension(210, 23));
        this.delegatedToField.setMinimumSize(new Dimension(210, 23));
        this.delegatedToField.setPreferredSize(new Dimension(210, 23));
        this.emailButton.setText(ActionPanel.getMsg("LBL_Email"));
        this.followupLabel.setText(ActionPanel.getMsg("LBL_FollowUp"));
        this.followupDateField.setMaximumSize(new Dimension(110, 23));
        this.followupDateField.setMinimumSize(new Dimension(110, 23));
        this.followupDateField.setPreferredSize(new Dimension(110, 23));
        this.descriptionLabel.setText(ActionPanel.getMsg("LBL_Description"));
        this.thoughtLabel.setText(ActionPanel.getMsg("LBL_Thought"));
        this.thoughtText.setBackground(UIManager.getDefaults().getColor("Panel.background"));
        this.thoughtText.setEnabled(false);
        this.successLabel.setText(NbBundle.getMessage(ActionPanel.class, (String)"ActionPanel.success"));
        this.contextLabel.setText(ActionPanel.getMsg("LBL_Context"));
        this.contextCombo.setMaximumRowCount(30);
        this.topicLabel.setText(ActionPanel.getMsg("LBL_Topic"));
        this.statusLabel.setText(ActionPanel.getMsg("LBL_Status"));
        this.statusCombo.setModel((ComboBoxModel)new StatusComboBoxModel());
        this.timeLabel.setText(ActionPanel.getMsg("LBL_SimpleTime"));
        this.timeCombo.setModel(this.getTimeComboBoxModel());
        this.energyLabel.setText(ActionPanel.getMsg("LBL_Energy"));
        this.energyCombo.setModel(this.getEnergyComboBoxModel());
        this.priorityLabel.setText(ActionPanel.getMsg("LBL_Priority"));
        this.priorityCombo.setModel(this.getPriorityComboBoxModel());
        this.notesLabel.setText(ActionPanel.getMsg("LBL_Notes"));
        this.notesField.setMinimumSize(new Dimension(100, 62));
        this.createdDateLabel.setText(ActionPanel.getMsg("LBL_Created"));
        this.startDateLabel.setText(NbBundle.getMessage(ActionPanel.class, (String)"PanelAction.start"));
        this.dueDateLabel.setText(NbBundle.getMessage(ActionPanel.class, (String)"PanelAction.due"));
        this.doneCheckBox.setText(ActionPanel.getMsg("LBL_Done"));
        this.doneCheckBox.setHorizontalTextPosition(10);
        this.add((Component)this.createPanel(), "Center");
    }

    private JPanel createPanel() {
        JPanel panel = ViewUtils.isAquaLaF() ? (ActionPrefs.isShowSuccess() ? new JPanel((LayoutManager)new MigLayout(this.getMIGCons(), "2[]4[grow]4[]4[]2", "2[]2[]2[]2[]2[]2[]2[]2[]2[]2[grow]2[]2")) : new JPanel((LayoutManager)new MigLayout(this.getMIGCons(), "2[]4[grow]4[]4[]2", "2[]2[]2[]2[]2[]2[]2[]2[]2[grow]2[]2"))) : (ActionPrefs.isShowSuccess() ? new JPanel((LayoutManager)new MigLayout(this.getMIGCons(), "2[]4[grow]4[]4[]2", "2[top]2[top]2[top]2[top]2[center]2[top]2[center]2[top]2[center]2[top, grow]2[center]2[top]2")) : new JPanel((LayoutManager)new MigLayout(this.getMIGCons(), "2[]4[grow]4[]4[]2", "2[top]2[top]2[top]2[center]2[top]2[center]2[top]2[center]2[top, grow]2[center]2[top]2")));
        panel.add((Component)this.descriptionLabel, "align right");
        panel.add((Component)this.descriptionText, "span, growx, wrap");
        panel.add((Component)this.thoughtLabel, "align right");
        panel.add((Component)this.thoughtText, "span, growx, wrap");
        if (ActionPrefs.isShowSuccess()) {
            if (ViewUtils.isAquaLaF()) {
                panel.add((Component)this.successLabel, "align right top");
                panel.add((Component)this.successText, "gapleft 3, gapright 3, growx, span, wrap");
            } else {
                panel.add((Component)this.successLabel, "align right top");
                panel.add((Component)this.successText, "growx, span, wrap");
            }
        }
        panel.add((Component)this.topicLabel, "align right");
        panel.add((Component)this.topicCombo, "align left, wrap");
        ViewUtils.addSeparator((JPanel)panel);
        JComponent[][] comps = new JComponent[4][2];
        int compsIndex = 0;
        comps[compsIndex][0] = this.contextLabel;
        comps[compsIndex][1] = this.contextCombo;
        Data data = this.getData();
        if (data.getTimeCriterion().isUse()) {
            comps[++compsIndex][0] = this.timeLabel;
            comps[compsIndex][1] = this.timeCombo;
        }
        if (data.getEnergyCriterion().isUse()) {
            comps[++compsIndex][0] = this.energyLabel;
            comps[compsIndex][1] = this.energyCombo;
        }
        if (data.getPriorityCriterion().isUse()) {
            comps[++compsIndex][0] = this.priorityLabel;
            comps[compsIndex][1] = this.priorityCombo;
        }
        if (compsIndex == 0) {
            panel.add((Component)comps[0][0], "align right");
            panel.add((Component)comps[0][1], "align left, wrap");
        } else if (compsIndex == 1) {
            panel.add((Component)comps[0][0], "align right");
            panel.add((Component)comps[0][1], "align left, split 3");
            panel.add((Component)comps[1][0], "align right");
            panel.add((Component)comps[1][1], "align left, wrap");
        } else if (compsIndex == 2) {
            panel.add((Component)comps[0][0], "align right");
            panel.add((Component)comps[0][1], "align left, split 5");
            panel.add((Component)comps[1][0], "align right");
            panel.add((Component)comps[1][1], "align left");
            panel.add((Component)comps[2][0], "align right");
            panel.add((Component)comps[2][1], "align left, wrap");
        } else if (compsIndex == 3) {
            panel.add((Component)comps[0][0], "align right");
            panel.add((Component)comps[0][1], "align left, split 7");
            panel.add((Component)comps[1][0], "align right");
            panel.add((Component)comps[1][1], "align left");
            panel.add((Component)comps[2][0], "align right");
            panel.add((Component)comps[2][1], "align left");
            panel.add((Component)comps[3][0], "align right");
            panel.add((Component)comps[3][1], "align left, wrap");
        }
        ViewUtils.addSeparator((JPanel)panel);
        if (ViewUtils.isAquaLaF()) {
            panel.add((Component)this.statusLabel, "align right top, gaptop 4");
            panel.add((Component)this.getStatusPanel(Rows.One), "align left, growx 100, wrap");
        } else {
            panel.add((Component)this.statusLabel, "align right top");
            panel.add((Component)this.getStatusPanel(Rows.One), "align left, growx 100, wrap");
        }
        ViewUtils.addSeparator((JPanel)panel);
        if (ViewUtils.isAquaLaF()) {
            panel.add((Component)this.notesLabel, "align right top, gaptop 4, growy 0");
            panel.add((Component)this.notesField, "span, gapleft 3, gapright 3, align left, growx, growy 100, wrap");
        } else {
            panel.add((Component)this.notesLabel, "align right top, growy 0");
            panel.add((Component)this.notesField, "span, align left, growx, growy 100, wrap");
        }
        ViewUtils.addSeparator((JPanel)panel);
        panel.add((Component)this.doneCheckBox, "align right");
        panel.add((Component)this.doneDateField, "align left, split 3");
        panel.add((Component)this.createdDateLabel, "align left");
        panel.add((Component)this.createdDateField, "align left, wrap");
        return panel;
    }

    private JPanel getStatusPanel(Rows rows) {
        if (this.statusPanel == null) {
            this.statusPanel = new JPanel();
            this.statusPanel.setOpaque(false);
            this.statusPanel.setBorder(new EmptyBorder(0, 0, 0, 0));
        } else {
            this.statusPanel.removeAll();
        }
        if (ViewUtils.isAquaLaF()) {
            this.statusPanel.setLayout((LayoutManager)(rows == Rows.One ? this.statusLayoutA1 : this.statusLayoutA2));
        } else {
            this.statusPanel.setLayout((LayoutManager)(rows == Rows.One ? this.statusLayoutM1 : this.statusLayoutM2));
        }
        return this.statusPanel;
    }

    private void setStatusDelegated() {
        boolean focus = this.statusCombo.hasFocus();
        JPanel panel = this.getStatusPanel(Rows.Two);
        panel.add((Component)this.statusCombo, "span, split");
        if (ActionPrefs.isShowDueDate()) {
            panel.add((Component)this.dueDateLabel, "");
            panel.add((Component)this.dueDateField, "");
        }
        if (ActionPrefs.isShowStartDate()) {
            panel.add((Component)this.startDateLabel, "");
            panel.add((Component)this.startDateField, "");
        }
        panel.add((Component)fillerLabel1, "wrap");
        panel.add((Component)this.delegatedToLabel, "gapleft 4, span, split 5");
        panel.add((Component)this.delegatedToField, "");
        panel.add((Component)this.emailButton, "gapleft 2");
        panel.add((Component)this.followupLabel, "");
        panel.add((Component)this.followupDateField, "wrap");
        panel.revalidate();
        panel.repaint();
        if (focus) {
            this.statusCombo.requestFocusInWindow();
        }
    }

    private void setStatusDoASAP() {
        boolean focus = this.statusCombo.hasFocus();
        JPanel panel = this.getStatusPanel(Rows.One);
        panel.add((Component)this.statusCombo, "span, split");
        if (ActionPrefs.isShowDueDate()) {
            panel.add((Component)this.dueDateLabel, "");
            panel.add((Component)this.dueDateField, "");
        }
        if (ActionPrefs.isShowStartDate()) {
            panel.add((Component)this.startDateLabel, "");
            panel.add((Component)this.startDateField, "");
        }
        panel.add((Component)fillerLabel2, "wrap");
        panel.revalidate();
        panel.repaint();
        if (focus) {
            this.statusCombo.requestFocusInWindow();
        }
    }

    private void setStatusInactive() {
        boolean focus = this.statusCombo.hasFocus();
        JPanel panel = this.getStatusPanel(Rows.One);
        panel.add((Component)this.statusCombo, "span, split");
        if (ActionPrefs.isShowDueDate()) {
            panel.add((Component)this.dueDateLabel, "");
            panel.add((Component)this.dueDateField, "");
        }
        if (ActionPrefs.isShowStartDate()) {
            panel.add((Component)this.startDateLabel, "");
            panel.add((Component)this.startDateField, "");
        }
        panel.add((Component)fillerLabel3, "wrap");
        panel.revalidate();
        panel.repaint();
        if (focus) {
            this.statusCombo.requestFocusInWindow();
        }
    }

    private void setStatusScheduled() {
        boolean focus = this.statusCombo.hasFocus();
        JPanel panel = this.getStatusPanel(Rows.Two);
        panel.add((Component)this.statusCombo, "span, split 7");
        panel.add((Component)this.scheduledDateField, "gapleft 2");
        panel.add((Component)this.scheduledHourSpinner, "gapleft 0");
        panel.add((Component)this.scheduledMinuteSpinner, "gapleft 0");
        panel.add((Component)this.durationLabel, "gapleft 4");
        panel.add((Component)this.durationHourSpinner, "gapleft 2");
        panel.add((Component)this.durationMinuteSpinner, "gapleft 0, wrap");
        panel.add((Component)this.recurrenceLabel, "gapleft 4, split 2");
        panel.add((Component)this.recurrenceButton, "gapleft 2, wrap");
        panel.revalidate();
        panel.repaint();
        if (focus) {
            this.statusCombo.requestFocusInWindow();
        }
    }

    private String getMIGCons() {
        return "";
    }

    private String getMIGCons(String c) {
        assert (c != null && c.trim().length() > 0);
        return c;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Rows {
        One,
        Two;

    }
}

