/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.serializer.extension;

import de.rub.nds.modifiablevariable.bytearray.ModifiableByteArray;
import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.protocol.message.extension.PasswordSaltExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.serializer.extension.ExtensionSerializer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PasswordSaltExtensionSerializer
extends ExtensionSerializer<PasswordSaltExtensionMessage> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final PasswordSaltExtensionMessage msg;

    public PasswordSaltExtensionSerializer(PasswordSaltExtensionMessage message) {
        super(message);
        this.msg = message;
    }

    @Override
    public byte[] serializeExtensionContent() {
        LOGGER.debug("Serializing PasswordSaltExtensionMessage");
        this.writeSaltLength(this.msg);
        this.writeSalt(this.msg);
        return this.getAlreadySerialized();
    }

    private void writeSaltLength(PasswordSaltExtensionMessage msg) {
        this.appendInt((Integer)msg.getSaltLength().getValue(), 2);
        LOGGER.debug("SaltLength: " + msg.getSaltLength().getValue());
    }

    private void writeSalt(PasswordSaltExtensionMessage msg) {
        this.appendBytes((byte[])msg.getSalt().getValue());
        LOGGER.debug("Salt: " + ArrayConverter.bytesToHexString((ModifiableByteArray)msg.getSalt()));
    }
}

