/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.api.resource;

import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Stream;
import org.traccar.api.BaseObjectResource;
import org.traccar.api.signature.TokenManager;
import org.traccar.broadcast.BroadcastService;
import org.traccar.config.Config;
import org.traccar.config.Keys;
import org.traccar.database.MediaManager;
import org.traccar.helper.LogAction;
import org.traccar.model.Device;
import org.traccar.model.DeviceAccumulators;
import org.traccar.model.Permission;
import org.traccar.model.Position;
import org.traccar.model.User;
import org.traccar.session.ConnectionManager;
import org.traccar.session.cache.CacheManager;
import org.traccar.storage.StorageException;
import org.traccar.storage.query.Columns;
import org.traccar.storage.query.Condition;
import org.traccar.storage.query.Order;
import org.traccar.storage.query.Request;

@Path(value="devices")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class DeviceResource
extends BaseObjectResource<Device> {
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    private static final int IMAGE_SIZE_LIMIT = 500000;
    @Inject
    private Config config;
    @Inject
    private CacheManager cacheManager;
    @Inject
    private ConnectionManager connectionManager;
    @Inject
    private BroadcastService broadcastService;
    @Inject
    private MediaManager mediaManager;
    @Inject
    private TokenManager tokenManager;
    @Inject
    private LogAction actionLogger;
    @Context
    private HttpServletRequest request;

    public DeviceResource() {
        super(Device.class);
    }

    @GET
    public Stream<Device> get(@QueryParam(value="all") boolean all, @QueryParam(value="userId") long userId, @QueryParam(value="uniqueId") List<String> uniqueIds, @QueryParam(value="id") List<Long> deviceIds, @QueryParam(value="excludeAttributes") boolean excludeAttributes) throws StorageException {
        Columns columns;
        Columns columns2 = columns = excludeAttributes ? new Columns.Exclude("attributes") : new Columns.All();
        if (!uniqueIds.isEmpty() || !deviceIds.isEmpty()) {
            LinkedList<Device> result = new LinkedList<Device>();
            for (String uniqueId : uniqueIds) {
                result.addAll(this.storage.getObjects(Device.class, new Request(columns, new Condition.And(new Condition.Equals("uniqueId", uniqueId), new Condition.Permission(User.class, this.getUserId(), Device.class)))));
            }
            for (Long deviceId : deviceIds) {
                result.addAll(this.storage.getObjects(Device.class, new Request(columns, new Condition.And(new Condition.Equals("id", deviceId), new Condition.Permission(User.class, this.getUserId(), Device.class)))));
            }
            return result.stream();
        }
        LinkedList<Condition> conditions = new LinkedList<Condition>();
        if (all) {
            if (this.permissionsService.notAdmin(this.getUserId())) {
                conditions.add(new Condition.Permission(User.class, this.getUserId(), this.baseClass));
            }
        } else if (userId == 0L) {
            conditions.add(new Condition.Permission(User.class, this.getUserId(), this.baseClass));
        } else {
            this.permissionsService.checkUser(this.getUserId(), userId);
            conditions.add(new Condition.Permission(User.class, userId, this.baseClass).excludeGroups());
        }
        return this.storage.getObjectsStream(this.baseClass, new Request(columns, Condition.merge(conditions), new Order("name")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Path(value="{id}/accumulators")
    @PUT
    public Response updateAccumulators(DeviceAccumulators entity) throws Exception {
        this.permissionsService.checkPermission(Device.class, this.getUserId(), entity.getDeviceId());
        this.permissionsService.checkEdit(this.getUserId(), Device.class, false, false);
        Position position = this.storage.getObject(Position.class, new Request((Columns)new Columns.All(), new Condition.LatestPositions(entity.getDeviceId())));
        if (position != null) {
            if (entity.getTotalDistance() != null) {
                position.getAttributes().put("totalDistance", entity.getTotalDistance());
            }
            if (entity.getHours() != null) {
                position.getAttributes().put("hours", entity.getHours());
            }
            position.setId(this.storage.addObject(position, new Request(new Columns.Exclude("id"))));
            Device device = new Device();
            device.setId(position.getDeviceId());
            device.setPositionId(position.getId());
            this.storage.updateObject(device, new Request((Columns)new Columns.Include("positionId"), new Condition.Equals("id", device.getId())));
            Object key = new Object();
            try {
                this.cacheManager.addDevice(position.getDeviceId(), key);
                this.cacheManager.updatePosition(position);
                this.connectionManager.updatePosition(true, position);
            }
            finally {
                this.cacheManager.removeDevice(position.getDeviceId(), key);
            }
        } else {
            throw new IllegalArgumentException();
        }
        this.actionLogger.resetAccumulators(this.request, this.getUserId(), entity.getDeviceId());
        return Response.noContent().build();
    }

    private String imageExtension(String type) {
        return switch (type) {
            case "image/jpeg" -> "jpg";
            case "image/png" -> "png";
            case "image/gif" -> "gif";
            case "image/webp" -> "webp";
            case "image/svg+xml" -> "svg";
            default -> throw new IllegalArgumentException("Unsupported image type");
        };
    }

    @Path(value="{id}/image")
    @POST
    @Consumes(value={"image/*"})
    public Response uploadImage(@PathParam(value="id") long deviceId, File file, @HeaderParam(value="Content-Type") String type) throws StorageException, IOException {
        Device device = this.storage.getObject(Device.class, new Request((Columns)new Columns.All(), new Condition.And(new Condition.Equals("id", deviceId), new Condition.Permission(User.class, this.getUserId(), Device.class))));
        if (device != null) {
            String name = "device";
            String extension = this.imageExtension(type);
            try (FileInputStream input = new FileInputStream(file);
                 OutputStream output = this.mediaManager.createFileStream(device.getUniqueId(), name, extension);){
                int read;
                long transferred = 0L;
                byte[] buffer = new byte[8192];
                while ((read = input.read(buffer, 0, buffer.length)) >= 0) {
                    output.write(buffer, 0, read);
                    if ((transferred += (long)read) <= 500000L) continue;
                    throw new IllegalArgumentException("Image size limit exceeded");
                }
            }
            return Response.ok((Object)(name + "." + extension)).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    @Path(value="share")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @POST
    public String shareDevice(@FormParam(value="deviceId") long deviceId, @FormParam(value="expiration") Date expiration) throws StorageException, GeneralSecurityException, IOException {
        User user = this.permissionsService.getUser(this.getUserId());
        if (this.permissionsService.getServer().getBoolean(Keys.DEVICE_SHARE_DISABLE.getKey())) {
            throw new SecurityException("Sharing is disabled");
        }
        if (user.getTemporary()) {
            throw new SecurityException("Temporary user");
        }
        if (user.getExpirationTime() != null && user.getExpirationTime().before(expiration)) {
            expiration = user.getExpirationTime();
        }
        Device device = this.storage.getObject(Device.class, new Request((Columns)new Columns.All(), new Condition.And(new Condition.Equals("id", deviceId), new Condition.Permission(User.class, user.getId(), Device.class))));
        String shareEmail = user.getEmail() + ":" + device.getUniqueId();
        User share = this.storage.getObject(User.class, new Request((Columns)new Columns.All(), new Condition.Equals("email", shareEmail)));
        if (share == null) {
            share = new User();
            share.setName(device.getName());
            share.setEmail(shareEmail);
            share.setExpirationTime(expiration);
            share.setTemporary(true);
            share.setReadonly(true);
            share.setLimitCommands(user.getLimitCommands() || !this.config.getBoolean(Keys.WEB_SHARE_DEVICE_COMMANDS));
            share.setDisableReports(user.getDisableReports() || !this.config.getBoolean(Keys.WEB_SHARE_DEVICE_REPORTS));
            share.setId(this.storage.addObject(share, new Request(new Columns.Exclude("id"))));
            this.storage.addPermission(new Permission(User.class, share.getId(), Device.class, deviceId));
        }
        return this.tokenManager.generateToken(share.getId(), expiration);
    }
}

