/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.view;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.commons.httpclient.URI;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.extension.AbstractDialog;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.SiteNode;
import org.zaproxy.zap.model.Context;
import org.zaproxy.zap.model.Target;
import org.zaproxy.zap.utils.DisplayUtils;
import org.zaproxy.zap.view.ContextsSitesPanel;
import org.zaproxy.zap.view.ContextsTreeCellRenderer;
import org.zaproxy.zap.view.SiteMapListener;
import org.zaproxy.zap.view.SiteMapTreeCellRenderer;

public class NodeSelectDialog
extends AbstractDialog {
    private static final long serialVersionUID = 1L;
    private JPanel jPanel = null;
    private JTree treeContext = null;
    private JTree treeSite = null;
    private JButton selectButton = null;
    private JButton cancelButton = null;
    private DefaultTreeModel contextTree = null;
    private DefaultTreeModel siteTree = null;
    private SiteNode selectedSiteNode = null;
    private Target selectedTarget = null;
    private boolean allowRoot = false;

    public NodeSelectDialog(Window parent) throws HeadlessException {
        super(parent, true);
        this.initialize();
    }

    private void initialize() {
        this.setTitle(Constant.messages.getString("siteselect.dialog.title"));
        this.setContentPane(this.getJPanel());
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
            }

            @Override
            public void windowClosing(WindowEvent e) {
                NodeSelectDialog.this.cancelButton.doClick();
            }
        });
        this.pack();
    }

    public SiteNode showDialog(URI uri) {
        return this.showDialog(Model.getSingleton().getSession().getSiteTree().findNode(uri));
    }

    public SiteNode showDialog(SiteNode defaultNode) {
        this.getTreeContext().setVisible(false);
        SiteNode siteRoot = Model.getSingleton().getSession().getSiteTree().getRoot();
        this.populateNode(siteRoot, (SiteNode)this.siteTree.getRoot(), defaultNode);
        if (this.selectedSiteNode != null) {
            TreePath path = new TreePath(this.siteTree.getPathToRoot(this.selectedSiteNode));
            this.getTreeSite().setExpandsSelectedPaths(true);
            this.getTreeSite().setSelectionPath(path);
            this.getTreeSite().scrollPathToVisible(path);
            this.getTreeSite().expandPath(path);
        } else {
            TreePath path = new TreePath(this.siteTree.getPathToRoot((TreeNode)this.siteTree.getRoot()));
            this.getTreeSite().expandPath(path);
        }
        this.setVisible(true);
        return this.selectedSiteNode;
    }

    public Target showDialog(Target defaultTarget) {
        this.getTreeContext().setVisible(true);
        SiteNode siteRoot = Model.getSingleton().getSession().getSiteTree().getRoot();
        this.populateContexts((SiteNode)this.contextTree.getRoot());
        if (defaultTarget != null) {
            this.populateNode(siteRoot, (SiteNode)this.siteTree.getRoot(), defaultTarget.getStartNode());
        } else {
            this.populateNode(siteRoot, (SiteNode)this.siteTree.getRoot(), null);
        }
        if (this.selectedSiteNode != null) {
            TreePath path = new TreePath(this.siteTree.getPathToRoot(this.selectedSiteNode));
            this.getTreeSite().setExpandsSelectedPaths(true);
            this.getTreeSite().setSelectionPath(path);
            this.getTreeSite().scrollPathToVisible(path);
            this.getTreeSite().expandPath(path);
        } else {
            TreePath path = new TreePath(this.siteTree.getPathToRoot((TreeNode)this.siteTree.getRoot()));
            this.getTreeSite().expandPath(path);
        }
        this.setVisible(true);
        if (this.selectedSiteNode != null) {
            return new Target(this.selectedSiteNode);
        }
        return this.selectedTarget;
    }

    private void populateContexts(SiteNode root) {
        int contextsInScope = 0;
        for (Context ctx : Model.getSingleton().getSession().getContexts()) {
            if (ctx.getIncludeInContextRegexs().size() <= 0) continue;
            SiteNode node = new SiteNode(null, 1, ctx.getName());
            node.setUserObject(new Target(ctx));
            root.add(node);
            if (!ctx.isInScope()) continue;
            ++contextsInScope;
        }
        if (contextsInScope > 1) {
            SiteNode node = new SiteNode(null, 1, Constant.messages.getString("context.allInScope"));
            node.setUserObject(new Target(null, null, true, true));
            root.add(node);
        }
        this.getTreeContext().expandRow(0);
    }

    private void populateNode(SiteNode src, SiteNode dest, SiteNode defaultNode) {
        if (src.equals(defaultNode)) {
            this.selectedSiteNode = dest;
        }
        for (int i = 0; i < src.getChildCount(); ++i) {
            SiteNode child = (SiteNode)src.getChildAt(i);
            SiteNode copy = new SiteNode(null, 1, child.getNodeName());
            copy.setUserObject(child);
            dest.add(copy);
            this.populateNode(child, copy, defaultNode);
        }
    }

    private DefaultTreeModel emptyContextTree() {
        return new DefaultTreeModel(new SiteNode(null, -1, Constant.messages.getString("context.list")));
    }

    private DefaultTreeModel emptySiteTree() {
        SiteNode siteRoot = Model.getSingleton().getSession().getSiteTree().getRoot();
        SiteNode root = new SiteNode(null, -1, Constant.messages.getString("tab.sites"));
        root.setUserObject(siteRoot);
        return new DefaultTreeModel(root);
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            GridBagConstraints gridBagConstraints15 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints13 = new GridBagConstraints();
            JLabel jLabel2 = new JLabel();
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            this.jPanel = new JPanel();
            this.jPanel.setLayout(new GridBagLayout());
            this.jPanel.setPreferredSize(DisplayUtils.getScaledDimension(400, 400));
            this.jPanel.setMinimumSize(DisplayUtils.getScaledDimension(400, 400));
            gridBagConstraints2.gridx = 1;
            gridBagConstraints2.gridy = 5;
            gridBagConstraints2.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints2.anchor = 13;
            gridBagConstraints3.gridx = 2;
            gridBagConstraints3.gridy = 5;
            gridBagConstraints3.insets = new Insets(2, 2, 2, 10);
            gridBagConstraints3.anchor = 13;
            gridBagConstraints13.gridx = 0;
            gridBagConstraints13.gridy = 5;
            gridBagConstraints13.fill = 2;
            gridBagConstraints13.weightx = 1.0;
            gridBagConstraints13.insets = new Insets(2, 10, 2, 5);
            gridBagConstraints15.weightx = 1.0;
            gridBagConstraints15.weighty = 1.0;
            gridBagConstraints15.fill = 1;
            gridBagConstraints15.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints15.gridwidth = 3;
            gridBagConstraints15.gridx = 0;
            gridBagConstraints15.gridy = 2;
            gridBagConstraints15.anchor = 18;
            gridBagConstraints15.ipadx = 0;
            gridBagConstraints15.ipady = 10;
            this.jPanel.add((Component)new ContextsSitesPanel(this.getTreeContext(), this.getTreeSite()), gridBagConstraints15);
            this.jPanel.add((Component)jLabel2, gridBagConstraints13);
            this.jPanel.add((Component)this.getCancelButton(), gridBagConstraints2);
            this.jPanel.add((Component)this.getSelectButton(), gridBagConstraints3);
        }
        return this.jPanel;
    }

    private JTree getTreeSite() {
        if (this.treeSite == null) {
            this.siteTree = this.emptySiteTree();
            this.treeSite = new JTree(this.siteTree);
            this.treeSite.setShowsRootHandles(true);
            this.treeSite.setName("nodeSelectTree");
            this.treeSite.setToggleClickCount(1);
            this.treeSite.getSelectionModel().setSelectionMode(1);
            this.treeSite.addTreeSelectionListener(new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent e) {
                    SiteNode node = (SiteNode)NodeSelectDialog.this.treeSite.getLastSelectedPathComponent();
                    NodeSelectDialog.this.getSelectButton().setEnabled(node != null && (node.getParent() != null || NodeSelectDialog.this.allowRoot));
                }
            });
            this.treeSite.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    this.mouseClicked(e);
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (NodeSelectDialog.this.treeSite.getLastSelectedPathComponent() != null) {
                        NodeSelectDialog.this.getTreeContext().clearSelection();
                    }
                    if (e.getClickCount() > 1) {
                        NodeSelectDialog.this.nodeSelected();
                    }
                }
            });
            this.treeSite.setCellRenderer(new SiteMapTreeCellRenderer(new ArrayList<SiteMapListener>()));
        }
        return this.treeSite;
    }

    private void nodeSelected() {
        SiteNode node = (SiteNode)this.treeSite.getLastSelectedPathComponent();
        if (node != null && (node.getParent() != null || this.allowRoot)) {
            this.selectedSiteNode = (SiteNode)node.getUserObject();
            this.selectedTarget = null;
            this.setVisible(false);
        }
    }

    private void contextSelected() {
        SiteNode node = (SiteNode)this.treeContext.getLastSelectedPathComponent();
        if (node != null && (node.getParent() != null || this.allowRoot)) {
            this.selectedTarget = (Target)node.getUserObject();
            this.selectedSiteNode = null;
            this.setVisible(false);
        }
    }

    private JTree getTreeContext() {
        if (this.treeContext == null) {
            this.contextTree = this.emptyContextTree();
            this.treeContext = new JTree(this.contextTree);
            this.treeContext.setShowsRootHandles(true);
            this.treeContext.setName("nodeContextTree");
            this.treeContext.setToggleClickCount(1);
            this.treeContext.getSelectionModel().setSelectionMode(1);
            this.treeContext.addTreeSelectionListener(new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent e) {
                    SiteNode node = (SiteNode)NodeSelectDialog.this.treeContext.getLastSelectedPathComponent();
                    NodeSelectDialog.this.getSelectButton().setEnabled(node != null && (node.getParent() != null || NodeSelectDialog.this.allowRoot));
                }
            });
            this.treeContext.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    this.mouseClicked(e);
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (NodeSelectDialog.this.treeContext.getLastSelectedPathComponent() != null) {
                        NodeSelectDialog.this.getTreeSite().clearSelection();
                    }
                    if (e.getClickCount() > 1) {
                        NodeSelectDialog.this.contextSelected();
                    }
                }
            });
            this.treeContext.setCellRenderer(new ContextsTreeCellRenderer());
        }
        return this.treeContext;
    }

    private JButton getSelectButton() {
        if (this.selectButton == null) {
            this.selectButton = new JButton();
            this.selectButton.setText(Constant.messages.getString("siteselect.button.select"));
            this.selectButton.setEnabled(false);
            this.selectButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (NodeSelectDialog.this.treeSite.getLastSelectedPathComponent() != null) {
                        NodeSelectDialog.this.nodeSelected();
                    } else if (NodeSelectDialog.this.treeContext.getLastSelectedPathComponent() != null) {
                        NodeSelectDialog.this.contextSelected();
                    }
                }
            });
        }
        return this.selectButton;
    }

    private JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton();
            this.cancelButton.setText(Constant.messages.getString("all.button.cancel"));
            this.cancelButton.setEnabled(true);
            this.cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    NodeSelectDialog.this.selectedSiteNode = null;
                    NodeSelectDialog.this.selectedTarget = null;
                    NodeSelectDialog.this.setVisible(false);
                }
            });
        }
        return this.cancelButton;
    }

    public boolean isAllowRoot() {
        return this.allowRoot;
    }

    public void setAllowRoot(boolean allowRoot) {
        this.allowRoot = allowRoot;
    }
}

