/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.dex2jar.ir.ts.array;

import com.googlecode.dex2jar.ir.IrMethod;
import com.googlecode.dex2jar.ir.expr.ArrayExpr;
import com.googlecode.dex2jar.ir.expr.Constant;
import com.googlecode.dex2jar.ir.expr.Exprs;
import com.googlecode.dex2jar.ir.expr.FieldExpr;
import com.googlecode.dex2jar.ir.expr.Local;
import com.googlecode.dex2jar.ir.expr.Value;
import com.googlecode.dex2jar.ir.stmt.Stmt;
import com.googlecode.dex2jar.ir.stmt.StmtList;
import com.googlecode.dex2jar.ir.stmt.Stmts;
import com.googlecode.dex2jar.ir.ts.Transformer;
import java.util.ArrayList;
import java.util.List;

public class ArrayNullPointerTransformer
implements Transformer {
    @Override
    public void transform(IrMethod irMethod) {
        Stmt p = irMethod.stmts.getFirst();
        while (p != null) {
            if (this.arrayNPE(p)) {
                Stmt q = p.getNext();
                this.replaceNPE(irMethod.stmts, irMethod.locals, p);
                p = q;
                continue;
            }
            p = p.getNext();
        }
    }

    private void replaceNPE(StmtList stmts, List<Local> locals, Stmt p) {
        ArrayList<Value> values = new ArrayList<Value>();
        block0 : switch (p.et) {
            case E1: {
                this.tryAdd(((Stmt.E1Stmt)p).op.trim(), values);
                break;
            }
            case E2: {
                Stmt.E2Stmt e2 = (Stmt.E2Stmt)p;
                switch (e2.op1.trim().vt) {
                    case LOCAL: {
                        this.tryAdd(e2.op2.trim(), values);
                        break block0;
                    }
                    case ARRAY: {
                        ArrayExpr ae = (ArrayExpr)e2.op1.trim();
                        if (!this.tryAdd(ae.op1.trim(), values) || !this.tryAdd(ae.op2.trim(), values)) break block0;
                        this.tryAdd(e2.op2.trim(), values);
                        break block0;
                    }
                    case FIELD: {
                        FieldExpr fe = (FieldExpr)e2.op1.trim();
                        if (fe.op != null && fe.op.trim() != null && !this.tryAdd(fe.op.trim(), values)) break block0;
                        this.tryAdd(e2.op2.trim(), values);
                        break block0;
                    }
                }
                if (!this.tryAdd(e2.op2.trim(), values)) break;
                this.tryAdd(e2.op1.trim(), values);
            }
        }
        for (Value value : values) {
            switch (value.vt) {
                case CONSTANT: 
                case LOCAL: {
                    break;
                }
                default: {
                    Local n = Exprs.nLocal("xxx");
                    locals.add(n);
                    stmts.insertBefore(p, Stmts.nAssign(n, value));
                }
            }
        }
        stmts.insertBefore(p, Stmts.nThrow(Exprs.nInvokeNew(new Value[0], new String[0], "Ljava/lang/NullPointerException;")));
        stmts.remove(p);
    }

    private boolean tryAdd(Value value, List<Value> values) {
        if (!this.arrayNPE(value)) {
            values.add(value);
            return true;
        }
        block0 : switch (value.et) {
            case E0: {
                values.add(value);
                break;
            }
            case E1: {
                Value.E1Expr e1 = (Value.E1Expr)value;
                if (e1.op == null || e1.op.trim() == null) {
                    return false;
                }
                this.tryAdd(e1.op.trim(), values);
                break;
            }
            case E2: {
                Value.E2Expr e2 = (Value.E2Expr)value;
                if (e2.vt == Value.VT.ARRAY && e2.op1.trim().vt == Value.VT.CONSTANT) {
                    Constant cst = (Constant)e2.op1.trim();
                    if (cst.value.equals(0)) {
                        this.tryAdd(e2.op2.trim(), values);
                        return false;
                    }
                }
                if (this.tryAdd(e2.op1.trim(), values)) {
                    this.tryAdd(e2.op2.trim(), values);
                }
            }
            case En: {
                Value[] valueArray = ((Value.EnExpr)value).ops;
                int n = ((Value.EnExpr)value).ops.length;
                int n2 = 0;
                while (n2 < n) {
                    Value vb = valueArray[n2];
                    if (!this.tryAdd(vb.trim(), values)) break block0;
                    ++n2;
                }
                break;
            }
        }
        return false;
    }

    private boolean arrayNPE(Stmt p) {
        switch (p.et) {
            case E0: {
                return false;
            }
            case E1: {
                if (p.st == Stmt.ST.GOTO) {
                    return false;
                }
                return this.arrayNPE(((Stmt.E1Stmt)p).op.trim());
            }
            case E2: {
                Stmt.E2Stmt e2 = (Stmt.E2Stmt)p;
                switch (e2.op1.trim().vt) {
                    case ARRAY: 
                    case FIELD: {
                        return this.arrayNPE(e2.op1.trim()) || this.arrayNPE(e2.op2.trim());
                    }
                }
                return this.arrayNPE(e2.op2.trim()) || this.arrayNPE(e2.op1.trim());
            }
            case En: {
                return false;
            }
        }
        return false;
    }

    private boolean arrayNPE(Value value) {
        switch (value.et) {
            case E0: {
                return false;
            }
            case E1: {
                Value.E1Expr e1 = (Value.E1Expr)value;
                if (e1.op == null || e1.op.trim() == null) {
                    return false;
                }
                return this.arrayNPE(e1.op.trim());
            }
            case E2: {
                Value.E2Expr e2 = (Value.E2Expr)value;
                if (e2.vt == Value.VT.ARRAY && e2.op1.trim().vt == Value.VT.CONSTANT) {
                    Constant cst = (Constant)e2.op1.trim();
                    if (cst.value.equals(0)) {
                        return true;
                    }
                }
                return this.arrayNPE(e2.op1.trim()) || this.arrayNPE(e2.op2.trim());
            }
            case En: {
                Value[] valueArray = ((Value.EnExpr)value).ops;
                int n = ((Value.EnExpr)value).ops.length;
                int n2 = 0;
                while (n2 < n) {
                    Value vb = valueArray[n2];
                    if (this.arrayNPE(vb.trim())) {
                        return true;
                    }
                    ++n2;
                }
                break;
            }
        }
        return false;
    }
}

