/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider.serialization;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.io.IOUtils;
import org.gradle.internal.Cast;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.io.StreamByteBuffer;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;
import org.gradle.tooling.internal.provider.serialization.ClassLoaderDetails;
import org.gradle.tooling.internal.provider.serialization.DeserializeMap;
import org.gradle.tooling.internal.provider.serialization.PayloadClassLoaderRegistry;
import org.gradle.tooling.internal.provider.serialization.PayloadSerializerObjectInputStream;
import org.gradle.tooling.internal.provider.serialization.PayloadSerializerObjectOutputStream;
import org.gradle.tooling.internal.provider.serialization.SerializeMap;
import org.gradle.tooling.internal.provider.serialization.SerializedPayload;

@ServiceScope(value={Scope.UserHome.class})
@ThreadSafe
public class PayloadSerializer {
    private final PayloadClassLoaderRegistry classLoaderRegistry;

    public PayloadSerializer(PayloadClassLoaderRegistry registry) {
        this.classLoaderRegistry = registry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SerializedPayload serialize(@Nullable Object payload) {
        if (payload == null) {
            return new SerializedPayload(null, Collections.<byte[]>emptyList());
        }
        SerializeMap map = this.classLoaderRegistry.newSerializeSession();
        try {
            StreamByteBuffer buffer = new StreamByteBuffer();
            PayloadSerializerObjectOutputStream objectStream = new PayloadSerializerObjectOutputStream(buffer.getOutputStream(), map);
            try {
                objectStream.writeObject(payload);
            }
            finally {
                IOUtils.closeQuietly((OutputStream)objectStream);
            }
            HashMap<Short, ClassLoaderDetails> classLoaders = new HashMap<Short, ClassLoaderDetails>();
            map.collectClassLoaderDefinitions(classLoaders);
            return new SerializedPayload(classLoaders, buffer.readAsListOfByteArrays());
        }
        catch (IOException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }

    @Nullable
    public Object deserialize(SerializedPayload payload) {
        if (payload.getSerializedModel().isEmpty()) {
            return null;
        }
        DeserializeMap map = this.classLoaderRegistry.newDeserializeSession();
        try {
            Map classLoaderDetails = (Map)Cast.uncheckedNonnullCast((Object)payload.getHeader());
            StreamByteBuffer buffer = StreamByteBuffer.of(payload.getSerializedModel());
            PayloadSerializerObjectInputStream objectStream = new PayloadSerializerObjectInputStream(buffer.getInputStream(), this.getClass().getClassLoader(), classLoaderDetails, map);
            return objectStream.readObject();
        }
        catch (Exception e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }
}

