/*
 * Decompiled with CFR 0.152.
 */
package org.minidns.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;
import org.minidns.dnsname.DnsName;
import org.minidns.record.SRV;

public class SrvUtil {
    public static List<SRV> sortSrvRecords(Collection<SRV> srvRecords) {
        if (srvRecords.size() == 1 && srvRecords.iterator().next().target.equals(DnsName.ROOT)) {
            return Collections.emptyList();
        }
        TreeMap<Integer, LinkedList<SRV>> buckets = new TreeMap<Integer, LinkedList<SRV>>();
        for (SRV srvRecord : srvRecords) {
            Integer priority = srvRecord.priority;
            LinkedList<SRV> bucket = (LinkedList<SRV>)buckets.get(priority);
            if (bucket == null) {
                bucket = new LinkedList<SRV>();
                buckets.put(priority, bucket);
            }
            bucket.add(srvRecord);
        }
        ArrayList<SRV> sortedSrvRecords = new ArrayList<SRV>(srvRecords.size());
        for (List bucket : buckets.values()) {
            int bucketSize;
            while ((bucketSize = bucket.size()) > 0) {
                int selectedPosition;
                int[] totals = new int[bucketSize];
                int zeroWeight = 1;
                for (SRV srv : bucket) {
                    if (srv.weight <= 0) continue;
                    zeroWeight = 0;
                    break;
                }
                int bucketWeightSum = 0;
                int count = 0;
                for (SRV srv : bucket) {
                    totals[count++] = bucketWeightSum += srv.weight + zeroWeight;
                }
                if (bucketWeightSum == 0) {
                    selectedPosition = (int)(Math.random() * (double)bucketSize);
                } else {
                    double rnd = Math.random() * (double)bucketWeightSum;
                    selectedPosition = SrvUtil.bisect(totals, rnd);
                }
                SRV choosenSrvRecord = (SRV)bucket.remove(selectedPosition);
                sortedSrvRecords.add(choosenSrvRecord);
            }
        }
        return sortedSrvRecords;
    }

    private static int bisect(int[] array, double value2) {
        int pos = 0;
        for (int element : array) {
            if (value2 < (double)element) break;
            ++pos;
        }
        return pos;
    }
}

