/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.srtp.crypto;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import org.jitsi.srtp.crypto.OpenSslAesCipherSpi;

public final class OpenSslAesCtrCipherSpi
extends OpenSslAesCipherSpi {
    private static native long EVP_aes_128_ctr();

    private static native long EVP_aes_192_ctr();

    private static native long EVP_aes_256_ctr();

    public OpenSslAesCtrCipherSpi() {
        super("CTR");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void engineInit(int opmode, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (params == null) throw new InvalidAlgorithmParameterException("IV parameter missing");
        if (!(params instanceof IvParameterSpec)) throw new InvalidAlgorithmParameterException("Unsupported parameter: " + params);
        this.iv = ((IvParameterSpec)params).getIV();
        if (this.iv.length != 16) {
            throw new InvalidAlgorithmParameterException("Unsupported IV length: must be 16 bytes");
        }
        this.doEngineInit(opmode, key);
    }

    @Override
    protected long getOpenSSLCipher(Key key) throws InvalidKeyException {
        switch (key.getEncoded().length) {
            case 16: {
                return OpenSslAesCtrCipherSpi.EVP_aes_128_ctr();
            }
            case 24: {
                return OpenSslAesCtrCipherSpi.EVP_aes_192_ctr();
            }
            case 32: {
                return OpenSslAesCtrCipherSpi.EVP_aes_256_ctr();
            }
        }
        throw new InvalidKeyException("Invalid AES key length: " + key.getEncoded().length + " bytes");
    }
}

