/* [config]
 * expect_result: pass
 * glsl_version: 1.30
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (uvec4(66u, 72u, 87u, 75u) ^ uvec4(66u, 72u, 87u, 75u)) => uvec4(0u, 0u, 0u, 0u)
 * (uvec4(66u, 72u, 87u, 75u) ^ uvec4(24u, 40u, 23u, 74u)) => uvec4(90u, 96u, 64u, 1u)
 * (uvec4(24u, 40u, 23u, 74u) ^ uvec4(66u, 72u, 87u, 75u)) => uvec4(90u, 96u, 64u, 1u)
 * (uvec4(24u, 40u, 23u, 74u) ^ uvec4(24u, 40u, 23u, 74u)) => uvec4(0u, 0u, 0u, 0u)
 */
#version 130

void main()
{
  float[all(equal((uvec4(66u, 72u, 87u, 75u) ^ uvec4(66u, 72u, 87u, 75u)), uvec4(0u, 0u, 0u, 0u))) ? 1 : -1] array0;
  float[all(equal((uvec4(66u, 72u, 87u, 75u) ^ uvec4(24u, 40u, 23u, 74u)), uvec4(90u, 96u, 64u, 1u))) ? 1 : -1] array1;
  float[all(equal((uvec4(24u, 40u, 23u, 74u) ^ uvec4(66u, 72u, 87u, 75u)), uvec4(90u, 96u, 64u, 1u))) ? 1 : -1] array2;
  float[all(equal((uvec4(24u, 40u, 23u, 74u) ^ uvec4(24u, 40u, 23u, 74u)), uvec4(0u, 0u, 0u, 0u))) ? 1 : -1] array3;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length());
}
