/*
 * Decompiled with CFR 0.152.
 */
package tr.view.actions.screens;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import org.openide.util.NbBundle;
import tr.util.Observable;
import tr.util.Observer;
import tr.view.actions.screens.ActionsScreen;
import tr.view.actions.screens.columns.ActionsColumn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColumnsTableModel
extends AbstractTableModel
implements Observer {
    private static final Logger LOG = Logger.getLogger("tr.view.actions");
    private Map<Byte, ActionsColumn> rowMap;
    private static final int[] maxwidths = new int[]{-1, -1};
    private static final int[] minwidths = new int[]{-1, 50};
    private static final int[] prewidths = new int[]{-1, 70};
    private static final Class[] classes = new Class[]{String.class, Boolean.class};
    private static final TableCellRenderer[] renderers = new TableCellRenderer[]{null, null};
    private static final String[] headings = new String[]{ColumnsTableModel.getText("ColumnsDialog.column.column"), ColumnsTableModel.getText("ColumnsDialog.column.visible")};
    private static final byte COLUMN_COLUMN = 0;
    private static final byte COLUMN_VISIBLE = 1;
    private final ActionsScreen actionsScreen;

    public ColumnsTableModel(ActionsScreen actionsScreen) {
        this.actionsScreen = actionsScreen;
        this.actionsScreen.addObserver(this);
    }

    public TableCellRenderer getTableCellRenderer(int column) {
        return renderers[column];
    }

    public int getMaximumWidth(int column) {
        return maxwidths[column];
    }

    public int getMinimumWidth(int column) {
        return minwidths[column];
    }

    public int getPreferredWidth(int column) {
        return prewidths[column];
    }

    @Override
    public int getColumnCount() {
        return classes.length;
    }

    @Override
    public String getColumnName(int column) {
        return headings[column];
    }

    @Override
    public Class<?> getColumnClass(int column) {
        return classes[column];
    }

    @Override
    public int getRowCount() {
        return ActionsColumn.COLUMN_INDICES.length;
    }

    private Map<Byte, ActionsColumn> getRowMap() {
        if (this.rowMap == null) {
            this.rowMap = new HashMap<Byte, ActionsColumn>();
            for (ActionsColumn ac : this.actionsScreen.getColumns().list()) {
                this.rowMap.put(ac.getColumnIndex(), ac);
            }
            for (byte index : ActionsColumn.COLUMN_INDICES) {
                if (this.rowMap.containsKey(index)) continue;
                ActionsColumn ac = ActionsColumn.createColumn(index);
                this.actionsScreen.getColumns().add((Observable)ac);
                this.rowMap.put(index, ac);
            }
        }
        return this.rowMap;
    }

    @Override
    public Object getValueAt(int row, int column) {
        byte index = ActionsColumn.COLUMN_INDICES[row];
        ActionsColumn ac = this.getRowMap().get(index);
        if (ac == null) {
            return "";
        }
        switch (column) {
            case 1: {
                return ac.isVisible();
            }
            case 0: {
                return ac.toString();
            }
        }
        return "";
    }

    @Override
    public void setValueAt(Object object, int row, int column) {
        LOG.fine("SetValueAt: row = " + row + " col = " + column);
        if (column == 1 && object instanceof Boolean) {
            boolean visible = (Boolean)object;
            byte index = ActionsColumn.COLUMN_INDICES[row];
            if (index == 2 && !visible) {
                return;
            }
            ActionsColumn actionsColumn = this.getRowMap().get(index);
            if (actionsColumn != null) {
                actionsColumn.setVisible(visible);
            }
        }
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return column == 1;
    }

    public void update(Observable o, Object arg) {
        this.fireTableDataChanged();
    }

    private static String getText(String key) {
        return NbBundle.getMessage(ColumnsTableModel.class, (String)key);
    }
}

