/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.layout;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import org.netbeans.api.visual.layout.Layout;
import org.netbeans.api.visual.layout.LayoutFactory;
import org.netbeans.api.visual.widget.Widget;

public final class FlowLayout
implements Layout {
    private boolean verticalOrientation;
    private LayoutFactory.SerialAlignment alignment;
    private int gap;

    public FlowLayout(boolean bl, LayoutFactory.SerialAlignment serialAlignment, int n) {
        this.verticalOrientation = bl;
        this.alignment = serialAlignment;
        this.gap = n;
    }

    public void layout(Widget widget) {
        int n = 0;
        List<Widget> list = widget.getChildren();
        if (this.verticalOrientation) {
            for (Widget object : list) {
                if (!object.isVisible()) continue;
                Rectangle rectangle = object.getPreferredBounds();
                int n2 = rectangle.width;
                if (n2 <= n) continue;
                n = n2;
            }
            int n3 = 0;
            for (Widget widget2 : list) {
                Rectangle rectangle = widget2.getPreferredBounds();
                int n4 = rectangle.x;
                int n5 = rectangle.y;
                int n6 = rectangle.width;
                int n7 = rectangle.height;
                int n8 = -n4;
                int n9 = n3 - n5;
                switch (this.alignment) {
                    case CENTER: {
                        n8 += (n - n6) / 2;
                        break;
                    }
                    case JUSTIFY: {
                        n6 = n;
                        break;
                    }
                    case LEFT_TOP: {
                        break;
                    }
                    case RIGHT_BOTTOM: {
                        n8 += n - n6;
                    }
                }
                if (widget2.isVisible()) {
                    widget2.resolveBounds(new Point(n8, n9), new Rectangle(n4, n5, n6, n7));
                    n3 += n7 + this.gap;
                    continue;
                }
                widget2.resolveBounds(new Point(n8, n9), new Rectangle(n4, n5, 0, 0));
            }
        } else {
            for (Widget widget3 : list) {
                if (!widget3.isVisible()) continue;
                Rectangle rectangle = widget3.getPreferredBounds();
                int n10 = rectangle.height;
                if (n10 <= n) continue;
                n = n10;
            }
            int n11 = 0;
            for (Widget widget4 : list) {
                Rectangle rectangle = widget4.getPreferredBounds();
                int n12 = rectangle.x;
                int n13 = rectangle.y;
                int n14 = rectangle.width;
                int n15 = rectangle.height;
                int n16 = n11 - n12;
                int n17 = -n13;
                switch (this.alignment) {
                    case CENTER: {
                        n17 += (n - n15) / 2;
                        break;
                    }
                    case JUSTIFY: {
                        n15 = n;
                        break;
                    }
                    case LEFT_TOP: {
                        break;
                    }
                    case RIGHT_BOTTOM: {
                        n17 += n - n15;
                    }
                }
                if (widget4.isVisible()) {
                    widget4.resolveBounds(new Point(n16, n17), new Rectangle(n12, n13, n14, n15));
                    n11 += n14 + this.gap;
                    continue;
                }
                widget4.resolveBounds(new Point(n16, n17), new Rectangle(n12, n13, 0, 0));
            }
        }
    }

    public boolean requiresJustification(Widget widget) {
        return true;
    }

    public void justify(Widget widget) {
        int n;
        Rectangle rectangle = widget.getClientArea();
        int n2 = 0;
        int n3 = 0;
        List<Widget> list = widget.getChildren();
        for (n = 0; n < list.size(); ++n) {
            Widget widget2 = list.get(n);
            if (!widget2.isVisible()) continue;
            n2 += FlowLayout.resolveWeight(widget, widget2);
            if (n > 0) {
                n3 -= this.gap;
            }
            if (this.verticalOrientation) {
                n3 -= widget2.getBounds().height;
                continue;
            }
            n3 -= widget2.getBounds().width;
        }
        if ((n3 += this.verticalOrientation ? rectangle.height : rectangle.width) < 0) {
            n3 = 0;
            n2 = 0;
        }
        n = 0;
        int n4 = 0;
        int n5 = rectangle.x;
        int n6 = n5 + rectangle.width;
        int n7 = rectangle.y;
        int n8 = n7 + rectangle.height;
        for (Widget widget3 : widget.getChildren()) {
            int n9;
            int n10;
            Point point = widget3.getLocation();
            Rectangle rectangle2 = widget3.getBounds();
            if (this.verticalOrientation) {
                switch (this.alignment) {
                    case CENTER: {
                        point.x = (n5 + n6 - rectangle2.width) / 2;
                        break;
                    }
                    case JUSTIFY: {
                        point.x = n5;
                        rectangle2.width = n6 - n5;
                        break;
                    }
                    case LEFT_TOP: {
                        point.x = n5;
                        break;
                    }
                    case RIGHT_BOTTOM: {
                        point.x = n6 - rectangle2.width;
                    }
                }
                if (n2 > 0 && widget3.isVisible()) {
                    point.y += n;
                    n10 = FlowLayout.resolveWeight(widget, widget3);
                    n9 = (n4 + n10) * n3 / n2;
                    rectangle2.height += n9 - n;
                    n = n9;
                    n4 += n10;
                }
                point.x -= rectangle2.x;
                point.y += n7;
            } else {
                switch (this.alignment) {
                    case CENTER: {
                        point.y = (n7 + n8 - rectangle2.height) / 2;
                        break;
                    }
                    case JUSTIFY: {
                        point.y = n7;
                        rectangle2.height = n8 - n7;
                        break;
                    }
                    case LEFT_TOP: {
                        point.y = n7;
                        break;
                    }
                    case RIGHT_BOTTOM: {
                        point.y = n8 - rectangle2.height;
                    }
                }
                if (n2 > 0 && widget3.isVisible()) {
                    point.x += n;
                    n10 = FlowLayout.resolveWeight(widget, widget3);
                    n9 = (n4 + n10) * n3 / n2;
                    rectangle2.width += n9 - n;
                    n = n9;
                    n4 += n10;
                }
                point.y -= rectangle2.y;
                point.x += n5;
            }
            widget3.resolveBounds(point, rectangle2);
        }
    }

    private static int resolveWeight(Widget widget, Widget widget2) {
        int n;
        Object object = widget.getChildConstraint(widget2);
        if (object instanceof Number && (n = ((Number)object).intValue()) > 0) {
            return n;
        }
        return 0;
    }
}

