//
//  myplugin.c
//  
//
//  Created by Parker, Charles W. on 1/25/17.
//
//  Build from pcb/src with:
//  Linux:
//  gcc -fPIC -shared -o myplugin.so \
//       myplugin.c -I.. -I/opt/local/include/glib-2.0 \
//       -I/opt/local/lib/glib-2.0/include -DHAVE_CONFIG_H
//  MacOS:
//  gcc -fPIC -dynamiclib -Wl,-undefined,dynamic_lookup -o myplugin.so \
//       myplugin.c -I.. -I/opt/local/include/glib-2.0 \
//       -I/opt/local/lib/glib-2.0/include -DHAVE_CONFIG_H
//
//  Make sure that the resulting shared object file (dynamic library) produces
//  the following output from the "file" function:
//  $ file myplugin.so
//  Linux:
//  myplugin.so: ELF 64-bit LSB shared object, x86-64, version 1 (SYSV), dynamically linked, with debug_info, not stripped
//  MacOS:
//  myplugin.so: Mach-O 64-bit dynamically linked shared library x86_64
//
//

#include <stdio.h>

#include "globalconst.h"
#include "global.h" // types

#include "error.h" // Message
#include "hid.h"   // REGISTER_ACTIONS

static int
myplugin_action (int argc, char **argv, Coord x, Coord y)
{
  int i = 0;
  Message("Hello from your new plugin!\n");
  if ((argc == 2) && (strcmp(argv[0], "Echo") == 0))
  {
    Message("Echoing: %s\n", argv[1]);
  }
  
  return 0;
}

static HID_Action myplugin_action_list[] =
{
  {"PluginAction", NULL, myplugin_action, NULL, NULL}
};

REGISTER_ACTIONS (myplugin_action_list)

void
pcb_plugin_init()
{
  printf("Loading plugin: myplugin\n");
  register_myplugin_action_list();
}
