/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.sqlserver;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.util.Properties;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.auth.sqlserver.conf.SQLServerDriver;
import org.apache.guacamole.auth.sqlserver.conf.SQLServerEnvironment;
import org.apache.guacamole.properties.CaseSensitivity;
import org.mybatis.guice.datasource.helper.JdbcHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLServerAuthenticationProviderModule
implements Module {
    private static final Logger LOGGER = LoggerFactory.getLogger(SQLServerAuthenticationProviderModule.class);
    private final Properties myBatisProperties = new Properties();
    private final Properties driverProperties = new Properties();
    private final SQLServerDriver sqlServerDriver;

    public SQLServerAuthenticationProviderModule(SQLServerEnvironment environment) throws GuacamoleException {
        String instance;
        this.myBatisProperties.setProperty("mybatis.environment.id", "guacamole");
        this.myBatisProperties.setProperty("JDBC.host", environment.getSQLServerHostname());
        this.myBatisProperties.setProperty("JDBC.port", String.valueOf(environment.getSQLServerPort()));
        this.myBatisProperties.setProperty("JDBC.schema", environment.getSQLServerDatabase());
        this.myBatisProperties.setProperty("JDBC.autoCommit", "false");
        this.myBatisProperties.setProperty("mybatis.pooled.pingEnabled", "true");
        this.myBatisProperties.setProperty("mybatis.pooled.pingQuery", "SELECT 1");
        this.driverProperties.setProperty("characterEncoding", "UTF-8");
        if (environment.trustAllServerCertificates()) {
            this.driverProperties.setProperty("trustServerCertificate", "true");
        }
        if ((instance = environment.getSQLServerInstance()) != null) {
            this.driverProperties.setProperty("JDBC.instanceName", instance);
        }
        this.sqlServerDriver = environment.getSQLServerDriver();
        if (environment.getCaseSensitivity() != CaseSensitivity.DISABLED) {
            LOGGER.warn("The SQL Server module is currently configured to support case-sensitive username comparisons, however, the default collations for SQL Server databases do not support case-sensitive string comparisons. If you want usernames within Guacamole to be treated as case-sensitive, further database configuration may be required.");
        }
    }

    public void configure(Binder binder) {
        switch (this.sqlServerDriver) {
            case JTDS: {
                JdbcHelper.SQL_Server_jTDS.configure(binder);
                break;
            }
            case DATA_DIRECT: {
                JdbcHelper.SQL_Server_DataDirect.configure(binder);
                break;
            }
            case MICROSOFT_LEGACY: {
                JdbcHelper.SQL_Server_MS_Driver.configure(binder);
                break;
            }
            case MICROSOFT_2005: {
                JdbcHelper.SQL_Server_2005_MS_Driver.configure(binder);
                break;
            }
            default: {
                throw new UnsupportedOperationException("A driver has been specified that is not supported by this module.");
            }
        }
        Names.bindProperties((Binder)binder, (Properties)this.myBatisProperties);
        binder.bind(Properties.class).annotatedWith((Annotation)Names.named((String)"JDBC.driverProperties")).toInstance((Object)this.driverProperties);
    }
}

