%% Generated by lilypond-book
%% Options: [exampleindent=10.16\mm,indent=0\mm,line-width=160\mm]
\include "lilypond-book-preamble.ly"


% ****************************************************************
% Start cut-&-pastable-section
% ****************************************************************

#(ly:set-option 'eps-box-padding 3.000000)



\paper {
  indent = 0\mm
  line-width = 160\mm
  % offset the left padding, also add 1mm as lilypond creates cropped
  % images with a little space on the right
  line-width = #(- line-width (* mm  3.000000) (* mm 1))
}

\layout {
  
}




% ****************************************************************
% ly snippet:
% ****************************************************************
\sourcefilename "snippets/three-sided-box.ly"
\sourcefileline 0
%% DO NOT EDIT this file manually; it was automatically
%% generated from the LilyPond Snippet Repository
%% (http://lsr.di.unimi.it).
%%
%% Make any changes in the LSR itself, or in
%% `Documentation/snippets/new/`, then run
%% `scripts/auxiliar/makelsr.pl`.
%%
%% This file is in the public domain.

\version "2.23.13"

\header {
%% Translation of GIT committish: f11513f36c131dab18338d6a3a729e24a927150d
  texidocja = "
この例は、テキスト (や他のマークアップ) の周りの 3 方向のみを囲う@c
ボックスを作成するマークアップ コマンドを追加する方法を示しています。
"
  doctitleja = "3 方向ボックス"

%% Translation of GIT committish: a3fd5364fc4f247579da0ed2bfea887ab37285c6
  texidocfr = "
Voici comment construire une commande de @emph{markup} chargée
d'agrémenter du texte ou autre annotation, d'une bordure sur trois
côtés.
"

  doctitlefr = "Encadrement sur trois côtés"

%% Translation of GIT committish: 0c00cd98e81b27325bed5891b950fe7f0f0ebe5d
  texidoces = "
Este ejemplo muestra cómo añadir ina instrucción de marcado para
obtener un rectángulo de tres segmentos visibles rodeando un elemento
de texto (u otro elemento de marcado).

"
  doctitlees = "Rectángulo de tres segmentos visibles"

%% Translation of GIT committish: 79c17e0eaedca79e5f7605f5b9f92db27c68e679
  texidocca = "
Aquest exemple mostra com afegir una ordre de marcatge per obtenir
un rectangle de tres segments visibles rodejant un element de text
(o un altre element de marcatge).

"
  doctitleca = "Rectangle de tres segments visibles"

  lsrtags = "rhythms, scheme-language, text"

  texidoc = "
This example shows how to add a markup command to get a three sided box
around some text (or other markup).
"

  doctitle = "Three-sided box"
} % begin verbatim


% New command to add a three sided box, with sides north, west and south
% Based on the box-stencil command defined in scm/stencil.scm
% Note that ";;" is used to comment a line in Scheme
#(define-public (NWS-box-stencil stencil thickness padding)
   "Add a box around STENCIL, producing a new stencil."
   (let* ((x-ext (interval-widen (ly:stencil-extent stencil X) padding))
          (y-ext (interval-widen (ly:stencil-extent stencil Y) padding))
          (y-rule (make-filled-box-stencil (cons 0 thickness) y-ext))
          (x-rule (make-filled-box-stencil
                   (interval-widen x-ext thickness) (cons 0 thickness))))
     ;; (set! stencil (ly:stencil-combine-at-edge stencil X 1 y-rule padding))
     (set! stencil (ly:stencil-combine-at-edge stencil X LEFT y-rule padding))
     (set! stencil (ly:stencil-combine-at-edge stencil Y UP x-rule 0.0))
     (set! stencil (ly:stencil-combine-at-edge stencil Y DOWN x-rule 0.0))
     stencil))

% The corresponding markup command, based on the \box command defined
% in scm/define-markup-commands.scm
#(define-markup-command (NWS-box layout props arg) (markup?)
   #:properties ((thickness 0.1) (font-size 0) (box-padding 0.2))
   "Draw a box round @var{arg}.  Looks at @code{thickness},
@code{box-padding} and @code{font-size} properties to determine line
thickness and padding around the markup."
   (let ((pad (* (magstep font-size) box-padding))
         (m (interpret-markup layout props arg)))
     (NWS-box-stencil m thickness pad)))

% Test it:

\relative c' {
  c1^\markup { \NWS-box ABCD }
  c1^\markup { \NWS-box \note {4} #1.0 }
}



% ****************************************************************
% end ly snippet
% ****************************************************************
