/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.Arrays;
import org.mariadb.jdbc.BlobOutputStream;
import org.mariadb.jdbc.internal.util.exceptions.ExceptionFactory;

public class MariaDbBlob
implements Blob,
Serializable {
    private static final long serialVersionUID = -4736603161284649490L;
    protected byte[] data;
    protected transient int offset;
    protected transient int length;

    public MariaDbBlob() {
        this.data = new byte[0];
        this.offset = 0;
        this.length = 0;
    }

    public MariaDbBlob(byte[] bytes) {
        if (bytes == null) {
            throw new NullPointerException("byte array is null");
        }
        this.data = bytes;
        this.offset = 0;
        this.length = bytes.length;
    }

    public MariaDbBlob(byte[] bytes, int offset, int length) {
        if (bytes == null) {
            throw new NullPointerException("byte array is null");
        }
        this.data = bytes;
        this.offset = offset;
        this.length = Math.min(bytes.length - offset, length);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (this.offset != 0 || this.data.length != this.length) {
            this.data = Arrays.copyOfRange(this.data, this.offset, this.offset + this.length);
            this.offset = 0;
            this.length = 0;
        }
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.offset = 0;
        this.length = this.data.length;
    }

    @Override
    public long length() {
        return this.length;
    }

    @Override
    public byte[] getBytes(long pos, int length) throws SQLException {
        if (pos < 1L) {
            throw ExceptionFactory.INSTANCE.create(String.format("Out of range (position should be > 0, but is %s)", pos));
        }
        int offset = this.offset + (int)(pos - 1L);
        byte[] result = new byte[length];
        System.arraycopy(this.data, offset, result, 0, Math.min(this.length - (int)(pos - 1L), length));
        return result;
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        return this.getBinaryStream(1L, this.length);
    }

    @Override
    public InputStream getBinaryStream(long pos, long length) throws SQLException {
        if (pos < 1L) {
            throw ExceptionFactory.INSTANCE.create("Out of range (position should be > 0)");
        }
        if (pos - 1L > (long)this.length) {
            throw ExceptionFactory.INSTANCE.create("Out of range (position > stream size)");
        }
        if (pos + length - 1L > (long)this.length) {
            throw ExceptionFactory.INSTANCE.create("Out of range (position + length - 1 > streamSize)");
        }
        return new ByteArrayInputStream(this.data, this.offset + (int)pos - 1, (int)length);
    }

    @Override
    public long position(byte[] pattern, long start) throws SQLException {
        if (pattern.length == 0) {
            return 0L;
        }
        if (start < 1L) {
            throw ExceptionFactory.INSTANCE.create(String.format("Out of range (position should be > 0, but is %s)", start));
        }
        if (start > (long)this.length) {
            throw ExceptionFactory.INSTANCE.create("Out of range (start > stream size)");
        }
        block0: for (int i = (int)((long)this.offset + start - 1L); i <= this.offset + this.length - pattern.length; ++i) {
            for (int j = 0; j < pattern.length; ++j) {
                if (this.data[i + j] != pattern[j]) continue block0;
            }
            return i + 1 - this.offset;
        }
        return -1L;
    }

    @Override
    public long position(Blob pattern, long start) throws SQLException {
        byte[] blobBytes = pattern.getBytes(1L, (int)pattern.length());
        return this.position(blobBytes, start);
    }

    @Override
    public int setBytes(long pos, byte[] bytes) throws SQLException {
        if (pos < 1L) {
            throw ExceptionFactory.INSTANCE.create("pos should be > 0, first position is 1.");
        }
        int arrayPos = (int)pos - 1;
        if (this.length > arrayPos + bytes.length) {
            System.arraycopy(bytes, 0, this.data, this.offset + arrayPos, bytes.length);
        } else {
            byte[] newContent = new byte[arrayPos + bytes.length];
            if (Math.min(arrayPos, this.length) > 0) {
                System.arraycopy(this.data, this.offset, newContent, 0, Math.min(arrayPos, this.length));
            }
            System.arraycopy(bytes, 0, newContent, arrayPos, bytes.length);
            this.data = newContent;
            this.length = arrayPos + bytes.length;
            this.offset = 0;
        }
        return bytes.length;
    }

    @Override
    public int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
        if (pos < 1L) {
            throw ExceptionFactory.INSTANCE.create("pos should be > 0, first position is 1.");
        }
        int arrayPos = (int)pos - 1;
        int byteToWrite = Math.min(bytes.length - offset, len);
        if (this.length > arrayPos + byteToWrite) {
            System.arraycopy(bytes, offset, this.data, this.offset + arrayPos, byteToWrite);
        } else {
            byte[] newContent = new byte[arrayPos + byteToWrite];
            if (Math.min(arrayPos, this.length) > 0) {
                System.arraycopy(this.data, this.offset, newContent, 0, Math.min(arrayPos, this.length));
            }
            System.arraycopy(bytes, offset, newContent, arrayPos, byteToWrite);
            this.data = newContent;
            this.length = arrayPos + byteToWrite;
            this.offset = 0;
        }
        return byteToWrite;
    }

    @Override
    public OutputStream setBinaryStream(long pos) throws SQLException {
        if (pos < 1L) {
            throw ExceptionFactory.INSTANCE.create("Invalid position in blob");
        }
        if (this.offset > 0) {
            byte[] tmp = new byte[this.length];
            System.arraycopy(this.data, this.offset, tmp, 0, this.length);
            this.data = tmp;
            this.offset = 0;
        }
        return new BlobOutputStream(this, (int)(pos - 1L) + this.offset);
    }

    @Override
    public void truncate(long len) {
        if (len >= 0L && len < (long)this.length) {
            this.length = (int)len;
        }
    }

    @Override
    public void free() {
        this.data = new byte[0];
        this.offset = 0;
        this.length = 0;
    }
}

