# coding: utf-8

"""
InfluxDB OSS API Service.

The InfluxDB v2 API provides a programmatic interface for all interactions with InfluxDB. Access the InfluxDB API using the `/api/v2/` endpoint.   # noqa: E501

OpenAPI spec version: 2.0.0
Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401


class BucketMetadataManifest(object):
    """NOTE: This class is auto generated by OpenAPI Generator.

    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'organization_id': 'str',
        'organization_name': 'str',
        'bucket_id': 'str',
        'bucket_name': 'str',
        'description': 'str',
        'default_retention_policy': 'str',
        'retention_policies': 'list[RetentionPolicyManifest]'
    }

    attribute_map = {
        'organization_id': 'organizationID',
        'organization_name': 'organizationName',
        'bucket_id': 'bucketID',
        'bucket_name': 'bucketName',
        'description': 'description',
        'default_retention_policy': 'defaultRetentionPolicy',
        'retention_policies': 'retentionPolicies'
    }

    def __init__(self, organization_id=None, organization_name=None, bucket_id=None, bucket_name=None, description=None, default_retention_policy=None, retention_policies=None):  # noqa: E501,D401,D403
        """BucketMetadataManifest - a model defined in OpenAPI."""  # noqa: E501
        self._organization_id = None
        self._organization_name = None
        self._bucket_id = None
        self._bucket_name = None
        self._description = None
        self._default_retention_policy = None
        self._retention_policies = None
        self.discriminator = None

        self.organization_id = organization_id
        self.organization_name = organization_name
        self.bucket_id = bucket_id
        self.bucket_name = bucket_name
        if description is not None:
            self.description = description
        self.default_retention_policy = default_retention_policy
        self.retention_policies = retention_policies

    @property
    def organization_id(self):
        """Get the organization_id of this BucketMetadataManifest.

        :return: The organization_id of this BucketMetadataManifest.
        :rtype: str
        """  # noqa: E501
        return self._organization_id

    @organization_id.setter
    def organization_id(self, organization_id):
        """Set the organization_id of this BucketMetadataManifest.

        :param organization_id: The organization_id of this BucketMetadataManifest.
        :type: str
        """  # noqa: E501
        if organization_id is None:
            raise ValueError("Invalid value for `organization_id`, must not be `None`")  # noqa: E501
        self._organization_id = organization_id

    @property
    def organization_name(self):
        """Get the organization_name of this BucketMetadataManifest.

        :return: The organization_name of this BucketMetadataManifest.
        :rtype: str
        """  # noqa: E501
        return self._organization_name

    @organization_name.setter
    def organization_name(self, organization_name):
        """Set the organization_name of this BucketMetadataManifest.

        :param organization_name: The organization_name of this BucketMetadataManifest.
        :type: str
        """  # noqa: E501
        if organization_name is None:
            raise ValueError("Invalid value for `organization_name`, must not be `None`")  # noqa: E501
        self._organization_name = organization_name

    @property
    def bucket_id(self):
        """Get the bucket_id of this BucketMetadataManifest.

        :return: The bucket_id of this BucketMetadataManifest.
        :rtype: str
        """  # noqa: E501
        return self._bucket_id

    @bucket_id.setter
    def bucket_id(self, bucket_id):
        """Set the bucket_id of this BucketMetadataManifest.

        :param bucket_id: The bucket_id of this BucketMetadataManifest.
        :type: str
        """  # noqa: E501
        if bucket_id is None:
            raise ValueError("Invalid value for `bucket_id`, must not be `None`")  # noqa: E501
        self._bucket_id = bucket_id

    @property
    def bucket_name(self):
        """Get the bucket_name of this BucketMetadataManifest.

        :return: The bucket_name of this BucketMetadataManifest.
        :rtype: str
        """  # noqa: E501
        return self._bucket_name

    @bucket_name.setter
    def bucket_name(self, bucket_name):
        """Set the bucket_name of this BucketMetadataManifest.

        :param bucket_name: The bucket_name of this BucketMetadataManifest.
        :type: str
        """  # noqa: E501
        if bucket_name is None:
            raise ValueError("Invalid value for `bucket_name`, must not be `None`")  # noqa: E501
        self._bucket_name = bucket_name

    @property
    def description(self):
        """Get the description of this BucketMetadataManifest.

        :return: The description of this BucketMetadataManifest.
        :rtype: str
        """  # noqa: E501
        return self._description

    @description.setter
    def description(self, description):
        """Set the description of this BucketMetadataManifest.

        :param description: The description of this BucketMetadataManifest.
        :type: str
        """  # noqa: E501
        self._description = description

    @property
    def default_retention_policy(self):
        """Get the default_retention_policy of this BucketMetadataManifest.

        :return: The default_retention_policy of this BucketMetadataManifest.
        :rtype: str
        """  # noqa: E501
        return self._default_retention_policy

    @default_retention_policy.setter
    def default_retention_policy(self, default_retention_policy):
        """Set the default_retention_policy of this BucketMetadataManifest.

        :param default_retention_policy: The default_retention_policy of this BucketMetadataManifest.
        :type: str
        """  # noqa: E501
        if default_retention_policy is None:
            raise ValueError("Invalid value for `default_retention_policy`, must not be `None`")  # noqa: E501
        self._default_retention_policy = default_retention_policy

    @property
    def retention_policies(self):
        """Get the retention_policies of this BucketMetadataManifest.

        :return: The retention_policies of this BucketMetadataManifest.
        :rtype: list[RetentionPolicyManifest]
        """  # noqa: E501
        return self._retention_policies

    @retention_policies.setter
    def retention_policies(self, retention_policies):
        """Set the retention_policies of this BucketMetadataManifest.

        :param retention_policies: The retention_policies of this BucketMetadataManifest.
        :type: list[RetentionPolicyManifest]
        """  # noqa: E501
        if retention_policies is None:
            raise ValueError("Invalid value for `retention_policies`, must not be `None`")  # noqa: E501
        self._retention_policies = retention_policies

    def to_dict(self):
        """Return the model properties as a dict."""
        result = {}

        for attr, _ in self.openapi_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Return the string representation of the model."""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`."""
        return self.to_str()

    def __eq__(self, other):
        """Return true if both objects are equal."""
        if not isinstance(other, BucketMetadataManifest):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Return true if both objects are not equal."""
        return not self == other
