/*
 * Decompiled with CFR 0.152.
 */
package com.sun.activation.viewers;

import java.awt.Button;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.CommandObject;
import javax.activation.DataHandler;

public class TextEditor
extends Panel
implements CommandObject,
ActionListener {
    private TextArea text_area = null;
    private GridBagLayout panel_gb = new GridBagLayout();
    private Panel button_panel = null;
    private Button save_button = null;
    private File text_file = null;
    private String text_buffer = null;
    private InputStream data_ins = null;
    private FileInputStream fis = null;
    private DataHandler _dh = null;
    private boolean DEBUG = false;

    public TextEditor() {
        this.setLayout(this.panel_gb);
        this.button_panel = new Panel();
        this.button_panel.setLayout(new FlowLayout());
        this.save_button = new Button("SAVE");
        this.button_panel.add(this.save_button);
        this.addGridComponent(this, this.button_panel, this.panel_gb, 0, 0, 1, 1, 1, 0);
        this.text_area = new TextArea("This is text", 24, 80, 1);
        this.text_area.setEditable(true);
        this.addGridComponent(this, this.text_area, this.panel_gb, 0, 1, 1, 2, 1, 1);
        this.save_button.addActionListener(this);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.save_button) {
            this.performSaveOperation();
        }
    }

    private void addGridComponent(Container container, Component component, GridBagLayout gridBagLayout, int n, int n2, int n3, int n4, int n5, int n6) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = n6;
        gridBagConstraints.weightx = n5;
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(component, gridBagConstraints);
        container.add(component);
    }

    public void addNotify() {
        super.addNotify();
        this.invalidate();
    }

    public Dimension getPreferredSize() {
        return this.text_area.getMinimumSize(24, 80);
    }

    private void performSaveOperation() {
        OutputStream outputStream = null;
        try {
            outputStream = this._dh.getOutputStream();
        }
        catch (Exception exception) {}
        String string = this.text_area.getText();
        if (outputStream == null) {
            System.out.println("Invalid outputstream in TextEditor!");
            System.out.println("not saving!");
        }
        try {
            outputStream.write(string.getBytes());
            outputStream.flush();
            outputStream.close();
        }
        catch (IOException iOException) {
            System.out.println("TextEditor Save Operation failed with: " + iOException);
        }
    }

    public void setCommandContext(String string, DataHandler dataHandler) throws IOException {
        this._dh = dataHandler;
        this.setInputStream(this._dh.getInputStream());
    }

    public void setInputStream(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[1024];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n = 0;
        while ((n = inputStream.read(byArray)) > 0) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        inputStream.close();
        this.text_buffer = byteArrayOutputStream.toString();
        this.text_area.setText(this.text_buffer);
    }
}

