/*
 * Decompiled with CFR 0.152.
 */
package jdk.internal.org.objectweb.asm.tree.analysis;

import java.util.ArrayList;
import jdk.internal.org.objectweb.asm.Type;
import jdk.internal.org.objectweb.asm.tree.AbstractInsnNode;
import jdk.internal.org.objectweb.asm.tree.IincInsnNode;
import jdk.internal.org.objectweb.asm.tree.InvokeDynamicInsnNode;
import jdk.internal.org.objectweb.asm.tree.MethodInsnNode;
import jdk.internal.org.objectweb.asm.tree.MultiANewArrayInsnNode;
import jdk.internal.org.objectweb.asm.tree.VarInsnNode;
import jdk.internal.org.objectweb.asm.tree.analysis.AnalyzerException;
import jdk.internal.org.objectweb.asm.tree.analysis.Interpreter;
import jdk.internal.org.objectweb.asm.tree.analysis.Value;

public class Frame<V extends Value> {
    private V returnValue;
    private V[] values;
    private int locals;
    private int top;

    public Frame(int n, int n2) {
        this.values = new Value[n + n2];
        this.locals = n;
    }

    public Frame(Frame<? extends V> frame) {
        this(frame.locals, frame.values.length - frame.locals);
        this.init(frame);
    }

    public Frame<V> init(Frame<? extends V> frame) {
        this.returnValue = frame.returnValue;
        System.arraycopy(frame.values, 0, this.values, 0, this.values.length);
        this.top = frame.top;
        return this;
    }

    public void setReturn(V v) {
        this.returnValue = v;
    }

    public int getLocals() {
        return this.locals;
    }

    public int getMaxStackSize() {
        return this.values.length - this.locals;
    }

    public V getLocal(int n) throws IndexOutOfBoundsException {
        if (n >= this.locals) {
            throw new IndexOutOfBoundsException("Trying to access an inexistant local variable");
        }
        return this.values[n];
    }

    public void setLocal(int n, V v) throws IndexOutOfBoundsException {
        if (n >= this.locals) {
            throw new IndexOutOfBoundsException("Trying to access an inexistant local variable " + n);
        }
        this.values[n] = v;
    }

    public int getStackSize() {
        return this.top;
    }

    public V getStack(int n) throws IndexOutOfBoundsException {
        return this.values[n + this.locals];
    }

    public void clearStack() {
        this.top = 0;
    }

    public V pop() throws IndexOutOfBoundsException {
        if (this.top == 0) {
            throw new IndexOutOfBoundsException("Cannot pop operand off an empty stack.");
        }
        return this.values[--this.top + this.locals];
    }

    public void push(V v) throws IndexOutOfBoundsException {
        if (this.top + this.locals >= this.values.length) {
            throw new IndexOutOfBoundsException("Insufficient maximum stack size.");
        }
        this.values[this.top++ + this.locals] = v;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute(AbstractInsnNode abstractInsnNode, Interpreter<V> interpreter) throws AnalyzerException {
        switch (abstractInsnNode.getOpcode()) {
            case 0: {
                return;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                this.push(interpreter.newOperation(abstractInsnNode));
                return;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                this.push(interpreter.copyOperation(abstractInsnNode, this.getLocal(((VarInsnNode)abstractInsnNode).var)));
                return;
            }
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                V v = this.pop();
                V v2 = this.pop();
                this.push(interpreter.binaryOperation(abstractInsnNode, v2, v));
                return;
            }
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                V v;
                Object e = interpreter.copyOperation(abstractInsnNode, this.pop());
                int n = ((VarInsnNode)abstractInsnNode).var;
                this.setLocal(n, e);
                if (e.getSize() == 2) {
                    this.setLocal(n + 1, interpreter.newValue(null));
                }
                if (n <= 0 || (v = this.getLocal(n - 1)) == null || v.getSize() != 2) return;
                this.setLocal(n - 1, interpreter.newValue(null));
                return;
            }
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: {
                V v = this.pop();
                V v3 = this.pop();
                V v4 = this.pop();
                interpreter.ternaryOperation(abstractInsnNode, v4, v3, v);
                return;
            }
            case 87: {
                if (this.pop().getSize() != 2) return;
                throw new AnalyzerException(abstractInsnNode, "Illegal use of POP");
            }
            case 88: {
                if (this.pop().getSize() != 1 || this.pop().getSize() == 1) return;
                throw new AnalyzerException(abstractInsnNode, "Illegal use of POP2");
            }
            case 89: {
                V v = this.pop();
                if (v.getSize() != 1) {
                    throw new AnalyzerException(abstractInsnNode, "Illegal use of DUP");
                }
                this.push(v);
                this.push(interpreter.copyOperation(abstractInsnNode, v));
                return;
            }
            case 90: {
                V v = this.pop();
                V v5 = this.pop();
                if (v.getSize() != 1 || v5.getSize() != 1) {
                    throw new AnalyzerException(abstractInsnNode, "Illegal use of DUP_X1");
                }
                this.push(interpreter.copyOperation(abstractInsnNode, v));
                this.push(v5);
                this.push(v);
                return;
            }
            case 91: {
                V v = this.pop();
                if (v.getSize() != 1) throw new AnalyzerException(abstractInsnNode, "Illegal use of DUP_X2");
                V v6 = this.pop();
                if (v6.getSize() == 1) {
                    V v7 = this.pop();
                    if (v7.getSize() != 1) throw new AnalyzerException(abstractInsnNode, "Illegal use of DUP_X2");
                    this.push(interpreter.copyOperation(abstractInsnNode, v));
                    this.push(v7);
                    this.push(v6);
                    this.push(v);
                    return;
                }
                this.push(interpreter.copyOperation(abstractInsnNode, v));
                this.push(v6);
                this.push(v);
                return;
            }
            case 92: {
                V v = this.pop();
                if (v.getSize() == 1) {
                    V v8 = this.pop();
                    if (v8.getSize() != 1) throw new AnalyzerException(abstractInsnNode, "Illegal use of DUP2");
                    this.push(v8);
                    this.push(v);
                    this.push(interpreter.copyOperation(abstractInsnNode, v8));
                    this.push(interpreter.copyOperation(abstractInsnNode, v));
                    return;
                }
                this.push(v);
                this.push(interpreter.copyOperation(abstractInsnNode, v));
                return;
            }
            case 93: {
                V v = this.pop();
                if (v.getSize() == 1) {
                    V v9;
                    V v10 = this.pop();
                    if (v10.getSize() != 1 || (v9 = this.pop()).getSize() != 1) throw new AnalyzerException(abstractInsnNode, "Illegal use of DUP2_X1");
                    this.push(interpreter.copyOperation(abstractInsnNode, v10));
                    this.push(interpreter.copyOperation(abstractInsnNode, v));
                    this.push(v9);
                    this.push(v10);
                    this.push(v);
                    return;
                }
                V v11 = this.pop();
                if (v11.getSize() != 1) throw new AnalyzerException(abstractInsnNode, "Illegal use of DUP2_X1");
                this.push(interpreter.copyOperation(abstractInsnNode, v));
                this.push(v11);
                this.push(v);
                return;
            }
            case 94: {
                V v = this.pop();
                if (v.getSize() == 1) {
                    V v12 = this.pop();
                    if (v12.getSize() != 1) throw new AnalyzerException(abstractInsnNode, "Illegal use of DUP2_X2");
                    V v13 = this.pop();
                    if (v13.getSize() == 1) {
                        V v14 = this.pop();
                        if (v14.getSize() != 1) throw new AnalyzerException(abstractInsnNode, "Illegal use of DUP2_X2");
                        this.push(interpreter.copyOperation(abstractInsnNode, v12));
                        this.push(interpreter.copyOperation(abstractInsnNode, v));
                        this.push(v14);
                        this.push(v13);
                        this.push(v12);
                        this.push(v);
                        return;
                    }
                    this.push(interpreter.copyOperation(abstractInsnNode, v12));
                    this.push(interpreter.copyOperation(abstractInsnNode, v));
                    this.push(v13);
                    this.push(v12);
                    this.push(v);
                    return;
                }
                V v15 = this.pop();
                if (v15.getSize() == 1) {
                    V v16 = this.pop();
                    if (v16.getSize() != 1) throw new AnalyzerException(abstractInsnNode, "Illegal use of DUP2_X2");
                    this.push(interpreter.copyOperation(abstractInsnNode, v));
                    this.push(v16);
                    this.push(v15);
                    this.push(v);
                    return;
                }
                this.push(interpreter.copyOperation(abstractInsnNode, v));
                this.push(v15);
                this.push(v);
                return;
            }
            case 95: {
                V v = this.pop();
                V v17 = this.pop();
                if (v17.getSize() != 1 || v.getSize() != 1) {
                    throw new AnalyzerException(abstractInsnNode, "Illegal use of SWAP");
                }
                this.push(interpreter.copyOperation(abstractInsnNode, v));
                this.push(interpreter.copyOperation(abstractInsnNode, v17));
                return;
            }
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: {
                V v = this.pop();
                V v18 = this.pop();
                this.push(interpreter.binaryOperation(abstractInsnNode, v18, v));
                return;
            }
            case 116: 
            case 117: 
            case 118: 
            case 119: {
                this.push(interpreter.unaryOperation(abstractInsnNode, this.pop()));
                return;
            }
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: {
                V v = this.pop();
                V v19 = this.pop();
                this.push(interpreter.binaryOperation(abstractInsnNode, v19, v));
                return;
            }
            case 132: {
                int n = ((IincInsnNode)abstractInsnNode).var;
                this.setLocal(n, interpreter.unaryOperation(abstractInsnNode, this.getLocal(n)));
                return;
            }
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 147: {
                this.push(interpreter.unaryOperation(abstractInsnNode, this.pop()));
                return;
            }
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: {
                V v = this.pop();
                V v20 = this.pop();
                this.push(interpreter.binaryOperation(abstractInsnNode, v20, v));
                return;
            }
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: {
                interpreter.unaryOperation(abstractInsnNode, this.pop());
                return;
            }
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: {
                V v = this.pop();
                V v21 = this.pop();
                interpreter.binaryOperation(abstractInsnNode, v21, v);
                return;
            }
            case 167: {
                return;
            }
            case 168: {
                this.push(interpreter.newOperation(abstractInsnNode));
                return;
            }
            case 169: {
                return;
            }
            case 170: 
            case 171: {
                interpreter.unaryOperation(abstractInsnNode, this.pop());
                return;
            }
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: {
                V v = this.pop();
                interpreter.unaryOperation(abstractInsnNode, v);
                interpreter.returnOperation(abstractInsnNode, v, this.returnValue);
                return;
            }
            case 177: {
                if (this.returnValue == null) return;
                throw new AnalyzerException(abstractInsnNode, "Incompatible return type");
            }
            case 178: {
                this.push(interpreter.newOperation(abstractInsnNode));
                return;
            }
            case 179: {
                interpreter.unaryOperation(abstractInsnNode, this.pop());
                return;
            }
            case 180: {
                this.push(interpreter.unaryOperation(abstractInsnNode, this.pop()));
                return;
            }
            case 181: {
                V v = this.pop();
                V v22 = this.pop();
                interpreter.binaryOperation(abstractInsnNode, v22, v);
                return;
            }
            case 182: 
            case 183: 
            case 184: 
            case 185: {
                ArrayList<V> arrayList = new ArrayList<V>();
                String string = ((MethodInsnNode)abstractInsnNode).desc;
                for (int i = Type.getArgumentTypes(string).length; i > 0; --i) {
                    arrayList.add(0, this.pop());
                }
                if (abstractInsnNode.getOpcode() != 184) {
                    arrayList.add(0, this.pop());
                }
                if (Type.getReturnType(string) == Type.VOID_TYPE) {
                    interpreter.naryOperation(abstractInsnNode, arrayList);
                    return;
                }
                this.push(interpreter.naryOperation(abstractInsnNode, arrayList));
                return;
            }
            case 186: {
                ArrayList<V> arrayList = new ArrayList<V>();
                String string = ((InvokeDynamicInsnNode)abstractInsnNode).desc;
                for (int i = Type.getArgumentTypes(string).length; i > 0; --i) {
                    arrayList.add(0, this.pop());
                }
                if (Type.getReturnType(string) == Type.VOID_TYPE) {
                    interpreter.naryOperation(abstractInsnNode, arrayList);
                    return;
                }
                this.push(interpreter.naryOperation(abstractInsnNode, arrayList));
                return;
            }
            case 187: {
                this.push(interpreter.newOperation(abstractInsnNode));
                return;
            }
            case 188: 
            case 189: 
            case 190: {
                this.push(interpreter.unaryOperation(abstractInsnNode, this.pop()));
                return;
            }
            case 191: {
                interpreter.unaryOperation(abstractInsnNode, this.pop());
                return;
            }
            case 192: 
            case 193: {
                this.push(interpreter.unaryOperation(abstractInsnNode, this.pop()));
                return;
            }
            case 194: 
            case 195: {
                interpreter.unaryOperation(abstractInsnNode, this.pop());
                return;
            }
            case 197: {
                ArrayList<V> arrayList = new ArrayList<V>();
                for (int i = ((MultiANewArrayInsnNode)abstractInsnNode).dims; i > 0; --i) {
                    arrayList.add(0, this.pop());
                }
                this.push(interpreter.naryOperation(abstractInsnNode, arrayList));
                return;
            }
            case 198: 
            case 199: {
                interpreter.unaryOperation(abstractInsnNode, this.pop());
                return;
            }
            default: {
                throw new RuntimeException("Illegal opcode " + abstractInsnNode.getOpcode());
            }
        }
    }

    public boolean merge(Frame<? extends V> frame, Interpreter<V> interpreter) throws AnalyzerException {
        if (this.top != frame.top) {
            throw new AnalyzerException(null, "Incompatible stack heights");
        }
        boolean bl = false;
        for (int i = 0; i < this.locals + this.top; ++i) {
            V v = interpreter.merge(this.values[i], frame.values[i]);
            if (v.equals(this.values[i])) continue;
            this.values[i] = v;
            bl = true;
        }
        return bl;
    }

    public boolean merge(Frame<? extends V> frame, boolean[] blArray) {
        boolean bl = false;
        for (int i = 0; i < this.locals; ++i) {
            if (blArray[i] || this.values[i].equals(frame.values[i])) continue;
            this.values[i] = frame.values[i];
            bl = true;
        }
        return bl;
    }

    public String toString() {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        for (n = 0; n < this.getLocals(); ++n) {
            stringBuilder.append(this.getLocal(n));
        }
        stringBuilder.append(' ');
        for (n = 0; n < this.getStackSize(); ++n) {
            stringBuilder.append(this.getStack(n).toString());
        }
        return stringBuilder.toString();
    }
}

