/*
 * Decompiled with CFR 0.152.
 */
package com.ca.directory.jxplorer;

import com.ca.commons.cbutil.CBDialog;
import com.ca.commons.cbutil.CBFileFilter;
import com.ca.commons.cbutil.CBIntText;
import com.ca.commons.cbutil.CBUtility;
import com.ca.commons.cbutil.CBpbar;
import com.ca.commons.naming.DN;
import com.ca.commons.naming.DXEntry;
import com.ca.commons.naming.DXNamingEnumeration;
import com.ca.commons.naming.LdifUtility;
import com.ca.directory.jxplorer.DataQuery;
import com.ca.directory.jxplorer.DataSource;
import com.ca.directory.jxplorer.JXplorer;
import com.ca.directory.jxplorer.broker.Broker;
import com.ca.directory.jxplorer.tree.SmartTree;
import java.awt.Component;
import java.awt.Frame;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NameClassPair;
import javax.naming.NamingException;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class LdifExport
extends CBDialog {
    JTextArea rootDN;
    JTextArea newRootDN;
    DataSource dataSource;
    SmartTree searchTree;
    SmartTree schemaTree;
    FileWriter saveFile;
    LdifUtility ldifutil = new LdifUtility();
    boolean usingSearch;
    CBpbar pbar;
    static String lastDirectory = null;
    private static Logger log = Logger.getLogger(LdifExport.class.getName());

    public LdifExport(DN D, DataSource broker, SmartTree searchTree, boolean usingSearch, Frame owner) {
        this(D, broker, searchTree, usingSearch, owner, "ldif.export.tree");
    }

    public LdifExport(DN D, DataSource broker, SmartTree searchTree, boolean usingSearch, Frame owner, String helpID) {
        super(owner, CBIntText.get("LDIF Export"), helpID);
        this.OK.setToolTipText(CBIntText.get("Perform the LDIF export"));
        this.Cancel.setToolTipText(CBIntText.get("Cancel without performing an LDIF export"));
        this.Help.setToolTipText(CBIntText.get("Display help about LDIF exporting"));
        if (D == null) {
            D = new DN();
        }
        this.dataSource = broker;
        this.searchTree = searchTree;
        this.usingSearch = usingSearch;
        this.display.add((Component)new JLabel(CBIntText.get("Root DN")), 0, 0);
        this.display.makeHeavy();
        this.rootDN = new JTextArea(D.toString());
        this.rootDN.setLineWrap(true);
        this.display.add((Component)new JScrollPane(this.rootDN, 20, 31), 1, 0);
        this.display.makeLight();
        this.display.add((Component)new JLabel(CBIntText.get("New root DN")), 0, 1);
        this.display.makeHeavy();
        this.newRootDN = new JTextArea(D.toString());
        this.newRootDN.setLineWrap(true);
        this.display.add((Component)new JScrollPane(this.newRootDN, 20, 31), 1, 1);
        this.display.makeLight();
    }

    protected File adjustFileName(File readFile) {
        if (readFile == null) {
            return null;
        }
        if (readFile.exists()) {
            return readFile;
        }
        String name = readFile.getName();
        if (name.indexOf(46) != -1) {
            return readFile;
        }
        name = name + ".ldif";
        return new File(readFile.getParentFile(), name);
    }

    public void doOK() {
        if (!this.checkRootDN()) {
            return;
        }
        this.setVisible(false);
        JFileChooser chooser = new JFileChooser(JXplorer.getProperty("ldif.homeDir"));
        chooser.addChoosableFileFilter(new CBFileFilter(new String[]{"ldif", "ldi"}, "Ldif Files (*.ldif, *.ldi)"));
        int option = chooser.showSaveDialog(this);
        if (option == 0) {
            File readFile = chooser.getSelectedFile();
            if (readFile == null) {
                CBUtility.error(CBIntText.get("Please select a file"));
            } else {
                readFile = this.adjustFileName(readFile);
                int response = -1;
                if (readFile.exists() && (response = JOptionPane.showConfirmDialog(this, CBIntText.get("File ''{0}'' already exsists.  Do you want to replace it?", new String[]{readFile.toString()}), CBIntText.get("Overwrite Confirmation"), 0)) != 0) {
                    this.setVisible(true);
                    return;
                }
                JXplorer.setProperty("ldif.homeDir", readFile.getParent());
                this.doFileWrite(readFile);
            }
        }
    }

    public boolean checkRootDN() {
        String oldRoot = this.rootDN.getText().trim();
        String newRoot = this.newRootDN.getText().trim();
        if (!(oldRoot != null && oldRoot.length() > 0 || newRoot != null && newRoot.length() > 0)) {
            int response = JOptionPane.showConfirmDialog(this, CBIntText.get("Without a 'Root DN' and a 'New Root DN', the full tree will be exported.  Do you want to continue?"), CBIntText.get("Export Full Tree"), 0);
            return response == 0;
        }
        if (oldRoot == null || oldRoot.length() <= 0) {
            JOptionPane.showMessageDialog(this, CBIntText.get("Please enter a 'Root DN'."), CBIntText.get("Root DN"), 1);
            return false;
        }
        if (newRoot == null || newRoot.length() <= 0) {
            JOptionPane.showMessageDialog(this, CBIntText.get("Please enter a 'New Root DN'."), CBIntText.get("New Root DN"), 1);
            return false;
        }
        return true;
    }

    protected void doFileWrite(File saveFile) {
        if (saveFile == null) {
            CBUtility.error(CBIntText.get("Unable to write to empty file"), null);
        }
        final File myFile = saveFile;
        this.dataSource.extendedRequest(new DataQuery(256){

            public void doExtendedRequest(Broker b) {
                try {
                    FileWriter myFileWriter = new FileWriter(myFile);
                    LdifExport.this.pbar = new CBpbar(LdifExport.this, CBIntText.get("Saving LDIF file"), CBIntText.get("Saving Data"));
                    myFileWriter.write("version: 1\n");
                    DN oldRoot = new DN(LdifExport.this.rootDN.getText());
                    DN newRoot = new DN(LdifExport.this.newRootDN.getText());
                    if (LdifExport.this.usingSearch) {
                        Vector bloop = LdifExport.this.searchTree.getAllNodes(new DN(LdifExport.this.rootDN.getText()));
                        LdifExport.this.saveLdifList(bloop, myFileWriter, oldRoot.toString(), newRoot.toString(), b);
                    } else {
                        LdifExport.this.saveLdifTree(oldRoot, myFileWriter, oldRoot.toString(), newRoot.toString(), b);
                    }
                    myFileWriter.close();
                }
                catch (Exception e) {
                    this.setException(e);
                }
                if (LdifExport.this.pbar.isCanceled()) {
                    myFile.delete();
                }
                LdifExport.this.closeDown();
            }
        });
    }

    public boolean saveLdifTree(DN treeApex, FileWriter saveFile, String origPrefix, String newPrefix, Broker broker) {
        if (treeApex == null) {
            return false;
        }
        if (this.pbar == null) {
            return false;
        }
        if (newPrefix == null) {
            origPrefix = null;
        }
        if (origPrefix != null && origPrefix.equals(newPrefix)) {
            origPrefix = null;
            newPrefix = null;
        }
        if (this.pbar.isCanceled()) {
            return false;
        }
        DXEntry atts = null;
        try {
            if (!treeApex.isEmpty()) {
                atts = broker.unthreadedReadEntry(treeApex, null);
            }
            if (atts != null) {
                DN escapeMe = new DN(treeApex);
                this.ldifutil.writeLdifEntry(escapeMe.toString(), saveFile, origPrefix, newPrefix, atts);
            }
            DXNamingEnumeration children = broker.unthreadedList(treeApex);
            this.pbar.push(children.size());
            while (children != null && children.hasMore()) {
                String subDNString = ((NameClassPair)children.next()).getName();
                DN child = new DN(treeApex);
                DN subDN = new DN(subDNString);
                child.addChildRDN(subDN.getLowestRDN());
                if (this.saveLdifTree(child, saveFile, origPrefix, newPrefix, broker)) continue;
                return false;
            }
        }
        catch (NamingException e) {
            CBUtility.error(this, CBIntText.get("Unable to read dn: {0} from directory", new String[]{treeApex.toString()}), (Exception)e);
        }
        catch (Exception e) {
            CBUtility.error(this, CBIntText.get("General error reading dn: {0} from directory", new String[]{treeApex.toString()}), e);
            e.printStackTrace();
        }
        this.pbar.pop();
        this.pbar.inc();
        return true;
    }

    public void saveLdifList(Vector dns, FileWriter saveFile, String originalPrefix, String replacementPrefix, Broker broker) {
        if (replacementPrefix == null) {
            originalPrefix = null;
        }
        if (originalPrefix != null && originalPrefix.equals(replacementPrefix)) {
            originalPrefix = null;
            replacementPrefix = null;
        }
        int size = dns.size();
        this.pbar.push(size);
        for (int i = 0; i < size; ++i) {
            DN dn = (DN)dns.elementAt(i);
            try {
                DXEntry atts = broker.unthreadedReadEntry(dn, null);
                this.ldifutil.writeLdifEntry(dn.toString(), saveFile, originalPrefix, replacementPrefix, atts);
            }
            catch (NamingException e) {
                log.log(Level.WARNING, "Unable to read dn: '" + dn.toString() + "' from directory ", e);
            }
            catch (Exception e) {
                log.log(Level.WARNING, "General error reading: dn: '" + dn.toString() + "' from directory ", e);
            }
            if (this.pbar.isCanceled()) {
                return;
            }
            this.pbar.inc();
        }
        this.pbar.close();
    }

    private void closeDown() {
        try {
            if (this.saveFile != null) {
                this.saveFile.close();
            }
            log.warning("Closed LDIF file");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.pbar != null) {
            this.pbar.close();
        }
        this.setVisible(false);
        this.dispose();
    }
}

