from dataclasses import dataclass
from typing import Any, Type, Optional

from wapitiCore.definitions.base import FindingBase


@dataclass
class VulnerabilityInstance:
    finding_class: Type[FindingBase] # Référence à la définition de la vulnérabilité
    request: Any # L'objet Request associé (ou un identifiant/représentation)
    response: Any # L'objet Response associé (pour les passifs)
    info: str
    severity: int
    parameter: Optional[str] = None
