/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.generator.values;

import org.hibernate.generator.values.internal.GeneratedValuesHelper;
import org.hibernate.metamodel.mapping.BasicValuedModelPart;
import org.hibernate.query.results.ResultBuilder;
import org.hibernate.query.results.internal.DomainResultCreationStateImpl;
import org.hibernate.query.results.internal.ResultsHelper;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.basic.BasicResult;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesMetadata;

public class GeneratedValueBasicResultBuilder
implements ResultBuilder {
    private final NavigablePath navigablePath;
    private final BasicValuedModelPart modelPart;
    private final Integer valuesArrayPosition;
    private final TableGroup tableGroup;

    public GeneratedValueBasicResultBuilder(NavigablePath navigablePath, BasicValuedModelPart modelPart, TableGroup tableGroup, Integer valuesArrayPosition) {
        this.navigablePath = navigablePath;
        this.modelPart = modelPart;
        this.valuesArrayPosition = valuesArrayPosition;
        this.tableGroup = tableGroup;
    }

    @Override
    public Class<?> getJavaType() {
        return this.modelPart.getExpressibleJavaType().getJavaTypeClass();
    }

    @Override
    public ResultBuilder cacheKeyInstance() {
        return this;
    }

    public BasicResult<?> buildResult(JdbcValuesMetadata jdbcResultsMetadata, int resultPosition, DomainResultCreationState domainResultCreationState) {
        return new BasicResult(this.sqlSelection(jdbcResultsMetadata, domainResultCreationState).getValuesArrayPosition(), null, this.modelPart.getJdbcMapping(), this.navigablePath, false, false);
    }

    private SqlSelection sqlSelection(JdbcValuesMetadata jdbcResultsMetadata, DomainResultCreationState domainResultCreationState) {
        DomainResultCreationStateImpl creationStateImpl = ResultsHelper.impl(domainResultCreationState);
        return this.sqlSelection(jdbcResultsMetadata, creationStateImpl, this.tableReference(creationStateImpl));
    }

    private TableReference tableReference(DomainResultCreationStateImpl creationStateImpl) {
        return creationStateImpl.getFromClauseAccess().resolveTableGroup(this.navigablePath.getParent(), path -> this.tableGroup).resolveTableReference(this.navigablePath, this.modelPart, "t");
    }

    private SqlSelection sqlSelection(JdbcValuesMetadata jdbcResultsMetadata, DomainResultCreationStateImpl creationStateImpl, TableReference tableReference) {
        return creationStateImpl.resolveSqlSelection(ResultsHelper.resolveSqlExpression(creationStateImpl, tableReference, this.modelPart, this.valuesArrayPosition != null ? this.valuesArrayPosition : GeneratedValueBasicResultBuilder.columnIndex(jdbcResultsMetadata, this.modelPart)), this.modelPart.getJdbcMapping().getJdbcJavaType(), null, creationStateImpl.getSessionFactory().getTypeConfiguration());
    }

    public BasicValuedModelPart getModelPart() {
        return this.modelPart;
    }

    private static int columnIndex(JdbcValuesMetadata jdbcResultsMetadata, BasicValuedModelPart modelPart) {
        if (jdbcResultsMetadata.getColumnCount() == 1) {
            assert (modelPart.isEntityIdentifierMapping() || GeneratedValueBasicResultBuilder.getColumnPosition(jdbcResultsMetadata, modelPart) == 1);
            return 0;
        }
        return ResultsHelper.jdbcPositionToValuesArrayPosition(GeneratedValueBasicResultBuilder.getColumnPosition(jdbcResultsMetadata, modelPart));
    }

    private static int getColumnPosition(JdbcValuesMetadata valuesMetadata, BasicValuedModelPart modelPart) {
        return valuesMetadata.resolveColumnPosition(GeneratedValuesHelper.getActualGeneratedModelPart(modelPart).getSelectionExpression());
    }
}

