/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.runtime;

import io.quarkus.hibernate.orm.runtime.HibernateOrmRuntimeConfig;
import io.quarkus.hibernate.orm.runtime.HibernateOrmRuntimeConfigPersistenceUnit;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.runtime.configuration.ConfigurationException;
import java.util.Map;
import java.util.Set;

@Recorder
public class HibernateOrmDisabledRecorder {
    private final RuntimeValue<HibernateOrmRuntimeConfig> runtimeConfig;

    public HibernateOrmDisabledRecorder(RuntimeValue<HibernateOrmRuntimeConfig> runtimeConfig) {
        this.runtimeConfig = runtimeConfig;
    }

    public void checkNoExplicitActiveTrue() {
        for (Map.Entry<String, HibernateOrmRuntimeConfigPersistenceUnit> entry : ((HibernateOrmRuntimeConfig)this.runtimeConfig.getValue()).persistenceUnits().entrySet()) {
            HibernateOrmRuntimeConfigPersistenceUnit config = entry.getValue();
            if (!config.active().isPresent() || !config.active().get().booleanValue()) continue;
            String puName = entry.getKey();
            String enabledPropertyKey = HibernateOrmRuntimeConfig.extensionPropertyKey("enabled");
            String activePropertyKey = HibernateOrmRuntimeConfig.puPropertyKey(puName, "active");
            throw new ConfigurationException("Hibernate ORM activated explicitly for persistence unit '" + puName + "', but the Hibernate ORM extension was disabled at build time. If you want Hibernate ORM to be active for this persistence unit, you must set '" + enabledPropertyKey + "' to 'true' at build time. If you don't want Hibernate ORM to be active for this persistence unit, you must leave '" + activePropertyKey + "' unset or set it to 'false'.", Set.of(enabledPropertyKey, activePropertyKey));
        }
    }
}

