/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.jaas.config.impl;

import org.apache.karaf.jaas.boot.ProxyLoginModule;
import org.apache.karaf.jaas.config.JaasRealm;
import org.apache.karaf.jaas.config.KeystoreInstance;
import org.apache.karaf.jaas.config.KeystoreManager;
import org.apache.karaf.jaas.config.impl.OsgiConfiguration;
import org.apache.karaf.jaas.config.impl.OsgiKeystoreManager;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class Activator
implements BundleActivator {
    private OsgiConfiguration osgiConfiguration;
    private ServiceRegistration<KeystoreManager> registration;
    private ServiceTracker<KeystoreInstance, KeystoreInstance> keystoreInstanceServiceTracker;
    private ServiceTracker<JaasRealm, JaasRealm> jaasRealmServiceTracker;

    public void start(final BundleContext context) throws Exception {
        ProxyLoginModule.init((BundleContext)context.getBundle(0L).getBundleContext());
        final OsgiKeystoreManager keystoreManager = new OsgiKeystoreManager();
        this.keystoreInstanceServiceTracker = new ServiceTracker(context, KeystoreInstance.class, (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<KeystoreInstance, KeystoreInstance>(){

            public KeystoreInstance addingService(ServiceReference<KeystoreInstance> reference) {
                KeystoreInstance service = (KeystoreInstance)context.getService(reference);
                keystoreManager.register(service, null);
                return service;
            }

            public void modifiedService(ServiceReference<KeystoreInstance> reference, KeystoreInstance service) {
            }

            public void removedService(ServiceReference<KeystoreInstance> reference, KeystoreInstance service) {
                keystoreManager.unregister(service, null);
                context.ungetService(reference);
            }
        });
        this.keystoreInstanceServiceTracker.open();
        this.osgiConfiguration = new OsgiConfiguration();
        this.osgiConfiguration.init();
        this.jaasRealmServiceTracker = new ServiceTracker(context, JaasRealm.class, (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<JaasRealm, JaasRealm>(){

            public JaasRealm addingService(ServiceReference<JaasRealm> reference) {
                JaasRealm service = (JaasRealm)context.getService(reference);
                Activator.this.osgiConfiguration.register(service, null);
                return service;
            }

            public void modifiedService(ServiceReference<JaasRealm> reference, JaasRealm service) {
            }

            public void removedService(ServiceReference<JaasRealm> reference, JaasRealm service) {
                Activator.this.osgiConfiguration.unregister(service, null);
            }
        });
        this.jaasRealmServiceTracker.open();
        this.registration = context.registerService(KeystoreManager.class, (Object)keystoreManager, null);
    }

    public void stop(BundleContext context) throws Exception {
        this.registration.unregister();
        this.keystoreInstanceServiceTracker.close();
        this.jaasRealmServiceTracker.close();
        this.osgiConfiguration.close();
    }
}

