/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.modules.appui.welcome;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.net.URI;
import java.net.URL;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import org.graalvm.visualvm.core.ui.DesktopUtils;
import org.graalvm.visualvm.modules.appui.AboutAction;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;

public class Utils {
    private static final Logger LOGGER = Logger.getLogger(AboutAction.class.getName());

    private Utils() {
    }

    public static Graphics2D prepareGraphics(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        Map rhints = (Map)Toolkit.getDefaultToolkit().getDesktopProperty("awt.font.desktophints");
        if (rhints == null && Boolean.getBoolean("swing.aatext")) {
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        } else if (rhints != null) {
            g2.addRenderingHints(rhints);
        }
        return g2;
    }

    public static void showURL(String href) {
        boolean opened = false;
        if (DesktopUtils.isBrowseAvailable()) {
            try {
                URL url = new URL(href);
                DesktopUtils.browse((URI)url.toURI());
                opened = true;
            }
            catch (Exception e) {
                LOGGER.throwing(Utils.class.getName(), "showURL", e);
            }
        }
        if (!opened) {
            JOptionPane.showMessageDialog(null, "<html><b>Unable to launch web browser.</b><br><br>Please open the following link manually:<br><code>" + href + "</code></html>", "Unable To Launch Web Browser", 0);
        }
    }

    static int getDefaultFontSize() {
        Integer customFontSize = (Integer)UIManager.get("customFontSize");
        if (customFontSize != null) {
            return customFontSize;
        }
        Font systemDefaultFont = UIManager.getFont("TextField.font");
        return systemDefaultFont != null ? systemDefaultFont.getSize() : 12;
    }

    public static Color getColor(String resId) {
        ResourceBundle bundle = NbBundle.getBundle((String)"org.graalvm.visualvm.modules.appui.welcome.resources.Bundle");
        try {
            Integer rgb = Integer.decode(bundle.getString(resId));
            return new Color(rgb);
        }
        catch (NumberFormatException nfE) {
            ErrorManager.getDefault().notify(1, (Throwable)nfE);
            return Color.BLACK;
        }
    }
}

