/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.webapp;

import java.io.IOException;
import java.net.URL;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.jetty.util.ConcurrentHashSet;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.annotation.ManagedOperation;
import org.eclipse.jetty.webapp.WebAppClassLoader;

@ManagedObject
public class CachingWebAppClassLoader
extends WebAppClassLoader {
    private final ConcurrentHashSet<String> _notFound = new ConcurrentHashSet();
    private final ConcurrentHashMap<String, URL> _cache = new ConcurrentHashMap();

    public CachingWebAppClassLoader(ClassLoader parent, WebAppClassLoader.Context context) throws IOException {
        super(parent, context);
    }

    public CachingWebAppClassLoader(WebAppClassLoader.Context context) throws IOException {
        super(context);
    }

    @Override
    public URL getResource(String name) {
        if (this._notFound.contains((Object)name)) {
            return null;
        }
        URL url = this._cache.get(name);
        if (name == null) {
            url = super.getResource(name);
            if (url == null) {
                this._notFound.add((Object)name);
            } else {
                this._cache.putIfAbsent(name, url);
            }
        }
        return url;
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (this._notFound.contains((Object)name)) {
            throw new ClassNotFoundException(name + ": in notfound cache");
        }
        try {
            return super.loadClass(name, resolve);
        }
        catch (ClassNotFoundException nfe) {
            this._notFound.add((Object)name);
            throw nfe;
        }
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        if (this._notFound.contains((Object)name)) {
            throw new ClassNotFoundException(name + ": in notfound cache");
        }
        try {
            return super.findClass(name);
        }
        catch (ClassNotFoundException nfe) {
            this._notFound.add((Object)name);
            throw nfe;
        }
    }

    @ManagedOperation
    public void clearCache() {
        this._cache.clear();
        this._notFound.clear();
    }

    @Override
    public String toString() {
        return "Caching[" + super.toString() + "]";
    }
}

