/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.types;

import org.apache.derby.shared.common.error.StandardException;

class DateTimeParser {
    private String str;
    private int len;
    private int fieldStart;
    private char currentSeparator;

    DateTimeParser(String str) {
        this.str = str;
        this.len = str.length();
    }

    int parseInt(int maxDigits, boolean truncationAllowed, char[] separator, boolean isFraction) throws StandardException {
        char c;
        int number = 0;
        int digitCount = 0;
        while (this.fieldStart < this.len && Character.isDigit(c = this.str.charAt(this.fieldStart))) {
            if (digitCount >= maxDigits) {
                throw StandardException.newException((String)"22007.S.181", (Object[])new Object[0]);
            }
            ++digitCount;
            number = number * 10 + Character.digit(c, 10);
            ++this.fieldStart;
        }
        if (truncationAllowed ? digitCount == 0 && !isFraction : digitCount != maxDigits) {
            throw StandardException.newException((String)"22007.S.181", (Object[])new Object[0]);
        }
        this.updateCurrentSeparator();
        if (separator == null) {
            if (this.fieldStart < this.len) {
                ++this.fieldStart;
            }
        } else {
            int sepIdx;
            for (sepIdx = 0; sepIdx < separator.length; ++sepIdx) {
                int j;
                if (separator[sepIdx] != '\u0000') {
                    if (this.currentSeparator != separator[sepIdx]) continue;
                    ++this.fieldStart;
                    break;
                }
                for (j = this.fieldStart; j < this.len && this.str.charAt(j) == ' '; ++j) {
                }
                if (j != this.len) continue;
                this.fieldStart = j;
                break;
            }
            if (sepIdx >= separator.length) {
                throw StandardException.newException((String)"22007.S.181", (Object[])new Object[0]);
            }
        }
        if (isFraction) {
            for (int i = digitCount; i < maxDigits; ++i) {
                number *= 10;
            }
        }
        return number;
    }

    int parseChoice(String[] choices) throws StandardException {
        for (int choiceIdx = 0; choiceIdx < choices.length; ++choiceIdx) {
            int i;
            String choice = choices[choiceIdx];
            int choiceLen = choice.length();
            if (this.fieldStart + choiceLen > this.len) continue;
            for (i = 0; i < choiceLen && choice.charAt(i) == this.str.charAt(this.fieldStart + i); ++i) {
            }
            if (i != choiceLen) continue;
            this.fieldStart += choiceLen;
            this.updateCurrentSeparator();
            return choiceIdx;
        }
        throw StandardException.newException((String)"22007.S.181", (Object[])new Object[0]);
    }

    private void updateCurrentSeparator() {
        if (this.fieldStart >= this.len) {
            this.currentSeparator = '\u0000';
        } else {
            this.currentSeparator = this.str.charAt(this.fieldStart);
            if (this.currentSeparator == ' ') {
                for (int i = this.fieldStart + 1; i < this.len; ++i) {
                    if (this.str.charAt(i) == ' ') continue;
                    return;
                }
                this.currentSeparator = '\u0000';
                this.fieldStart = this.len;
            }
        }
    }

    void checkEnd() throws StandardException {
        while (this.fieldStart < this.len) {
            if (this.str.charAt(this.fieldStart) != ' ') {
                throw StandardException.newException((String)"22007.S.181", (Object[])new Object[0]);
            }
            ++this.fieldStart;
        }
        this.currentSeparator = '\u0000';
    }

    char nextSeparator() {
        for (int i = this.fieldStart + 1; i < this.len; ++i) {
            char c = this.str.charAt(i);
            if (Character.isLetterOrDigit(c)) continue;
            return c;
        }
        return '\u0000';
    }

    char getCurrentSeparator() {
        return this.currentSeparator;
    }
}

