/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.transport;

import java.io.IOException;
import java.io.Serializable;
import java.net.ServerSocket;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.smi.Address;
import org.snmp4j.transport.AbstractSocketEntry;
import org.snmp4j.transport.AbstractTransportMapping;
import org.snmp4j.transport.ConnectionOrientedTransportMapping;
import org.snmp4j.transport.SocketTimeout;
import org.snmp4j.transport.TransportStateEvent;
import org.snmp4j.util.WorkerTask;

public abstract class AbstractConnectionOrientedTransportMapping<A extends Address, S extends AbstractSocketEntry<A>>
extends AbstractTransportMapping<A>
implements ConnectionOrientedTransportMapping<A> {
    private static final LogAdapter logger = LogFactory.getLogger(AbstractConnectionOrientedTransportMapping.class);
    protected boolean serverEnabled = false;
    protected Map<A, S> sockets = new ConcurrentHashMap<A, S>();
    private int maxBusyLoops = 100;

    protected synchronized void timeoutSocket(AbstractSocketEntry<A> entry) {
        if (this.connectionTimeout > 0L && this.getSocketCleaner() != null) {
            SocketTimeout<A> socketTimeout = new SocketTimeout<A>(this, entry);
            entry.setSocketTimeout(socketTimeout);
            this.getSocketCleaner().schedule(socketTimeout, this.connectionTimeout);
        }
    }

    @Override
    public long getConnectionTimeout() {
        return this.connectionTimeout;
    }

    @Override
    public void setConnectionTimeout(long connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    protected void setSocketOptions(ServerSocket serverSocket) {
    }

    @Override
    public boolean isServerEnabled() {
        return this.serverEnabled;
    }

    @Override
    public void setServerEnabled(boolean serverEnabled) {
        this.serverEnabled = serverEnabled;
    }

    protected void closeSockets(Map<A, S> sockets) {
        LinkedList closedSockets = new LinkedList();
        for (AbstractSocketEntry entry : sockets.values()) {
            SocketChannel sc = entry.getSocketChannel();
            if (sc == null) continue;
            try {
                try {
                    sc.socket().close();
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    sc.close();
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Serializable)((Object)("Socket channel to " + String.valueOf(entry.getPeerAddress()) + " closed")));
                }
                TransportStateEvent e = new TransportStateEvent(this, (Address)entry.getPeerAddress(), 4, null);
                this.fireConnectionStateChanged(e);
                closedSockets.add(entry.getPeerAddress());
            }
            catch (IOException iox) {
                logger.debug(iox);
            }
        }
        for (Address remoteAddress : closedSockets) {
            sockets.remove(remoteAddress);
        }
    }

    @Override
    public synchronized boolean close(A remoteAddress) throws IOException {
        AbstractSocketEntry entry;
        if (logger.isDebugEnabled()) {
            logger.debug((Serializable)((Object)("Closing socket for peer address " + String.valueOf(remoteAddress))));
        }
        if ((entry = (AbstractSocketEntry)this.sockets.remove(remoteAddress)) != null) {
            SocketChannel sc;
            if (entry.getSocketTimeout() != null) {
                entry.getSocketTimeout().cancel();
            }
            if ((sc = entry.getSocketChannel()) != null) {
                block7: {
                    try {
                        sc.socket().close();
                    }
                    catch (UnsupportedOperationException unsupportedOperationException) {
                        sc.close();
                        if (!logger.isDebugEnabled()) break block7;
                        logger.debug((Serializable)((Object)("Closed socket channel for peer address " + String.valueOf(remoteAddress))));
                    }
                }
                if (logger.isInfoEnabled()) {
                    logger.info("Socket to " + String.valueOf(entry.getPeerAddress()) + " closed");
                }
                TransportStateEvent e = new TransportStateEvent(this, (Address)entry.getPeerAddress(), 4, null);
                this.fireConnectionStateChanged(e);
            }
            return true;
        }
        return false;
    }

    @Override
    public void close() throws IOException {
        for (AbstractSocketEntry entry : this.sockets.values()) {
            entry.closeSession();
            TransportStateEvent e = new TransportStateEvent(this, (Address)entry.getPeerAddress(), 4, null);
            this.fireConnectionStateChanged(e);
        }
        WorkerTask st = this.listenWorkerTask;
        this.listenWorkerTask = null;
        if (st != null) {
            st.terminate();
            st.interrupt();
            try {
                st.join();
            }
            catch (InterruptedException ex) {
                logger.warn(ex);
            }
            this.closeSockets(this.sockets);
            if (this.getSocketCleaner() != null) {
                this.getSocketCleaner().cancel();
            }
            this.socketCleaner = null;
        }
    }

    public abstract void wakeupServerSelector();

    public Map<A, S> getSockets() {
        return Collections.unmodifiableMap(this.sockets);
    }

    protected void cancelNonServerSelectionKey(SelectionKey sk) {
        if (!sk.isAcceptable()) {
            sk.cancel();
        }
    }

    protected int getMaxBusyLoops() {
        return this.maxBusyLoops;
    }

    protected void setMaxBusyLoops(int maxBusyLoops) {
        this.maxBusyLoops = maxBusyLoops;
    }
}

